/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateContentTests
extends WebDavTest {
    UserModel managerUser;
    UserModel adminUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel nonExistingFile;
    private String content = "content webdav file";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can update the content of a file created by self.")
    public void adminShouldEditContentFile() throws Exception {
        FolderModel guestHomeFolder = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingResource((ContentModel)guestHomeFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).update(this.content + "-update").and()).assertThat().hasStatus(204).and()).assertThat().contentIs(this.content + "-update");
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteManager user can update the content of a file created by self.")
    public void siteManagerShouldEditContentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).update(this.content + "-update " + String.valueOf(UserRole.SiteManager)).and()).assertThat().hasStatus(204).and()).assertThat().contentIs(this.content + "-update " + String.valueOf(UserRole.SiteManager));
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteCollaborator user can update the content of a file created by other user.")
    public void siteCollaboratorShouldEditContentFileCreatedByOtherUser() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(collaborator).usingResource((ContentModel)this.testFile).update(this.content + "-update " + String.valueOf(UserRole.SiteCollaborator)).and()).assertThat().hasStatus(204).and()).assertThat().contentIs(this.content + "-update " + String.valueOf(UserRole.SiteCollaborator));
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteCollaborator user can update the content of a file created by self.")
    public void siteCollaboratorShouldEditContentFileCreatedBySelf() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(collaborator).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).update(this.content + "-update " + String.valueOf(UserRole.SiteCollaborator)).and()).assertThat().hasStatus(204).and()).assertThat().contentIs(this.content + "-update " + String.valueOf(UserRole.SiteCollaborator));
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteContributor user cannot update inline the content of a file created by other user.")
    public void siteContributorShouldNotEditContentFileCreatedByOtherUser() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(contributor).usingResource((ContentModel)this.testFile).update(this.content + "-update").and()).assertThat().hasStatus(403).and()).assertThat().contentIs(this.content);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteContributor user can update the content of a file created by self.")
    public void siteContributorShouldEditContentFileCreatedBySelf() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteManager);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(contributor).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).update(this.content + "-update " + String.valueOf(UserRole.SiteManager)).and()).assertThat().hasStatus(204).and()).assertThat().contentIs(this.content + "-update " + String.valueOf(UserRole.SiteManager));
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteConsumer user cannot update the content of a file created by other user.")
    public void siteConsumerShouldNotEditContentFileCreatedByOtherUser() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(consumer).usingResource((ContentModel)this.testFile).update(this.content + "-update " + String.valueOf(UserRole.SiteConsumer)).and()).assertThat().hasStatus(403).and()).assertThat().contentIs(this.content);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthenticated user cannot update the content of a file.")
    public void unauthenticatedUserShouldNotEditContentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).disconnect().usingResource((ContentModel)this.testFile).update(this.content + "-update unauthenticated").and()).assertThat().hasStatus(401);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot update the content of a file.")
    public void inexistentUserShouldNotEditContentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).update(this.content + "-update").and()).assertThat().hasStatus(401);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteManager user cannot update the content of a folder")
    public void siteManagerShouldNotEditFolderContent() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(folder).and()).assertThat().existsInRepo()).then()).update(this.content + "-update ").assertThat().hasStatus(400);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteManager user cannot update the content of an inexisting file.")
    public void editContentFileForNonExistingFile() throws Exception {
        this.nonExistingFile = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.nonExistingFile).delete().and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().when()).update(this.content + "-update").assertThat().hasStatus(404);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that SiteManager user cannot update the content of a locked file")
    public void siteManagerCannotEditContentOfLockedFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked().then()).update(this.content + "-update ").and()).assertThat().hasStatus(423).and()).assertThat().contentIs(this.content);
    }

    @Test(groups={"protocols", "webdav", "full"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify user can update file with a size smaller than the quota limit")
    public void userCanUpdateFileSmallerThanQuotaLimit() throws Exception {
        UserModel quotaUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(quotaUser, this.testSite, UserRole.SiteManager);
        ((DataUser)this.dataUser.usingAdmin()).setUserQuota(quotaUser, 5);
        FileModel quotaFile = FileModel.getFileModelWithContentSizeOfxMB((int)1);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(quotaUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).update(quotaFile.getContent()).and()).assertThat().contentIs(quotaFile.getContent());
    }

    @Test(groups={"protocols", "webdav", "full"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that file version is incremented after file is edited")
    public void verifyFileVersionIsIncrementedAfterEdit() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.managerUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.webDavProtocol.authenticateUser(this.managerUser).usingResource((ContentModel)this.testFile).update("new content");
        ((DataContent)this.dataContent.usingResource((ContentModel)this.testFile)).assertContentVersionIs("1.1");
    }
}

