/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LockFileTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FileModel testFile;
    private String content = "webdav file content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can lock a file created in Guest Home folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminCanLockFile() throws Exception {
        FolderModel guestHomeFolder = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guestHomeFolder).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager user can lock a file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerCanLockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator user can lock a file created by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorCanLockFileCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).lock().assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator user can lock a file created by himself")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorCanUnlockFileCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).lock().assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor user cannot lock a file created by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorCannotLockFileCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).and()).lock().assertThat().hasStatus(HttpStatus.FORBIDDEN.value()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor user cannot unlock a file created by himself")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorCanLockFileCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).and()).lock().assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site consumer user cannot unlock a file created by manager")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerCannotLockFileCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).and()).lock().assertThat().hasStatus(HttpStatus.FORBIDDEN.value()).assertThat().isUnlocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can create inexistent file as locked")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerCanCreateLockedInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).usingResource((ContentModel)this.testFile).lock().assertThat().hasStatus(HttpStatus.CREATED.value()).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator can create inexistent file as locked")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteCollaboratorCanCreateLockedInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).usingResource((ContentModel)this.testFile).lock().assertThat().hasStatus(HttpStatus.CREATED.value()).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor can create inexistent file as locked")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteContributorCanCreateLockedInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).usingResource((ContentModel)this.testFile).lock().assertThat().hasStatus(HttpStatus.CREATED.value()).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().isLocked();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer cannot can create inexistent file as locked")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteConsumerCannotCreateLockedInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.testSite).usingResource((ContentModel)this.testFile).lock().assertThat().hasStatus(HttpStatus.FORBIDDEN.value()).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot lock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserCannotLockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).and()).lock().and()).assertThat().hasStatus(HttpStatus.UNAUTHORIZED.value());
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that disconected user cannot lock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconectedUserCannotLockFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).disconnect().and()).lock().assertThat().hasStatus(HttpStatus.UNAUTHORIZED.value());
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot lock a file")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserCannotLockFile() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().existsInRepo()).then()).authenticateUser(unauthorized).and()).lock().assertThat().hasStatus(HttpStatus.FORBIDDEN.value());
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot lock a folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerCanLockFolder() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(testFolder).then()).assertThat().existsInRepo()).lock().and()).assertThat().hasStatus(HttpStatus.OK.value()).and()).assertThat().isLocked();
    }
}

