/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.commons.lang3.RandomStringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RenameFileTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FileModel testFile;
    private String renamePrefix = "-edit";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can rename file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldRenameFile() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel originalFileModel = new FileModel(this.testFile);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guest).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).rename(this.testFile.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can rename file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldRenameFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel originalFileModel = new FileModel(this.testFile);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).rename(this.testFile.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role cannot rename file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldNotRenameFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT);
        FileModel originalFileModel = new FileModel(this.testFile);
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).authenticateUser(contributor).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with collaborator role can rename file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteCollaboratorShouldRenameFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel originalFileModel = new FileModel(this.testFile);
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).authenticateUser(collaborator).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with consumer role cannot rename file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteConsumerShouldNotRenameFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        FileModel originalFileModel = new FileModel(this.testFile);
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).authenticateUser(consumer).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot rename inexistent file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldNotRenameInexistentFile() throws Exception {
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).usingResource((ContentModel)FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN)).rename("inexistent-edited.txt").assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can rename file with 200 characters")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldRenameFileWithLongName() throws Exception {
        String longName = RandomStringUtils.randomAlphabetic((int)200);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel originalFileModel = new FileModel(this.testFile);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).rename(longName).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot rename locked file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldNotRenameLockedFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel originalFileModel = new FileModel(this.testFile);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).lock().and()).assertThat().isLocked().when()).rename(this.testFile.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(423).then()).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "full"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that non existent user cannot rename a file")
    public void nonExistentUserShouldNotRenameFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel originalFileModel = new FileModel(this.testFile);
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo();
        this.webDavProtocol.authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.testFile).rename(this.testFile.getName() + this.renamePrefix).assertThat().hasStatus(401);
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).usingResource((ContentModel)originalFileModel).assertThat().existsInRepo();
    }
}

