/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    SiteModel privateSite;
    FolderModel testFolder;
    FileModel testFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete files in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldDeleteDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete empty folders in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldDeleteEmptyFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete folders with chidren with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp="^Could not delete folder with at least one child!$")
    public void siteManagerCannotDeleteFolderWithChildren() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete file with multiple versions with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanDeleteFileWithVersions() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).then()).update("content 1").assertThat().documentHasVersion(1.1).then()).update("content 2").assertThat().documentHasVersion(1.2).then()).usingResource((ContentModel)this.testFile).delete().assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete file which is checked out with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp="^Could not delete/cancel checkout on the original checked out document$")
    public void siteManagerCannotDeleteCheckedOutFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).checkOut().assertThat().documentIsCheckedOut().then()).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete PWC file version with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanDeletePWCFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().delete().assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete nonexistent file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotDeleteNonexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.testFile.setCmisLocation("/" + this.testFile.getName() + "/");
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).usingResource((ContentModel)this.testFile).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete nonexistent folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotDeleteNonexistentFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFolder.setCmisLocation("/" + this.testFolder.getName() + "/");
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete files created by another users in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldDeleteDocumentCreatedByAnotherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to delete content created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldDeleteContentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).delete().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.testFolder).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to delete file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorShouldNotDeleteFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to delete folder created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorShouldNotDeleteFolderCreatedByOtherUser() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to delete content created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldDeleteContentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).delete().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.testFolder).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to delete file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorShouldNotDeleteFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to delete folder created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorShouldNotDeleteFolderCreatedByOtherUser() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to delete file created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerShouldNotDeleteFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to delete folder created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerShouldNotDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to delete files created by another users in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminShouldDeleteDocumentCreatedByAnotherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.testFile).delete().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to delete file created inside a private site with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotDeleteFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to delete folder created inside a private site with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to delete content created inside a private site with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeleteCheckedOutFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.testFile).then()).checkOut().and()).assertThat().documentIsCheckedOut().when()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).delete();
    }
}

