/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.Date;
import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.commons.lang.time.DateUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SecondaryTypesTests
extends CmisTest {
    SiteModel testSite;
    UserModel testUser;
    UserModel nonInvitedUser;
    private DataUser.ListUserWithRoles usersWithRoles;
    FileModel managerFile;
    FolderModel managerFolder;
    String titledAspect = "P:cm:titled";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007, (String)this.documentContent);
        this.managerFolder = FolderModel.getRandomFolderModel();
        this.testUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.managerFile).createFolder(this.managerFolder);
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get secondary types for Document")
    public void userCanGetSecondaryTypesForDocument() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get secondary types for Folder")
    public void userCanGetSecondaryTypesForFolder() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to get secondary types for Folder")
    public void userCannotGetSecondaryTypesForInvalidObject() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder.setCmisLocation("/" + folder.getName() + "/");
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)folder).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to get invalid secondary type for Folder")
    public void invalidSecondaryTypeIsNotAvailableForFolder() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(folder).and()).assertThat().existsInRepo().and()).assertThat().secondaryTypeIsNotAvailable(this.titledAspect + "-fake");
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get secondary types")
    public void collaboratorCanGetSecondaryTypesForContent() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFolder).assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get secondary types")
    public void contributorCanGetSecondaryTypesForContent() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFolder).assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to get secondary types")
    public void consumerCanGetSecondaryTypesForContent() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.managerFolder).assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is able to get secondary types in public site")
    public void nonInvitedUserCanGetSecondaryTypesForContentInPublicSite() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.nonInvitedUser).usingResource((ContentModel)this.managerFolder).assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class, CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get secondary types in private site")
    public void nonInvitedUserCannotGetSecondaryTypesForContentInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT2007);
        this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(privateDoc).authenticateUser(this.nonInvitedUser).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class, CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get secondary types in moderated site")
    public void nonInvitedUserCannotGetSecondaryTypesInModeratedSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT2007);
        this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(privateDoc).authenticateUser(this.nonInvitedUser).assertThat().secondaryTypeIsAvailable(this.titledAspect);
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to add secondary types for Document")
    public void managerCanAddSecondaryTypesForDocument() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:cm:dublincore"}).assertThat().secondaryTypeIsAvailable("P:cm:dublincore").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("cm:subject", (Object)"TAS Subject").updateProperty("cm:rights", (Object)"TAS Rights").updateProperty("cm:publisher", (Object)"TAS Team").then()).assertThat().objectHasProperty("cm:subject", (Object)"TAS Subject").assertThat().objectHasProperty("cm:rights", (Object)"TAS Rights").assertThat().objectHasProperty("cm:publisher", (Object)"TAS Team");
    }

    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to add secondary types for folder")
    public void managerCanAddSecondaryTypesForFolder() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).addSecondaryTypes(new String[]{"P:cm:geographic"}).assertThat().secondaryTypeIsAvailable("P:cm:geographic").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("cm:longitude", (Object)455.21).updateProperty("cm:latitude", (Object)101.32).then()).assertThat().objectHasProperty("cm:longitude", (Object)455.21).assertThat().objectHasProperty("cm:latitude", (Object)101.32);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp="Type 'P:cm:fakeAspect' is unknown!*")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to add fake secondary type")
    public void managerCannotAddInexistentSecondaryType() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).addSecondaryTypes(new String[]{"P:cm:fakeAspect"});
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to add twice same secondary type")
    public void managerCanAddTwiceSameSecondaryType() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:cm:dublincore"}).assertThat().secondaryTypeIsAvailable("P:cm:dublincore").then()).addSecondaryTypes(new String[]{"P:cm:dublincore"}).assertThat().secondaryTypeIsAvailable("P:cm:dublincore");
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to add secondary types for document created by manager")
    public void collaboratorCanAddAspectForDocument() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:audio:audio"}).assertThat().secondaryTypeIsAvailable("P:audio:audio").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("audio:channelType", (Object)"TAS").updateProperty("audio:trackNumber", (Object)9).updateProperty("audio:sampleType", (Object)"TAS Sample").then()).assertThat().objectHasProperty("audio:channelType", (Object)"TAS").assertThat().objectHasProperty("audio:trackNumber", (Object)9).assertThat().objectHasProperty("audio:sampleType", (Object)"TAS Sample");
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to add secondary types for document created by manager")
    public void contributorCanAddAspectForDocument() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:dp:restrictable"}).assertThat().secondaryTypeIsAvailable("P:dp:restrictable").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("dp:offlineExpiresAfter", (Object)2).and()).assertThat().objectHasProperty("dp:offlineExpiresAfter", (Object)2);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to add secondary types for document created by manager")
    public void consumerCanAddAspectForDocument() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:dp:restrictable"}).assertThat().secondaryTypeIsAvailable("P:dp:restrictable").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("dp:offlineExpiresAfter", (Object)2).and()).assertThat().objectHasProperty("dp:offlineExpiresAfter", (Object)2);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to add twice same secondary type")
    public void managerCanAddDateProperty() throws Exception {
        Date today = new Date();
        Date tomorrow = new Date();
        tomorrow = DateUtils.addDays((Date)tomorrow, (int)1);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:cm:effectivity"}).assertThat().secondaryTypeIsAvailable("P:cm:effectivity").then()).updateProperty("cm:to", (Object)today).updateProperty("cm:from", (Object)tomorrow).and()).assertThat().objectHasProperty("cm:to", (Object)today).assertThat().objectHasProperty("cm:from", (Object)tomorrow);
    }

    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Property 'cm:fake-prop' is not valid for this type or one of the secondary types!*")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update aspect with fake property")
    public void managerCannotUpdateFakePropertyFromAspect() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).addSecondaryTypes(new String[]{"P:cm:dublincore"}).assertThat().secondaryTypeIsAvailable("P:cm:dublincore").assertThat().secondaryTypeIsAvailable(this.titledAspect).then()).updateProperty("cm:fake-prop", (Object)"fake-prop");
    }
}

