/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.alfresco.cmis.AuthParameterProviderFactory;
import org.alfresco.cmis.CmisProperties;
import org.alfresco.cmis.dsl.BaseObjectType;
import org.alfresco.cmis.dsl.CheckIn;
import org.alfresco.cmis.dsl.CmisAssertion;
import org.alfresco.cmis.dsl.CmisUtil;
import org.alfresco.cmis.dsl.DocumentVersioning;
import org.alfresco.cmis.dsl.JmxUtil;
import org.alfresco.cmis.dsl.QueryExecutor;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.dsl.DSLContentModelAction;
import org.alfresco.utility.dsl.DSLFile;
import org.alfresco.utility.dsl.DSLFolder;
import org.alfresco.utility.dsl.DSLProtocol;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.DataListItemModel;
import org.alfresco.utility.model.DataListModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class CmisWrapper
extends DSLProtocol<CmisWrapper>
implements DSLContentModelAction<CmisWrapper>,
DSLFile<CmisWrapper>,
DSLFolder<CmisWrapper> {
    protected Logger LOG = LogFactory.getLogger();
    public static String STEP_PREFIX = "CMIS:";
    private Session session;
    @Autowired
    private AuthParameterProviderFactory authParameterProviderFactory;
    @Autowired
    CmisProperties cmisProperties;
    public List<String> deleteTreeFailedObjects = new ArrayList<String>();

    public CmisWrapper authenticateUser(UserModel userModel) {
        return this.authenticateUser(userModel, this.authParameterProviderFactory.getDefaultProvider());
    }

    public CmisWrapper authenticateUser(UserModel userModel, Function<UserModel, Map<String, String>> authParameterProvider) {
        this.disconnect();
        Step.STEP((String)String.format("%s Connect with %s/%s", STEP_PREFIX, userModel.getUsername(), userModel.getPassword()));
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>(authParameterProvider.apply(userModel));
        String binding = this.cmisProperties.getCmisBinding().toLowerCase();
        String cmisURLPath = this.cmisProperties.envProperty().getFullServerUrl() + this.cmisProperties.getBasePath();
        if (binding.equals(BindingType.BROWSER.value())) {
            parameter.put("org.apache.chemistry.opencmis.binding.browser.url", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
            this.LOG.info("Using binding type [{}] to [{}] and credentials: {}", new Object[]{BindingType.BROWSER.value(), cmisURLPath, userModel.toString()});
        } else if (binding.equals(BindingType.ATOMPUB.value().replace("pub", ""))) {
            parameter.put("org.apache.chemistry.opencmis.binding.atompub.url", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            this.LOG.info("Using binding type [{}] to [{}] and credentials: {}", new Object[]{BindingType.ATOMPUB.value(), cmisURLPath, userModel.toString()});
        } else if (binding.equals(BindingType.WEBSERVICES.value())) {
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", cmisURLPath);
            parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            this.LOG.info("Using binding type [{}] to [{}] and credentials: {}", new Object[]{BindingType.WEBSERVICES.value(), cmisURLPath, userModel.toString()});
        }
        parameter.put("org.apache.chemistry.opencmis.binding.connecttimeout", "20000");
        parameter.put("org.apache.chemistry.opencmis.binding.readtimeout", "60000");
        List repositories = factory.getRepositories(parameter);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)repositories.get(0)).getId());
        this.session = ((Repository)repositories.get(0)).createSession();
        this.setTestUser(userModel);
        return this;
    }

    public CmisWrapper authUserUsingBrowserUrlAndBindingType(UserModel userModel, String urlPath, String bindingType) {
        Step.STEP((String)String.format("%s Setting binding type %s to %s", STEP_PREFIX, bindingType, urlPath));
        Step.STEP((String)String.format("%s Connect with %s/%s", STEP_PREFIX, userModel.getUsername(), userModel.getPassword()));
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>(this.authParameterProviderFactory.getDefaultProvider().apply(userModel));
        parameter.put("org.apache.chemistry.opencmis.binding.browser.url", urlPath);
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", bindingType);
        this.LOG.info("Using binding type [{}] to [{}] and credentials: {}", new Object[]{bindingType, urlPath, userModel.toString()});
        List repositories = factory.getRepositories(parameter);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", ((Repository)repositories.get(0)).getId());
        this.session = ((Repository)repositories.get(0)).createSession();
        this.setTestUser(userModel);
        return this;
    }

    public AuthParameterProviderFactory getAuthParameterProviderFactory() {
        return this.authParameterProviderFactory;
    }

    public CmisWrapper disconnect() {
        if (this.session != null) {
            this.getSession().clear();
        }
        return this;
    }

    public String buildPath(String parent, String ... paths) {
        return Utility.convertBackslashToSlash((String)super.buildPath(parent, paths)).replace("//", "/");
    }

    public synchronized Session getSession() {
        return this.session;
    }

    public CmisWrapper createFile(FileModel fileModel) {
        return this.createFile(fileModel, BaseTypeId.CMIS_DOCUMENT.value(), VersioningState.MAJOR);
    }

    public CmisWrapper createFile(FileModel fileModel, VersioningState versioningState) {
        return this.createFile(fileModel, BaseTypeId.CMIS_DOCUMENT.value(), versioningState);
    }

    public CmisWrapper createFile(FileModel fileModel, String cmisBaseTypeId, VersioningState versioningState) {
        return this.createFile(fileModel, this.withCMISUtil().getProperties((ContentModel)fileModel, cmisBaseTypeId), versioningState);
    }

    public CmisWrapper createFile(FileModel fileModel, Map<String, Object> properties, VersioningState versioningState) {
        ContentStream contentStream = this.dataContent.getContentStream(fileModel.getName(), fileModel.getContent());
        Step.STEP((String)String.format("%s Create file '%s' in '%s'", STEP_PREFIX, fileModel.getName(), this.getCurrentSpace()));
        Document doc = null;
        try {
            doc = this.withCMISUtil().getCmisFolder(this.getCurrentSpace()).createDocument(properties, contentStream, versioningState);
        }
        catch (CmisStorageException se) {
            doc = this.withCMISUtil().getCmisFolder(this.getCurrentSpace()).createDocument(properties, contentStream, versioningState);
        }
        fileModel.setNodeRef(doc.getId());
        String location = this.buildPath(this.getCurrentSpace(), fileModel.getName());
        this.setLastResource(location);
        fileModel.setProtocolLocation(location);
        fileModel.setCmisLocation(location);
        this.dataContent.closeContentStream(contentStream);
        return this;
    }

    public CmisWrapper createFileFromSource(FileModel newfileModel, ContentModel sourceFileModel) {
        return this.createFileFromSource(newfileModel, sourceFileModel, BaseTypeId.CMIS_DOCUMENT.value());
    }

    public CmisWrapper createFileFromSource(FileModel newfileModel, ContentModel sourceFileModel, String cmisBaseTypeId) {
        return this.createFileFromSource(newfileModel, sourceFileModel, cmisBaseTypeId, VersioningState.MAJOR);
    }

    public CmisWrapper createFileFromSource(FileModel newfileModel, ContentModel sourceFileModel, VersioningState versioningState) {
        return this.createFileFromSource(newfileModel, sourceFileModel, BaseTypeId.CMIS_DOCUMENT.value(), versioningState);
    }

    public CmisWrapper createFileFromSource(FileModel newfileModel, ContentModel sourceFileModel, String cmisBaseTypeId, VersioningState versioningState) {
        String resourcePath = this.getLastResource();
        Step.STEP((String)String.format("%s Create new file '%s' from source '%s' in '%s'", STEP_PREFIX, newfileModel.getName(), sourceFileModel.getName(), resourcePath));
        Document source = this.withCMISUtil().getCmisDocument(sourceFileModel.getCmisLocation());
        Map<String, Object> properties = this.withCMISUtil().getProperties((ContentModel)newfileModel, cmisBaseTypeId);
        Document doc = this.withCMISUtil().getCmisFolder(resourcePath).createDocumentFromSource((ObjectId)source, properties, versioningState);
        doc.refresh();
        newfileModel.setNodeRef(doc.getId());
        String location = this.buildPath(resourcePath, doc.getName());
        this.setLastResource(location);
        newfileModel.setProtocolLocation(location);
        newfileModel.setCmisLocation(location);
        return this;
    }

    public CmisWrapper createFolder(FolderModel folderModel) {
        return this.createFolder(folderModel, BaseTypeId.CMIS_FOLDER.value());
    }

    public CmisWrapper createFolder(FolderModel folderModel, String cmisBaseTypeId) {
        Map<String, Object> properties = this.withCMISUtil().getProperties((ContentModel)folderModel, cmisBaseTypeId);
        this.createFolder(folderModel, properties);
        return this;
    }

    public CmisWrapper createFolder(FolderModel folderModel, Map<String, Object> properties) {
        Step.STEP((String)String.format("%s Create folder '%s' in '%s'", STEP_PREFIX, folderModel.getName(), this.getCurrentSpace()));
        Folder folder = this.withCMISUtil().getCmisFolder(this.getCurrentSpace()).createFolder(properties);
        String location = this.buildPath(this.getCurrentSpace(), folderModel.getName());
        this.setLastResource(location);
        folderModel.setProtocolLocation(location);
        folderModel.setCmisLocation(location);
        folderModel.setNodeRef(folder.getId());
        return this;
    }

    public CmisWrapper deleteFolderTree() {
        return this.deleteFolderTree(true, UnfileObject.DELETE, true);
    }

    public CmisWrapper deleteFolderTree(boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
        String path = this.getLastResource();
        Folder parent = this.withCMISUtil().getCmisFolder(Utility.convertBackslashToSlash((String)new File(path).getParent()));
        Step.STEP((String)String.format("%s Delete parent folder from '%s'", STEP_PREFIX, path));
        Folder folder = this.withCMISUtil().getCmisFolder(path);
        folder.refresh();
        this.deleteTreeFailedObjects.clear();
        this.deleteTreeFailedObjects = folder.deleteTree(allVersions, unfile, continueOnFailure);
        for (String failedObj : this.deleteTreeFailedObjects) {
            this.LOG.error(String.format("Failed to delete object %s", failedObj));
        }
        if (!this.deleteTreeFailedObjects.isEmpty()) {
            this.LOG.info(String.format("Retry: delete parent folder from %s", path));
            Utility.waitToLoopTime((int)2, (String[])new String[0]);
            folder.refresh();
            folder.deleteTree(allVersions, unfile, continueOnFailure);
        } else {
            parent.refresh();
            this.dataContent.waitUntilContentIsDeleted(path);
        }
        return this;
    }

    public String getRootPath() throws TestConfigurationException {
        return "/";
    }

    public String getSitesPath() throws TestConfigurationException {
        return String.format("%s/%s", this.getPrefixSpace(), "Sites");
    }

    public String getUserHomesPath() throws TestConfigurationException {
        return String.format("%s/%s", this.getPrefixSpace(), "User Homes");
    }

    public String getDataDictionaryPath() throws TestConfigurationException {
        return String.format("%s/%s", this.getPrefixSpace(), "Data Dictionary");
    }

    public String getSharedPath() throws TestConfigurationException {
        return String.format("%s/%s", this.getPrefixSpace(), "Shared");
    }

    public CmisWrapper usingSite(String siteId) {
        Step.STEP((String)String.format("%s Navigate to site '%s/%s'", STEP_PREFIX, siteId, "documentLibrary"));
        Utility.checkObjectIsInitialized((Object)siteId, (String)"SiteID");
        this.setCurrentSpace(this.buildSiteDocumentLibraryPath(siteId, new String[]{""}));
        return this;
    }

    public CmisWrapper usingSite(SiteModel siteModel) {
        Step.STEP((String)String.format("%s Navigate to site '%s/%s'", STEP_PREFIX, siteModel.getId(), "documentLibrary"));
        Utility.checkObjectIsInitialized((Object)siteModel, (String)"SiteModel");
        String path = this.buildSiteDocumentLibraryPath(siteModel.getId(), new String[]{""});
        this.setCurrentSpace(path);
        return this;
    }

    public CmisWrapper usingUserHome(String username) {
        Step.STEP((String)String.format("%s Navigate to 'User Home' folder", STEP_PREFIX));
        Utility.checkObjectIsInitialized((Object)username, (String)"username");
        this.setCurrentSpace(this.buildUserHomePath(username, new String[]{""}));
        return this;
    }

    public CmisWrapper usingUserHome() {
        Step.STEP((String)String.format("%s Navigate to 'User Home' folder", STEP_PREFIX));
        Utility.checkObjectIsInitialized((Object)this.getTestUser().getUsername(), (String)"username");
        this.setCurrentSpace(this.buildUserHomePath(this.getTestUser().getUsername(), new String[]{""}));
        return this;
    }

    public CmisWrapper usingShared() {
        Step.STEP((String)String.format("%s Navigate to 'Shared' folder", STEP_PREFIX));
        this.setCurrentSpace(this.getSharedPath());
        return this;
    }

    public CmisWrapper usingResource(ContentModel model) {
        Step.STEP((String)String.format("%s Navigate to '%s'", STEP_PREFIX, model.getName()));
        Utility.checkObjectIsInitialized((Object)model, (String)"contentName");
        this.setCurrentSpace(model.getCmisLocation());
        return this;
    }

    protected String getProtocolJMXConfigurationStatus() {
        return "";
    }

    public String getPrefixSpace() {
        return "";
    }

    public CmisWrapper rename(String newName) {
        String resourcePath = this.getLastResource();
        CmisObject objToRename = this.withCMISUtil().getCmisObject(resourcePath);
        Step.STEP((String)String.format("%s Rename '%s' to '%s'", STEP_PREFIX, objToRename.getName(), newName));
        objToRename.rename(newName);
        this.setLastResource(this.buildPath(new File(resourcePath).getParent(), newName));
        return this;
    }

    public CmisWrapper update(String content) {
        return this.update(content, true);
    }

    public CmisWrapper update(String content, boolean isLastChunk) {
        Document doc = this.withCMISUtil().getCmisDocument(this.getLastResource());
        doc.refresh();
        Utility.waitToLoopTime((int)2, (String[])new String[0]);
        Step.STEP((String)String.format("%s Update content from '%s' by appending '%s'", STEP_PREFIX, doc.getName(), content));
        ContentStream contentStream = this.dataContent.getContentStream(doc.getName(), content);
        doc.appendContentStream(contentStream, isLastChunk);
        this.dataContent.closeContentStream(contentStream);
        return this;
    }

    public CmisWrapper updateProperty(String property, Object value) {
        String lastResource = this.getLastResource();
        CmisObject objSource = this.withCMISUtil().getCmisObject(lastResource);
        Step.STEP((String)String.format("%s Update '%s' property for '%s'", STEP_PREFIX, property, objSource.getName()));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        objSource.updateProperties(properties, true);
        if (property.equals("cmis:name")) {
            if (objSource instanceof Document) {
                this.setLastResource(this.buildPath(new File(this.getLastResource()).getParent(), objSource.getName()));
            } else if (objSource instanceof Folder) {
                this.setLastResource(this.buildPath(((Folder)objSource).getFolderParent().getPath(), value.toString()));
            }
        }
        return this;
    }

    public CmisWrapper delete() {
        String resourcePath = this.getLastResource();
        Step.STEP((String)String.format("%s Delete content from '%s'", STEP_PREFIX, resourcePath));
        this.withCMISUtil().getCmisObject(resourcePath).delete();
        return this;
    }

    public CmisWrapper deleteAllVersions(boolean allVersions) {
        String resourcePath = this.getLastResource();
        if (allVersions) {
            Step.STEP((String)String.format("%s Delete all content '%s' versions", STEP_PREFIX, resourcePath));
        } else {
            Step.STEP((String)String.format("%s Delete only the last content '%s' version", STEP_PREFIX, resourcePath));
        }
        this.withCMISUtil().getCmisObject(this.getLastResource()).delete(allVersions);
        return this;
    }

    public CmisWrapper deleteContent() {
        String resourcePath = this.getLastResource();
        Step.STEP((String)String.format("%s Delete document content from '%s'", STEP_PREFIX, resourcePath));
        this.withCMISUtil().getCmisDocument(this.getLastResource()).deleteContentStream();
        return this;
    }

    public CmisWrapper deleteContent(boolean refresh) {
        String resourcePath = this.getLastResource();
        Step.STEP((String)String.format("%s Delete document content from '%s'", STEP_PREFIX, resourcePath));
        this.withCMISUtil().getCmisDocument(this.getLastResource()).deleteContentStream(refresh);
        return this;
    }

    public CmisWrapper setContent(String content, boolean overwrite) {
        Utility.waitToLoopTime((int)1, (String[])new String[0]);
        Document doc = this.withCMISUtil().getCmisDocument(this.getLastResource());
        doc.refresh();
        Step.STEP((String)String.format("%s Set '%s' content to '%s' - node: %s", STEP_PREFIX, content, doc.getName(), doc.getId()));
        ContentStream contentStream = this.dataContent.getContentStream(doc.getName(), content);
        try {
            doc.setContentStream(contentStream, overwrite, true);
        }
        catch (CmisStorageException cs) {
            doc.setContentStream(contentStream, overwrite, true);
        }
        this.dataContent.closeContentStream(contentStream);
        return this;
    }

    public CmisWrapper setContent(String content) {
        return this.setContent(content, true);
    }

    public CmisWrapper createRelationshipWith(ContentModel targetContent) {
        return this.createRelationshipWith(targetContent, "R:cm:basis");
    }

    public CmisWrapper createRelationshipWith(ContentModel targetContent, String relationType) {
        Step.STEP((String)String.format("%s Set %s relationship between source from '%s' and target '%s'", STEP_PREFIX, relationType, this.getLastResource(), targetContent.getName()));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", relationType);
        properties.put("cmis:sourceId", this.withCMISUtil().getCmisObject(this.getLastResource()).getId());
        properties.put("cmis:targetId", targetContent.getNodeRef());
        this.getSession().createRelationship(properties);
        return this;
    }

    public CmisWrapper addDocumentToFolder(FolderModel destination, boolean allVersions) {
        CmisObject objSource = this.withCMISUtil().getCmisObject(this.getLastResource());
        Folder objDestination = this.withCMISUtil().getCmisFolder(destination.getCmisLocation());
        Step.STEP((String)String.format("%s Add object '%s' to '%s'", STEP_PREFIX, objSource.getName(), destination.getCmisLocation()));
        ((FileableCmisObject)objSource).addToFolder((ObjectId)objDestination, allVersions);
        this.setLastResource(this.buildPath(destination.getCmisLocation(), objSource.getName()));
        return this;
    }

    public CmisWrapper removeDocumentFromFolder(FolderModel parentFolder) {
        CmisObject objSource = this.withCMISUtil().getCmisObject(this.getLastResource());
        Folder parentObj = this.withCMISUtil().getCmisFolder(parentFolder.getCmisLocation());
        Step.STEP((String)String.format("%s Remove object '%s' from '%s'", STEP_PREFIX, objSource.getName(), parentFolder.getCmisLocation()));
        ((FileableCmisObject)objSource).removeFromFolder((ObjectId)parentObj);
        return this;
    }

    public List<FolderModel> getFolders() {
        Step.STEP((String)String.format("%s Get the folder children from '%s'", STEP_PREFIX, this.getLastResource()));
        return this.withCMISUtil().getFolders();
    }

    public List<FileModel> getFiles() {
        Step.STEP((String)String.format("%s Get the file children from '%s'", STEP_PREFIX, this.getLastResource()));
        return this.withCMISUtil().getFiles();
    }

    public CmisWrapper copyTo(ContentModel destination) {
        String source = this.getLastResource();
        String sourceName = new File(source).getName();
        Step.STEP((String)String.format("%s Copy '%s' to '%s'", STEP_PREFIX, sourceName, destination.getCmisLocation()));
        CmisObject objSource = this.withCMISUtil().getCmisObject(source);
        CmisObject objDestination = this.withCMISUtil().getCmisObject(destination.getCmisLocation());
        if (objSource instanceof Document) {
            Document d = (Document)objSource;
            d.copy((ObjectId)objDestination);
        } else if (objSource instanceof Folder) {
            Folder fFrom = (Folder)objSource;
            Folder toFolder = (Folder)objDestination;
            this.withCMISUtil().copyFolder(fFrom, toFolder);
        }
        this.setLastResource(this.buildPath(destination.getCmisLocation(), sourceName));
        return this;
    }

    public CmisWrapper moveTo(ContentModel destination) {
        String source = this.getLastResource();
        String sourceName = new File(source).getName();
        Step.STEP((String)String.format("%s Move '%s' to '%s'", STEP_PREFIX, sourceName, destination.getCmisLocation()));
        CmisObject objSource = this.withCMISUtil().getCmisObject(source);
        CmisObject objDestination = this.withCMISUtil().getCmisObject(destination.getCmisLocation());
        if (objSource instanceof Document) {
            Document d = (Document)objSource;
            List parents = d.getParents();
            CmisObject parent = this.getSession().getObject(((Folder)parents.get(0)).getId());
            d.move((ObjectId)parent, (ObjectId)objDestination);
        } else if (objSource instanceof Folder) {
            Folder f = (Folder)objSource;
            List parents = f.getParents();
            CmisObject parent = this.getSession().getObject(((Folder)parents.get(0)).getId());
            f.move((ObjectId)parent, (ObjectId)objDestination);
        }
        this.setLastResource(this.buildPath(destination.getCmisLocation(), sourceName));
        return this;
    }

    public RepositoryInfo getRepositoryInfo() {
        Step.STEP((String)String.format("Get repository information for user %s", this.getCurrentUser().getUsername()));
        return this.getSession().getRepositoryInfo();
    }

    public AclCapabilities getAclCapabilities() {
        return this.getRepositoryInfo().getAclCapabilities();
    }

    public CmisWrapper checkOut() {
        Document document = this.withCMISUtil().getCmisDocument(this.getLastResource());
        Step.STEP((String)String.format("%s Check out document '%s'", STEP_PREFIX, document.getName()));
        try {
            document.checkOut();
        }
        catch (CmisRuntimeException e) {
            document.checkOut();
        }
        return this;
    }

    public CmisWrapper cancelCheckOut() {
        Document document = this.withCMISUtil().getCmisDocument(this.getLastResource());
        Step.STEP((String)String.format("%s Cancel document '%s' check out", STEP_PREFIX, document.getName()));
        document.cancelCheckOut();
        return this;
    }

    public CheckIn prepareDocumentForCheckIn() {
        return new CheckIn(this);
    }

    public CmisWrapper refreshResource() {
        CmisObject cmisObject = this.withCMISUtil().getCmisObject(this.getLastResource());
        Step.STEP((String)String.format("%s Reload '%s'", STEP_PREFIX, cmisObject.getName()));
        cmisObject.refresh();
        return this;
    }

    public CmisUtil withCMISUtil() {
        return new CmisUtil(this);
    }

    public JmxUtil withJMX() {
        return new JmxUtil(this, this.jmxBuilder.getJmxClient());
    }

    public CmisAssertion assertThat() {
        return new CmisAssertion(this);
    }

    public DocumentVersioning usingVersion() {
        return new DocumentVersioning(this, this.withCMISUtil().getCmisObject(this.getLastResource()));
    }

    public CmisWrapper addAcl(UserModel user, UserRole role, AclPropagation aclPropagation) {
        Step.STEP((String)String.format("%s Add permission '%s' for user %s ", STEP_PREFIX, role.name(), user.getUsername()));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).addAcl(this.withCMISUtil().createAce(user, role), aclPropagation);
        return this;
    }

    public CmisWrapper addAcl(GroupModel group, UserRole role, AclPropagation aclPropagation) {
        Step.STEP((String)String.format("%s Add permission '%s' for user %s ", STEP_PREFIX, role.name(), group.getDisplayName()));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).addAcl(this.withCMISUtil().createAce(group, role), aclPropagation);
        return this;
    }

    public CmisWrapper addAcl(GroupModel group, UserRole role) {
        return this.addAcl(group, role, null);
    }

    public CmisWrapper addAcl(UserModel user, String ... permissions) {
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).addAcl(this.withCMISUtil().createAce(user, permissions), null);
        return this;
    }

    public CmisWrapper addAcl(UserModel user, UserRole role) {
        return this.addAcl(user, role, null);
    }

    public CmisWrapper applyAcl(UserModel user, UserRole newRole, UserRole removeRole, AclPropagation aclPropagation) {
        Step.STEP((String)String.format("%s Edit permission for user %s from %s to %s ", STEP_PREFIX, user.getUsername(), removeRole.name(), newRole.name()));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).applyAcl(this.withCMISUtil().createAce(user, newRole), this.withCMISUtil().createAce(user, removeRole), aclPropagation);
        return this;
    }

    public CmisWrapper applyAcl(UserModel user, UserRole newRole, UserRole removeRole) {
        return this.applyAcl(user, newRole, removeRole, null);
    }

    public CmisWrapper applyAcl(UserModel user, String newPermission, String removePermission) {
        Step.STEP((String)String.format("%s Edit permission for user %s from %s to %s ", STEP_PREFIX, user.getUsername(), removePermission, newPermission));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).applyAcl(this.withCMISUtil().createAce(user, newPermission), this.withCMISUtil().createAce(user, removePermission), null);
        return this;
    }

    public CmisWrapper removeAcl(UserModel user, UserRole removeRole, AclPropagation aclPropagation) {
        Step.STEP((String)String.format("%s Remove permission '%s' from user %s ", STEP_PREFIX, removeRole.name(), user.getUsername()));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).removeAcl(this.withCMISUtil().createAce(user, removeRole), aclPropagation);
        return this;
    }

    public CmisWrapper removeAcl(UserModel user, UserRole removeRole) {
        return this.removeAcl(user, removeRole, null);
    }

    public CmisWrapper removeAcl(UserModel user, String permissionToRemove) {
        Step.STEP((String)String.format("%s Remove permission '%s' from user %s ", STEP_PREFIX, permissionToRemove, user.getUsername()));
        this.withCMISUtil().getCmisObject(this.getLastResource(), this.withCMISUtil().setIncludeAclContext()).removeAcl(this.withCMISUtil().createAce(user, permissionToRemove), null);
        return this;
    }

    public QueryExecutor withQuery(String query) {
        return new QueryExecutor(this, query);
    }

    public CmisWrapper usingPWCDocument() {
        Step.STEP((String)String.format("%s Navigate to private working copy of content '%s'", STEP_PREFIX, this.withCMISUtil().getPWCFileModel().getName()));
        this.setCurrentSpace(this.withCMISUtil().getPWCFileModel().getCmisLocation());
        return this;
    }

    public BaseObjectType usingObjectType(String baseType) {
        return new BaseObjectType(this, baseType);
    }

    public CmisWrapper createDataList(DataListModel dataListModel) {
        Map<String, Object> properties = this.withCMISUtil().getProperties((ContentModel)dataListModel, "F:dl:dataList");
        properties.put("dl:dataListItemType", dataListModel.getDataListItemType());
        Folder folder = this.withCMISUtil().getCmisFolder(this.getCurrentSpace()).createFolder(properties);
        String location = this.buildPath(this.getCurrentSpace(), dataListModel.getName());
        this.setLastResource(location);
        dataListModel.setProtocolLocation(location);
        dataListModel.setCmisLocation(location);
        dataListModel.setNodeRef(folder.getId());
        return this;
    }

    public CmisWrapper createDataListItem(DataListItemModel itemModel) {
        Map propertyMap = itemModel.getItemProperties();
        String name = (String)propertyMap.get("cmis:name");
        Step.STEP((String)String.format("%s Create new data list item %s (type: %s)", STEP_PREFIX, name, propertyMap.get("cmis:objectTypeId")));
        ObjectId itemId = this.getSession().createDocument(propertyMap, (ObjectId)this.withCMISUtil().getCmisObject(this.getLastResource()), null, null);
        String path = this.buildPath(this.getCurrentSpace(), name);
        itemModel.setName(name);
        itemModel.setCmisLocation(path);
        itemModel.setProtocolLocation(path);
        itemModel.setNodeRef(itemId.getId());
        this.setLastResource(path);
        return this;
    }

    public CmisWrapper attachDocument(ContentModel ... contents) {
        String itemId = this.withCMISUtil().getCmisObject(this.getLastResource()).getId();
        for (ContentModel content : contents) {
            Step.STEP((String)String.format("Attach document %s to item %s", content.getName(), itemId));
            HashMap<String, String> relProps = new HashMap<String, String>();
            relProps.put("cmis:objectTypeId", "R:cm:attachments");
            relProps.put("cmis:sourceId", itemId);
            relProps.put("cmis:targetId", content.getNodeRef());
            this.getSession().createRelationship(relProps);
        }
        return this;
    }

    public CmisWrapper assignToUser(UserModel user, String relationType) {
        HashMap<String, String> relProps = new HashMap<String, String>();
        relProps.put("cmis:objectTypeId", relationType);
        relProps.put("cmis:sourceId", this.withCMISUtil().getCmisObject(this.getLastResource()).getId());
        relProps.put("cmis:targetId", this.withCMISUtil().getUserNodeRef(user));
        this.getSession().createRelationship(relProps);
        return this;
    }

    public CmisWrapper addSecondaryTypes(String ... secondaryTypes) {
        CmisObject object = this.withCMISUtil().getCmisObject(this.getLastResource());
        ArrayList<String> secondaryTypesNew = new ArrayList<String>();
        for (SecondaryType oldType : object.getSecondaryTypes()) {
            secondaryTypesNew.add(oldType.getId());
        }
        for (String newType : secondaryTypes) {
            secondaryTypesNew.add(newType);
        }
        HashMap<String, ArrayList<String>> properties = new HashMap<String, ArrayList<String>>();
        properties.put("cmis:secondaryObjectTypeIds", secondaryTypesNew);
        object.updateProperties(properties);
        return this;
    }
}

