/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.HashMap;
import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CheckInTests
extends CmisTest {
    UserModel unauthorizedUser;
    UserModel siteManager;
    SiteModel testSite;
    FileModel testFile;
    private String fileContent = "content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.siteManager = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify check in document with minor version and no content")
    @Test(groups={"sanity", "cmis"})
    public void checkInDocumentWithMinorVersionAndNoContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify check in document with minor version and with content")
    @Test(groups={"sanity", "cmis"})
    public void checkInDocumentWithMinorVersionAndWithContent() throws Exception {
        String newContent = "new minor content";
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().checkOut().and()).assertThat().documentIsCheckedOut().assertThat().isPrivateWorkingCopy().and()).prepareDocumentForCheckIn().withMinorVersion().withContent(newContent).checkIn().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1).and()).assertThat().contentIs(newContent);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify check in document with major version and no content")
    @Test(groups={"sanity", "cmis"})
    public void checkInDocumentWithMajorVersionAndNoContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMajorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(2.0);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify check in document with major version and with content")
    @Test(groups={"sanity", "cmis"})
    public void checkInDocumentWithMajorVersionAndWithContent() throws Exception {
        String newContent = "new major content";
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMajorVersion().withContent(newContent).checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(2.0);
        Utility.sleep((int)100, (int)5000, () -> this.cmisApi.assertThat().contentIs(newContent));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in document that wasn't checked out")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisVersioningException.class})
    public void checkInDocumentThatWasntCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).assertThat().documentIsNotCheckedOut().then()).prepareDocumentForCheckIn().checkIn();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in comment for document with major version")
    @Test(groups={"regression", "cmis"})
    public void getCheckInCommentForDocMajorVersion() throws Exception {
        String newContent = "new major content";
        String comment = "major version comment";
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMajorVersion().withContent(newContent).withComment(comment).checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(2.0).and()).assertThat().contentIs(newContent).assertThat().hasCheckInCommentLastVersion(comment);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in comments for multiple versions")
    @Test(groups={"regression", "cmis"})
    public void getCheckInCommentForDocWithMultipleVersions() throws Exception {
        String minorComment = "minor version comment";
        String majorComment = "major version comment";
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().then()).prepareDocumentForCheckIn().withMinorVersion().withContent("minor content").withComment(minorComment).checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().and()).assertThat().hasCheckInCommentForVersion(1.1, minorComment).then()).checkOut().prepareDocumentForCheckIn().withMajorVersion().withContent("major content").withComment(majorComment).checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().and()).assertThat().hasCheckInCommentForVersion(2.0, majorComment);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in document with minor version and no content")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisVersioningException.class})
    public void checkInDocumentTwice() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().prepareDocumentForCheckIn().checkIn();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in document created with VersioningState checkedout")
    @Test(groups={"regression", "cmis"})
    public void checkInDocumentCreatedWithVersioningStateCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().withMinorVersion().withContent("minor content").checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in for deleted document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void checkInDeletedDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).delete().assertThat().doesNotExistInRepo().then()).prepareDocumentForCheckIn().withMinorVersion().withContent("minor content").checkIn();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in document created with VersioningState checkedout")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void checkInDocumentWithProperties() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", this.testFile.getName() + "-edit");
        properties.put("cm:title", this.testFile.getName() + "-title");
        properties.put("cm:description", "description after checkout");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().withMinorVersion().withContent("minor content").checkIn(properties).refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1).and()).assertThat().contentPropertyHasValue("cmis:description", "description after checkout").assertThat().contentPropertyHasValue("cmis:name", this.testFile.getName() + "-edit").assertThat().contentPropertyHasValue("cm:title", this.testFile.getName() + "-title");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify check in document created with VersioningState checkedout")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class})
    public void checkInDocumentWithInvalidProperties() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:fakeProp", "fake-value");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().assertThat().documentIsCheckedOut().then()).prepareDocumentForCheckIn().withMinorVersion().withContent("minor content").checkIn(properties).refreshResource();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor user can check in document created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanCheckInDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator user can check in document created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCheckInDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator user can check in document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCheckInDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).prepareDocumentForCheckIn().withMinorVersion().checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.1);
    }
}

