/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTypeDefinitionTests
extends CmisTest {
    UserModel testUser;
    SiteModel publicSite;
    SiteModel privateSite;
    SiteModel moderatedSite;
    FileModel testFile;
    FolderModel testFolder;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.cmisApi.authenticateUser(this.testUser);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get Type Definition for a valid folder")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get Type Definition for a valid document")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetTypeDefinitionForValidDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager cannot get Type Definition for a deleted document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldGetTypeDefinitionForDeletedDocument() throws Exception {
        FileModel deletedFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFile(deletedFile).and()).usingResource((ContentModel)deletedFile).delete().then()).assertThat().typeDefinitionIs((ContentModel)deletedFile);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user that was deleted cannot get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void deletedUserCannotGetTypeDefinitionForValidFolder() throws Exception {
        UserModel deletedUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(deletedUser, this.publicSite, UserRole.SiteManager);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFolder(this.testFolder);
        ((CmisWrapper)this.cmisApi.authenticateUser(deletedUser).usingSite(this.publicSite).usingResource((ContentModel)this.testFolder).then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
        this.dataUser.deleteUser(deletedUser);
        this.cmisApi.disconnect().assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user that was deleted can NOT get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"})
    public void siteManagerGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.publicSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Contributor is able to get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Collaborator is able to get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Consumer is NOT able to get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void siteConsumerCantGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.publicSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Manager is able to get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"})
    public void siteManagerGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.publicSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Contributor is able to get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"})
    public void siteContributorGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Collaborator is able to get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site Consumer is NOT able to get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void siteConsumerCantGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.UNDEFINED);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.publicSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @Bug(id="REPO-4301")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user outside private site cannot get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void outsideUserPrivateSiteCantGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.privateSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @Bug(id="REPO-4301")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user outside moderated site cannot get Type Definition for a valid file")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void outsideUserModeratedSiteGetTypeDefinitionForValidFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.moderatedSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFile);
    }

    @Bug(id="REPO-4301")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user outside private site cannot get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void outsideUserPrivateSiteCantGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.privateSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).usingResource((ContentModel)this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }

    @Bug(id="REPO-4301")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user outside moderated site cannot get Type Definition for a valid folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void outsideUserModeratedSiteGetTypeDefinitionForValidFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(this.moderatedSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).usingResource((ContentModel)this.testFolder).and()).assertThat().existsInRepo().then()).assertThat().typeDefinitionIs((ContentModel)this.testFolder);
    }
}

