/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RelationshipTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    SiteModel privateSite;
    FileModel sourceFile;
    FileModel targetFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to create relationship between a source object and a target object in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCreatesRelationshipBetween2Files() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create relationship between a invalid sources with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotCreateRelWithInvalidSources() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).delete().assertThat().doesNotExistInRepo().createFile(this.sourceFile).and()).delete().assertThat().doesNotExistInRepo().then()).createRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create relationship with checkout source document with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanCreateRelWithCheckedOutSourceDocument() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().then()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user is not able to create relationship between documents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserCannotCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(UserModel.getRandomUserModel()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that user that was deleted is not able to create relationship between documents with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void deletedUserCannotCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        UserModel toBeDeleted = this.dataUser.createRandomTestUser();
        FolderModel shared = FolderModel.getSharedFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(toBeDeleted).usingResource((ContentModel)shared).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo();
        this.dataUser.deleteUser(toBeDeleted);
        this.cmisApi.createRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager is able to create relationship between documents with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanCreateRelationshipInPrivateSite() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.privateSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.siteManager).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create relationship between a invalid sources with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetRelWithInvalidObject() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel invalidFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        invalidFile.setCmisLocation("/" + invalidFile.getName() + "/");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).createFile(this.sourceFile).then()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile).assertThat().objectHasRelationshipWith((ContentModel)invalidFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to create relationship between a source folder and a target file with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminCreatesRelBetweenSourceFolderAndTargetFile() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel sourceFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.publicSite).createFile(this.targetFile).assertThat().existsInRepo().createFolder(sourceFolder).assertThat().existsInRepo().then()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor is not able to create relationship between a source object and a target object in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.sourceFile).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator is able to create relationship between a source object and a target object in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.sourceFile).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer is not able to create relationship between a source object and a target object in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.sourceFile).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user is not able to create relationship between a source object and a target object from a private site with CMIS")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCreateRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.sourceFile).createRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user is not able to get relationship between a source object and a target object from a private site with CMIS")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotGetRelationship() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFile).createRelationshipWith((ContentModel)this.targetFile).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create relationship for PWC source document with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="^Source is not the latest version of a document, a folder or an item object!$")
    public void siteManagerCannotCreateRelationshipPWCSourceFile() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().createRelationshipWith((ContentModel)this.targetFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create relationship with checkout target document with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanCreateRelWithCheckedOutTargetDocument() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.targetFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.targetFile).and()).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).createRelationshipWith((ContentModel)this.targetFile).and()).assertThat().objectHasRelationshipWith((ContentModel)this.targetFile);
    }
}

