/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RemoveObjectFromFolderTests
extends CmisTest {
    UserModel unauthorizedUser;
    UserModel siteManager;
    UserModel contributorUser;
    UserModel collaboratorUser;
    UserModel consumerUser;
    SiteModel publicSite;
    FolderModel parentFolder;
    FolderModel testFolder;
    FileModel testFile;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.siteManager = this.dataUser.createRandomTestUser();
        this.contributorUser = this.dataUser.createRandomTestUser();
        this.collaboratorUser = this.dataUser.createRandomTestUser();
        this.consumerUser = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.consumerUser, this.publicSite, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.collaboratorUser, this.publicSite, UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.contributorUser, this.publicSite, UserRole.SiteContributor);
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.testFolder).assertThat().existsInRepo().createFolder(this.parentFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to remove a document from folder in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldRemoveFileToFolder() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.parentFolder).createFile(this.testFile).assertThat().existsInRepo().and()).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo().when()).removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to leave a document without parent folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="^Object is not a document!$")
    public void siteManagerShouldNotRemoveFolderFromFolder() throws Exception {
        FolderModel subFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.parentFolder).createFolder(subFolder).assertThat().existsInRepo().when()).removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to remove a document without parent folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldNotRemoveInvalidFileFromFolder() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFile.setCmisLocation("/" + this.testFile.getName() + "/");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).when()).removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to remove valid document from invalid folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldNotRemoveFileToInvalidFolder() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel invalidFolder = FolderModel.getRandomFolderModel();
        invalidFolder.setCmisLocation("/" + invalidFolder.getName() + "/");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.parentFolder).createFile(this.testFile).assertThat().existsInRepo().and()).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo().when()).removeDocumentFromFolder(invalidFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to remove a checked out document from folder in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldRemovePWCFileToFolder() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.parentFolder).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().usingPWCDocument().addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut().when()).removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user is not able to remove a document from folder")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotRemoveFileToFolder() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.parentFolder).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(unauthorizedUser).removeDocumentFromFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can remove document from folder created by self")
    @Test(groups={"regression", "cmis"})
    public void contributorCanRemoveDocumentFromFolderCreatedBySelf() throws Exception {
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo().removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can remove document from folder created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotRemoveDocumentFromFolderCreatedByManager() throws Exception {
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true);
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.testFile).removeDocumentFromFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can remove document from folder created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanRemoveDocumentFromFolderCreatedBySelf() throws Exception {
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo().removeDocumentFromFolder(this.testFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can remove document from folder created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotRemoveDocumentFromFolderCreatedByManager() throws Exception {
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true);
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.testFile).removeDocumentFromFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot remove document from folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotRemoveDocumentFromFolder() throws Exception {
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.consumerUser).usingResource((ContentModel)this.testFile).removeDocumentFromFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify remove document from folder by user that is outside a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotRemoveDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFile).removeDocumentFromFolder(this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify remove document from folder by user that is outside a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotRemoveDocumentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createFolder();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createFolder();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingResource((ContentModel)this.parentFolder)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).addDocumentToFolder(this.testFolder, true).then()).assertThat().existsInRepo();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFile).removeDocumentFromFolder(this.testFolder);
    }
}

