/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetCheckedOutDocumentsTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FolderModel testFolder;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFile(this.testFile).assertThat().existsInRepo().and()).checkOut().assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get checked out documents from a valid folder")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetCheckedOutDocumentsFromAValidFolder() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to get checked out documents from session")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetCheckedOutDocumentsFromSession() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).assertThat().sessionHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager CANNOT get checked out documents from inexistent folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetCheckedOutDocumentsFromInexistentFolder() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        testFolder.setCmisLocation(Utility.buildPath((String)"/", (String[])new String[]{testFolder.getCmisLocation()}));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).and()).usingResource((ContentModel)testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is not able to get checked out documents from session created by admin in root")
    @Test(groups={"regression", "cmis"})
    public void userShouldNotGetCheckedOutDocumentFromSessionCreatedByAdminInRoot() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingRoot()).createFile(this.testFile).assertThat().existsInRepo().and()).checkOut().then()).authenticateUser(this.testUser).and()).assertThat().sessioDoesNotHaveCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @Bug(id="MNT-17357")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get checked out documents created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldGetCheckedOutDocumentsFromFolderCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get checked out documents created by himslef")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldGetCheckedOutDocumentsCreatedByHimself() throws Exception {
        FileModel collaboratorFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).createFile(collaboratorFile).checkOut().usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{collaboratorFile}).assertThat().sessionHasCheckedOutDocument(new ContentModel[]{collaboratorFile});
    }

    @Bug(id="MNT-17357")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to get checked out documents created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldGetCheckedOutDocumentsFromFolderCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get checked out documents created by himslef")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldGetCheckedOutDocumentsCreatedByHimself() throws Exception {
        FileModel contributorFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).createFile(contributorFile).checkOut().usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{contributorFile}).assertThat().sessionHasCheckedOutDocument(new ContentModel[]{contributorFile});
    }

    @Bug(id="MNT-17357")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to get checked out documents created by manager")
    @Test(groups={"regression", "cmis"})
    public void consumerShouldGetCheckedOutDocumentsFromFolderCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{this.testFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get checked out documents")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserShouldNotGetCheckedOutDocuments() throws Exception {
        FileModel doc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel folder = FolderModel.getRandomFolderModel();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(folder).usingResource((ContentModel)folder).createFile(doc).checkOut().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)folder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{doc});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager user is able to get checked out documents from folder with operation context")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanGetCheckedOutDocumentsFromFolderWithOperationContext() throws Exception {
        OperationContext context = this.cmisApi.authenticateUser(this.testUser).getSession().createOperationContext();
        context.setOrderBy("cmis:name DESC");
        FileModel doc1 = new FileModel("a-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        FileModel doc2 = new FileModel("b-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        FileModel doc3 = new FileModel("c-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        FolderModel folder = FolderModel.getRandomFolderModel();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(folder).usingResource((ContentModel)folder).createFile(doc1).checkOut().createFile(doc2).checkOut().createFile(doc3).usingResource((ContentModel)folder).assertThat().folderHasCheckedOutDocument(context, new ContentModel[]{doc2, doc1});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to get checked out documents from session with operation context")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanGetCheckedOutDocumentsFromSessionWithOperationContext() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        OperationContext context = this.cmisApi.authenticateUser(user).getSession().createOperationContext();
        context.setOrderBy("cmis:name DESC");
        FileModel doc1 = new FileModel("a-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        FileModel doc2 = new FileModel("b-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        FileModel doc3 = new FileModel("c-file.txt", FileType.TEXT_PLAIN, this.documentContent);
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(user)).createPublicRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(user).usingSite(publicSite).createFile(doc1).checkOut().createFile(doc2).checkOut().createFile(doc3).then()).assertThat().sessionHasCheckedOutDocument(context, new ContentModel[]{doc2, doc1});
    }
}

