/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBasicPermissions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AclTests
extends CmisTest {
    UserModel testUser;
    UserModel inviteUser;
    UserModel unauthorizedUser;
    SiteModel testSite;
    SiteModel privateSite;
    FileModel testFile;
    FolderModel testFolder;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.inviteUser = this.dataUser.createRandomTestUser();
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Site manager can get the acls for valid document")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldGetDocumentAcls() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).assertThat().hasAcls();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Site manager can get the acls for valid folder")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerShouldGetFolderAcls() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).assertThat().hasAcls();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl for valid document with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclWithRepositoryDeterminedPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.usingResource((ContentModel)this.testFile).addAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.REPOSITORYDETERMINED).then()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl for valid folder with AclPropagation set to PROPAGATE")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclWithPropagate() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.usingResource((ContentModel)this.testFolder).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.PROPAGATE).then()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl for valid folder with AclPropagation set to OBJECTONLY")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclWithObjectOnlyPropagation() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.usingResource((ContentModel)this.testFolder).addAcl(this.inviteUser, UserRole.SiteCollaborator, AclPropagation.OBJECTONLY).then()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl for valid folder with AclPropagation set to OBJECTONLY")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanApplyAclWithObjectOnlyPropagation() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.usingResource((ContentModel)this.testFolder).addAcl(this.inviteUser, UserRole.SiteCollaborator, AclPropagation.OBJECTONLY).then()).applyAcl(this.inviteUser, UserRole.SiteConsumer, UserRole.SiteCollaborator, AclPropagation.OBJECTONLY).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteConsumer).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify apply acl with invalid role that will be removed")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void applyAclWithInvalidAddedRole() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, UserRole.SiteCollaborator, AclPropagation.OBJECTONLY).then()).applyAcl(this.inviteUser, UserRole.SiteConsumer, UserRole.SiteManager, AclPropagation.OBJECTONLY);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Apply Acl for valid folder with AclPropagation set to PROPAGATE")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCanApplyAclWithPropagate() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.PROPAGATE).when()).applyAcl(this.inviteUser, UserRole.SiteManager, UserRole.SiteConsumer, AclPropagation.PROPAGATE).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteManager).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl for valid folder with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanApplyAclWithRepositoryDeterminedPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY).when()).applyAcl(this.inviteUser, UserRole.SiteManager, UserRole.SiteConsumer, AclPropagation.REPOSITORYDETERMINED).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteManager).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl for valid folder with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRemoveAclWithRepositoryDeterminedPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY).when()).removeAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.REPOSITORYDETERMINED).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Remove Acl for valid folder with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCanRemoveAclWithPropagate() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteManager, AclPropagation.OBJECTONLY).when()).removeAcl(this.inviteUser, UserRole.SiteManager, AclPropagation.PROPAGATE).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteManager);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl for valid folder with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRemoveAclWithObjectOnlyPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.OBJECTONLY).when()).removeAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.OBJECTONLY).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl for valid folder with AclPropagation set to REPOSITORYDETERMINED")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotRemoveInvalidAcl() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.OBJECTONLY).when()).removeAcl(this.inviteUser, UserRole.SiteManager, AclPropagation.OBJECTONLY);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site manager can add acl with null AclPropagation")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclWithNullPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)"content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteContributor, null).then()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site manager cannot get acl for pwc document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisRuntimeException.class})
    public void siteManagerCannotGetAclForPwcDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)"content");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).usingPWCDocument().addAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.PROPAGATE).then()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site manager cannot get acl for invalid object")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetAclForInvalidObject() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder.setCmisLocation("/" + folder.getName() + "/");
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)folder).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl for valid document with null AclPropagation")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanApplyAclWithNullPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY).when()).applyAcl(this.inviteUser, UserRole.SiteManager, UserRole.SiteConsumer, null).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteManager).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl for checked out document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisRuntimeException.class})
    public void siteManagerCannotGetAclForAppliedAclForPWC() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY).then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().applyAcl(this.inviteUser, UserRole.SiteManager, UserRole.SiteConsumer).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteManager);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl from valid folder with null AclPropagation")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRemoveAclWithNullPropagation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteContributor, AclPropagation.OBJECTONLY).when()).removeAcl(this.inviteUser, UserRole.SiteContributor).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Unauthorized user cannot remove acl")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void removeAclByUnauthorizedUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteConsumer).when()).authenticateUser(this.unauthorizedUser).removeAcl(this.inviteUser, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Unauthorized user cannot add acl")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void addAclByUnauthorizedUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).authenticateUser(this.unauthorizedUser).and()).addAcl(this.inviteUser, UserRole.SiteConsumer, AclPropagation.OBJECTONLY);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Unauthorized user cannot apply acl")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void applyAclByUnauthorizedUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).addAcl(this.inviteUser, UserRole.SiteConsumer).when()).authenticateUser(this.unauthorizedUser).and()).applyAcl(this.inviteUser, UserRole.SiteManager, UserRole.SiteConsumer);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl for checked out document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclForCheckedOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.testFile).addAcl(this.inviteUser, UserRole.SiteContributor).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by user with collaborator role for document created by himself")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanAddAclForDocumentCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by user with collaborator role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotAddAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).addAcl(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Get Acl by user with collaborator role for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanGetAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).refreshResource().and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with collaborator role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotApplyAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).applyAcl(this.inviteUser, UserRole.SiteCollaborator, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with collaborator role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotRemoveAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).removeAcl(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by user with contributor role for document created by himself")
    @Test(groups={"regression", "cmis"})
    public void contributorCanAddAclForDocumentCreatedByHimself() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by user with contributor role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotAddAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).addAcl(this.inviteUser, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Get Acl by user with collaborator role for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanGetAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).refreshResource().and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with contributor role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotApplyAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).applyAcl(this.inviteUser, UserRole.SiteCollaborator, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with contributor role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotRemoveAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).removeAcl(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by user with consumer role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotAddAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).addAcl(this.inviteUser, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Get Acl by user with consumer role for document created by manager")
    @Test(groups={"regression", "cmis"})
    public void consumerCanGetAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).refreshResource().and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with consumer role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotApplyAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).applyAcl(this.inviteUser, UserRole.SiteCollaborator, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by user with consumer role for document created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotRemoveAclForDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).removeAcl(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl by non invited user in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotAddAclInPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).addAcl(this.inviteUser, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Get Acl by non invited user in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetAclInPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).refreshResource().and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl by non invited user in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotApplyAclInPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).applyAcl(this.inviteUser, UserRole.SiteCollaborator, UserRole.SiteContributor).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteCollaborator).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).applyAcl(this.inviteUser, UserRole.SiteContributor, UserRole.SiteCollaborator);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl by non invited user in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotRemoveAclFromPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.privateSite).createFile(this.testFile).and()).assertThat().existsInRepo().addAcl(this.inviteUser, UserRole.SiteContributor).and()).assertThat().permissionIsSetForUser(this.inviteUser, UserRole.SiteContributor).then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).removeAcl(this.inviteUser, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Add Acl for valid document with PermissionMapping")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanAddAclWithPermissionMapping() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, new String[]{"canUpdateProperties.Object"}).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_WRITE.value()).then()).addAcl(this.inviteUser, new String[]{"canDelete.Object"}).and()).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply Acl for valid document with PermissionMapping")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanApplyAclWithPermissionMapping() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, new String[]{"canDelete.Object"}).and()).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value()).then()).applyAcl(this.inviteUser, "canUpdateProperties.Object", "canDelete.Object").and()).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_WRITE.value()).and()).assertThat().permissionIsNotSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove Acl for valid document with PermissionMapping")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanRemoveAclWithPermissionMapping() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, new String[]{"canUpdateProperties.Object"}).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_WRITE.value()).then()).addAcl(this.inviteUser, new String[]{"canDelete.Object"}).and()).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value()).then()).removeAcl(this.inviteUser, "canDelete.Object").and()).assertThat().permissionIsNotSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Remove invalid Acl(that was not set) for valid document with PermissionMapping")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp="No matching ACE found to remove!*")
    public void siteManagerCannotRemoveInvalidAclWithPermissionMapping() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, new String[]{"canUpdateProperties.Object"}).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_WRITE.value()).then()).removeAcl(this.inviteUser, "canCheckin.Document");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Apply invalid Acl(that was not set) for valid document with PermissionMapping")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp="No matching ACE found to remove!*")
    public void siteManagerCannotApplyInvalidAclWithPermissionMapping() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).addAcl(this.inviteUser, new String[]{"canDelete.Object"}).and()).assertThat().permissionIsSetForUser(this.inviteUser, EnumBasicPermissions.CMIS_ALL.value()).then()).applyAcl(this.inviteUser, "canUpdateProperties.Object", "canCreateFolder.Folder");
    }
}

