/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AllowableActionTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel managerFile;
    FolderModel testFolder;
    FolderModel managerFolder;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.managerFolder = FolderModel.getRandomFolderModel();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.managerFile).assertThat().existsInRepo().createFolder(this.managerFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify valid document has allowable action CAN_CHECK_OUT")
    @Test(groups={"sanity", "cmis"})
    public void verifyValidDocumentHasAllowableActionCanCheckOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_CHECK_OUT}).then()).assertThat().isAllowableActionInList(new Action[]{Action.CAN_APPLY_ACL, Action.CAN_DELETE_CONTENT_STREAM, Action.CAN_GET_ALL_VERSIONS});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify valid folder has allowable action CAN_GET_CHILDREN, CAN_CREATE_FOLDER")
    @Test(groups={"sanity", "cmis"})
    public void verifyValidFolderHasAllowableAction() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_CHILDREN, Action.CAN_CREATE_FOLDER});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify pwc document has allowable action CAN_CHECK_IN, CAN_CANCEL_CHECK_OUT and CAN_MOVE_OBJECT")
    @Test(groups={"regression", "cmis"})
    public void verifyPWCDocumentHasAllowable() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut().usingPWCDocument().assertThat().hasAllowableActions(new Action[]{Action.CAN_CHECK_IN, Action.CAN_MOVE_OBJECT, Action.CAN_CANCEL_CHECK_OUT}).and()).assertThat().isAllowableActionInList(new Action[]{Action.CAN_CHECK_IN, Action.CAN_GET_CONTENT_STREAM, Action.CAN_CANCEL_CHECK_OUT});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify valid folder does not have allowable action CAN_CHECK_IN, CAN_CHECK_OUT, CAN_CANCEL_CHECK_OUT")
    @Test(groups={"regression", "cmis"})
    public void verifyFolderDoesNotHaveCanCheckInAction() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_CHECK_IN, Action.CAN_CHECK_OUT, Action.CAN_CANCEL_CHECK_OUT});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify delete document has allowable actions")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyDeletedDocumentHasAllowableActions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).delete().and()).assertThat().hasAllowableActions(new Action[]{Action.CAN_CHECK_IN, Action.CAN_MOVE_OBJECT, Action.CAN_CANCEL_CHECK_OUT});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify delete document has allowable actions")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyDeletedDocumentGetAllowableActions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).delete().and()).assertThat().isAllowableActionInList(new Action[]{Action.CAN_CHECK_IN, Action.CAN_MOVE_OBJECT, Action.CAN_CANCEL_CHECK_OUT});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify checked out document does not have allowable action CAN_CHECK_IN, CAN_CANCEL_CHECK_OUT")
    @Test(groups={"regression", "cmis"})
    public void verifyCheckedOutDocumentHasAllowable() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut().usingResource((ContentModel)this.testFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_ALL_VERSIONS, Action.CAN_GET_CONTENT_STREAM, Action.CAN_GET_ACL, Action.CAN_GET_PROPERTIES}).and()).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_CHECK_IN, Action.CAN_CANCEL_CHECK_OUT});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can get allowable and not allowable actions for content created by mananger")
    @Test(groups={"regression", "cmis"})
    public void contributorGetAllowableActionForContentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_CONTENT_STREAM}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_CHECK_OUT, Action.CAN_CHECK_IN, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_CONTENT_STREAM}).usingResource((ContentModel)this.managerFolder).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_CREATE_FOLDER}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_DELETE_TREE, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_CREATE_FOLDER});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can get allowable and not allowable actions for content created by mananger")
    @Test(groups={"regression", "cmis"})
    public void collaboratorGetAllowableActionForContentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_UPDATE_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_CHECK_OUT, Action.CAN_ADD_OBJECT_TO_FOLDER}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_CONTENT_STREAM, Action.CAN_UPDATE_PROPERTIES, Action.CAN_CHECK_OUT, Action.CAN_ADD_OBJECT_TO_FOLDER}).usingResource((ContentModel)this.managerFolder).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_CREATE_FOLDER, Action.CAN_UPDATE_PROPERTIES}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_DELETE_TREE, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_CREATE_FOLDER, Action.CAN_UPDATE_PROPERTIES});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer can get allowable and not allowable actions for content created by mananger")
    @Test(groups={"regression", "cmis"})
    public void consumerGetAllowableActionForContentCreatedByManager() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.managerFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_ALL_VERSIONS, Action.CAN_ADD_OBJECT_TO_FOLDER}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_MOVE_OBJECT, Action.CAN_CHECK_OUT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_ALL_VERSIONS, Action.CAN_ADD_OBJECT_TO_FOLDER}).usingResource((ContentModel)this.managerFolder).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_GET_DESCENDANTS}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_DELETE_TREE, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_GET_DESCENDANTS});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer can get allowable and not allowable actions for content created by mananger")
    @Test(groups={"regression", "cmis"})
    public void nonInvitedUserCanGetAllowableActionForContentCreatedByManager() throws Exception {
        UserModel nonInvitedUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(nonInvitedUser).usingResource((ContentModel)this.managerFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_ALL_VERSIONS, Action.CAN_ADD_OBJECT_TO_FOLDER}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_MOVE_OBJECT, Action.CAN_CHECK_OUT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_PROPERTIES, Action.CAN_GET_ACL, Action.CAN_GET_ALL_VERSIONS, Action.CAN_ADD_OBJECT_TO_FOLDER}).usingResource((ContentModel)this.managerFolder).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_GET_DESCENDANTS}).assertThat().doesNotHaveAllowableActions(new Action[]{Action.CAN_DELETE_OBJECT, Action.CAN_DELETE_TREE, Action.CAN_MOVE_OBJECT}).assertThat().isAllowableActionInList(new Action[]{Action.CAN_GET_FOLDER_PARENT, Action.CAN_GET_FOLDER_TREE, Action.CAN_GET_DESCENDANTS});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get allowable actions from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserOnPrivateSiteCannotGetAllowableActions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_PROPERTIES});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to get allowable actions from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserOnModeratedSiteCannotGetAllowableActions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().hasAllowableActions(new Action[]{Action.CAN_GET_PROPERTIES});
    }
}

