/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddObjectToFolderTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FolderModel destinationFolder;
    FileModel sourceFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.destinationFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.destinationFolder).assertThat().existsInRepo();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to add document object to folder with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldAddFileToFolder() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo().and()).assertThat().objectIdIs(this.sourceFile.getNodeRef());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to add folder object to folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="Object is not a document!*")
    public void siteManagerShouldNotAddFolderToFolder() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel folderToAdd = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(folderToAdd).assertThat().existsInRepo().then()).addDocumentToFolder(folderToAdd, true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to add file a document object in more than one folder in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldNotAddInvalidFileToFolder() throws Exception {
        FileModel randomFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        randomFile.setCmisLocation("/" + randomFile.getName() + "/");
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)randomFile).addDocumentToFolder(this.destinationFolder, true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to add folder object to folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerShouldNotAddInvalidFolderToFolder() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FolderModel randomFolder = FolderModel.getRandomFolderModel();
        randomFolder.setCmisLocation("/" + randomFolder.getName() + "/");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).addDocumentToFolder(randomFolder, true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to add PWC document to folder with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldAddPWCFileToFolder() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().usingPWCDocument().addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to add document object to folder")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanAddDocumentWithVersionsToFolderWithTrueAllVersions() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).update("first content").update("second content").and()).assertThat().documentHasVersion(1.2).then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo().and()).assertThat().documentHasVersion(1.2);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to add document object to folder")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="Only allVersions=true supported!*")
    public void siteManagerCannotAddDocumentToFolderWithFalseAllVersions() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).update("update content").and()).assertThat().documentHasVersion(1.1).then()).addDocumentToFolder(this.destinationFolder, false);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to add document object to folder")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanAddFileToFolderCreatedByHimself() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo().and()).assertThat().objectIdIs(this.sourceFile.getNodeRef());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to add document object created by manager to folder")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanAddFileToFolderCreatedByManager() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to add document object to folder")
    @Test(groups={"regression", "cmis"})
    public void contributorCanAddFileToFolderCreatedByHimself() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo().and()).assertThat().objectIdIs(this.sourceFile.getNodeRef());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to add document object created by manager to folder")
    @Test(groups={"regression", "cmis"})
    public void contributorCanAddFileToFolderCreatedByManager() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).then()).addDocumentToFolder(this.destinationFolder, true).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to add document object created by manager to folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCanAddFileToFolderCreatedByManager() throws Exception {
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).then()).addDocumentToFolder(this.destinationFolder, true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to delete parent folder with multiple children in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotDeleteFolderTreeInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.destinationFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(this.destinationFolder).assertThat().existsInRepo().createFile(this.sourceFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).then()).addDocumentToFolder(this.destinationFolder, true);
    }
}

