/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteContentStreamTests
extends CmisTest {
    UserModel siteManager;
    SiteModel publicSite;
    SiteModel privateSite;
    FileModel testFile;
    String content = "file content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete content of a not empty document in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerDeletesDocumentContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to delete content of a nonexistent document in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void userCantDeleteContentFromNonexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        this.testFile.setCmisLocation("/fake-folder/test.txt");
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.testFile).deleteContent();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete content of a empty document in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanDeleteContentOfEmptyDocument() throws Exception {
        FileModel emptyDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(emptyDoc).and()).assertThat().existsInRepo().and()).assertThat().contentIs("").then()).deleteContent().and()).assertThat().contentIs("");
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify nonexistent user is not able to delete content of a document with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void nonexistentUserCannotDeleteDocumentContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).then()).authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.testFile).deleteContent();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete content of a not empty document with refresh set to TRUE with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanDeleteDocContentWithRefreshTrue() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).deleteContent(true).and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete content of a not empty document with refresh set to FALSE with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanDeleteDocContentWithRefreshFalse() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).deleteContent(true).and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to delete content of a not empty document created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminDeletesContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.dataUser.getAdminUser()).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete content of a not empty document created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to delete content of a not empty document created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorDeletesContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to delete content of a not empty document created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void collaboratorDeletesContentOfFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to delete content of a not empty document created by other user in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotDeleteContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).deleteContent();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to delete content of a not empty document created by self in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void contributorDeletesContentOfFileCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).deleteContent().and()).assertThat().contentIs("");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to delete content of a not empty document in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotDeleteContentOfFileCreatedByOtherUser() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).deleteContent();
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUpdateConflictException.class}, expectedExceptionsMessageRegExp="^.*Cannot perform operation since the node.*is locked.$")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to delete content of a checked out file with CMIS")
    public void managerCannotDeleteContentOfCheckedOutFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().when()).deleteContent();
    }

    @Test(groups={"regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete content of a PWC file with CMIS")
    public void managerDeletesContentOfPWCFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().deleteContent().assertThat().contentIs("");
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is not able to delete content of a file created in a private site with CMIS")
    public void unauthorizedUserCannotDeleteContentOfFileFromPrivateSite() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.privateSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)this.testFile).deleteContent();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to delete content of invalid file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class}, expectedExceptionsMessageRegExp="^Content at.*is not a file$")
    public void userShouldNotDeleteContentOfInvalidFile() throws Exception {
        FolderModel testFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(testFolder).assertThat().existsInRepo().deleteContent();
    }
}

