/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import org.alfresco.cmis.CmisWrapper;
import org.alfresco.dataprep.SiteService;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.network.ServerHealth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeClass;

@ContextConfiguration(value={"classpath:alfresco-cmis-context.xml"})
public abstract class AbstractE2EFunctionalTest
extends AbstractTestNGSpringContextTests {
    protected static final int SEARCH_MAX_ATTEMPTS = 20;
    @Autowired
    protected ServerHealth serverHealth;
    @Autowired
    protected DataSite dataSite;
    @Autowired
    protected DataContent dataContent;
    @Autowired
    protected CmisWrapper cmisApi;
    @Autowired
    protected DataUser dataUser;
    protected UserModel testUser;
    protected UserModel adminUserModel;
    protected SiteModel testSite;
    protected static String unique_searchString;

    @BeforeClass(alwaysRun=true)
    public void setup() {
        this.serverHealth.assertServerIsOnline();
        this.adminUserModel = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser("UserSearch");
        this.testSite = new SiteModel(RandomData.getRandomName((String)"SiteSearch"));
        this.testSite.setVisibility(SiteService.Visibility.PRIVATE);
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createSite(this.testSite);
        unique_searchString = this.testSite.getTitle().replace("SiteSearch", "Unique");
    }
}

