/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetChildrenTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel secondFile;
    FolderModel testFolder;
    FolderModel subFolder;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.secondFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.subFolder = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Get children from valid folder")
    @Test(groups={"sanity", "cmis"})
    public void getChildrenFromValidFolder() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder).then()).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Fails to get children from folder that was previously deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void getChildrenFromDeletedFolder() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder).then()).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).and()).usingResource((ContentModel)this.testFolder).refreshResource().and()).deleteFolderTree().then()).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get children for a folder")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetChildrenFromValidFolderCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder).then()).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get children for a folder")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetChildrenFromValidFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get children for a folder")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetChildrenFromValidFolderCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder).then()).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get children for a folder")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetChildrenFromValidFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get children for a folder")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerCanGetChildrenFromValidFolder() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder}).assertThat().hasFiles(new FileModel[]{this.testFile, this.secondFile}).assertThat().hasFolders(new FolderModel[]{this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member cannot get children for a folder from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetChildrenFromValidFolderFromAPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member cannot get children for a folder from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetChildrenFromValidFolderFromAModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFolder(this.testFolder).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFile(this.testFile).createFile(this.secondFile).createFolder(this.subFolder);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasChildren(new ContentModel[]{this.testFile, this.secondFile, this.subFolder});
    }
}

