/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CopyTests
extends CmisTest {
    UserModel inexistentUser;
    UserModel unauthorizedUser;
    UserModel testUser;
    UserModel contributorUser;
    UserModel collaboratorUser;
    UserModel consumerUser;
    SiteModel testSite;
    FileModel sourceFile;
    FolderModel targetFolder;
    FolderModel sourceFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.contributorUser = this.dataUser.createRandomTestUser();
        this.collaboratorUser = this.dataUser.createRandomTestUser();
        this.consumerUser = this.dataUser.createRandomTestUser();
        this.inexistentUser = new UserModel("inexistent", "inexistent");
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.consumerUser, this.testSite, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.contributorUser, this.testSite, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to copy file to an existent location in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_atom"})
    public void siteManagerCopyFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).copyTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to copy folder to an existent location in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerCopyFolder() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).assertThat().existsInRepo().createFolder(this.sourceFolder).assertThat().existsInRepo().then()).copyTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to copy file to a nonexistent location in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCopyFileToNonexistentTarget() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.sourceFile).assertThat().existsInRepo().createFolder(this.targetFolder).and()).delete().then()).copyTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to copy a nonexistent file in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCopyNonexistentSourceFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).assertThat().existsInRepo().createFile(this.sourceFile).delete().then()).copyTo((ContentModel)this.targetFolder);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non existing user is not able to copy file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void nonExistentUserIsNotAbleToCopyFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.inexistentUser).then()).copyTo((ContentModel)this.targetFolder);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non existing user is not able to copy folder with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void nonExistentUserIsNotAbleToCopyFolder() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).assertThat().existsInRepo().createFolder(this.sourceFolder).assertThat().existsInRepo();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.inexistentUser).then()).copyTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that checked out document can be copied with CMIS")
    @Test(groups={"bug-atom-REPO-5387", "regression", "cmis"})
    public void checkedOutDocumentCanBeCopied() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).checkOut().and()).copyTo((ContentModel)this.targetFolder).refreshResource().then()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.sourceFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that whole folder structure can be copied with CMIS")
    @Test(groups={"regression", "cmis"})
    public void folderStructureCanBeCopied() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        FolderModel randomFolder = FolderModel.getRandomFolderModel();
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFolder(this.sourceFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFolder).createFolder(randomFolder).then()).createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().assertThat().hasFiles(new FileModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that version history of a copied document is not kept with CMIS")
    @Test(groups={"regression", "cmis"})
    public void versionHistoryIsNotKeptWhenCopyingFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).checkOut().refreshResource().prepareDocumentForCheckIn().withContent("First update").checkIn().refreshResource().and()).assertThat().documentHasVersion(1.1).then()).checkOut().prepareDocumentForCheckIn().withContent("Second update").withMajorVersion().checkIn().refreshResource().and()).assertThat().documentHasVersion(2.0).then()).copyTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().then()).assertThat().documentHasVersion(1.0).and()).assertThat().contentIs("Second update");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify copy PWC document object")
    @Test(groups={"bug-atom-REPO-5387", "regression", "cmis"})
    public void managerCopyPWCDocumentObject() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel pwcFile = this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.sourceFile).checkOut().withCMISUtil().getPWCFileModel();
        this.cmisApi.usingResource((ContentModel)pwcFile).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{pwcFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can copy Document")
    @Test(groups={"regression", "cmis"})
    public void contributorCanCopyDocument() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFile).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can copy Folder")
    @Test(groups={"regression", "cmis"})
    public void contributorCanCopyFolder() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can copy Document")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCopyDocument() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFile).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can copy Folder")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCopyFolder() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot copy Document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotCopyDocument() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.consumerUser).usingResource((ContentModel)this.sourceFile).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot copy Folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotCopyFolder() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.cmisApi.authenticateUser(this.consumerUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot copy Document from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCopyDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(privateSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(privateSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFile).copyTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot copy Folder from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCopyFolderFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(privateSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(privateSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot copy Document from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCopyDocumentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(moderatedSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(moderatedSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFile).copyTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot copy Folder from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotCopyFolderFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(moderatedSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(moderatedSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.targetFolder);
    }
}

