/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteAllVersionsTests
extends CmisTest {
    UserModel testUser;
    UserModel consumerUser;
    UserModel collaboratorUser;
    UserModel contributorUser;
    UserModel unauthorizedUser;
    SiteModel testSite;
    FileModel testFile;
    FolderModel testFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.consumerUser = this.dataUser.createRandomTestUser();
        this.collaboratorUser = this.dataUser.createRandomTestUser();
        this.contributorUser = this.dataUser.createRandomTestUser();
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.consumerUser, this.testSite, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.contributorUser, this.testSite, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete all document versions in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerDeletesAllDocumentVersions() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).update(this.testFile.getName()).then()).deleteAllVersions(true).and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete only latest document version in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerDeletesLatestDocumentVersion() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).update(this.testFile.getName()).then()).deleteAllVersions(false).and()).assertThat().documentHasVersion(1.0);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete all versions of inexistent file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotDeleteAllVersionsOfInexistentFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.testFile.setCmisLocation("/fake-folder/inexistentFile.txt");
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete PWC file version of a file with multiple versions with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanDeletePWCFileWithDeleteAllVersionsTrue() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).update("content 1").assertThat().documentHasVersion(1.1).usingResource((ContentModel)this.testFile).update("content 2").assertThat().documentHasVersion(1.2).usingResource((ContentModel)this.testFile).checkOut().assertThat().documentIsCheckedOut().usingPWCDocument().deleteAllVersions(true).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo().and()).assertThat().documentHasVersion(1.2);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete PWC file version of a file with multiple versions set to false with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanDeletePWCFileWithDeleteAllVersionsFalse() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).update("content 1").assertThat().documentHasVersion(1.1).then()).update("content 2").assertThat().documentHasVersion(1.2).then()).checkOut().refreshResource().assertThat().documentIsCheckedOut().usingPWCDocument().deleteAllVersions(false).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo().and()).assertThat().documentHasVersion(1.2);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete file original multiple version which is checked out with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp="^Could not delete/cancel checkout on the original checked out document$")
    public void siteManagerCannotDeleteOriginalFileMultipleVersionWhenCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).update("content 1").assertThat().documentHasVersion(1.1).then()).update("content 2").assertThat().documentHasVersion(1.2).refreshResource().then()).checkOut().assertThat().documentIsCheckedOut();
        this.cmisApi.usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user is NOT able to delete a checked out document")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeletePWCDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).update("content 1").and()).checkOut().assertThat().documentIsCheckedOut().when()).authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFile).usingPWCDocument().deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can delete object Document")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanDeleteDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).update("content 1").usingResource((ContentModel)this.testFile).deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can delete object Folder")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanDeleteFolder() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can delete object Document created by self")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void contributorCanDeleteDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.contributorUser).usingSite(this.testSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).update("content 1").deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor cannot delete object Document created by site manager")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotDeleteDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).update("content 1").when()).authenticateUser(this.contributorUser).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can delete object Folder created by self")
    @Test(groups={"regression", "cmis"})
    public void contributorCanDeleteFolderCreatedBySelf() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        this.cmisApi.authenticateUser(this.contributorUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor cannot delete object Folder created by site manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotDeleteFolderCreatedByManager() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().when()).authenticateUser(this.contributorUser).usingResource((ContentModel)this.testFolder).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can delete object Document created by self")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void collaboratorCanDeleteDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.collaboratorUser).usingSite(this.testSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).update("content 1").deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator cannot delete object Document created by manager")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotDeleteDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).update("content 1").when()).authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can delete object Folder created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanDeleteFolderCreatedBySelf() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        this.cmisApi.authenticateUser(this.collaboratorUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).deleteAllVersions(true).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator cannot delete object Folder created by manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotDeleteFolderCreatedByManager() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.testFolder).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot delete object Document")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotDeleteDocumentCreated() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).update("content 1").when()).authenticateUser(this.consumerUser).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot delete object Folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotDeleteFolderCreated() throws Exception {
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).authenticateUser(this.consumerUser).usingResource((ContentModel)this.testFolder).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot delete Document from private site")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeleteDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(this.testFile).then()).update("content 1").when()).authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot delete Folder from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeleteFolderFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFolder).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot delete Document from moderated site")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeleteDocumentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFile(this.testFile).usingResource((ContentModel)this.testFile).update("content 1");
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFile).deleteAllVersions(true);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot delete Folder from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotDeleteFolderFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFolder = new FolderModel(RandomData.getRandomName((String)"Folder"));
        this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.testFolder).deleteAllVersions(true);
    }
}

