/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetObjectTypeTests
extends CmisTest {
    UserModel siteManager;
    SiteModel testSite;
    FolderModel testFolder;
    FileModel testFile;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
        this.testFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify CMIS folder type")
    @Test(groups={"sanity", "cmis"})
    public void verifyCmisFolderType() throws Exception {
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify CMIS document type")
    @Test(groups={"sanity", "cmis"})
    public void verifyCmisDocumentType() throws Exception {
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).usingResource((ContentModel)this.testFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify CMIS folder type of folder that was deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyCmisFolderTypeOfDeletedFolder() throws Exception {
        FolderModel folderModel = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFolder(folderModel).usingResource((ContentModel)folderModel).delete().assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify CMIS document type of file that was deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyCmisDocumentTypeOfDeletedDocument() throws Exception {
        FileModel fileModel = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(fileModel).usingResource((ContentModel)fileModel).delete().assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site contributor verifies CMIS document type")
    @Test(groups={"regression", "cmis"})
    public void siteContributorVerifiesCmisDocumentType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site contributor verifies CMIS folder type")
    @Test(groups={"regression", "cmis"})
    public void siteContributorVerifiesCmisFolderType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site collaborator verifies CMIS document type")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorVerifiesCmisDocumentType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site collaborator verifies CMIS folder type")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorVerifiesCmisFolderType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site consumer verifies CMIS document type")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerVerifiesCmisDocumentType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site consumer verifies CMIS folder type")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerVerifiesCmisFolderType() throws Exception {
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non site member is not able to verify CMIS document type for a document from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotVerifyCmisObjectTypeForADocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FileModel privateSiteFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFile(privateSiteFile);
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)privateSiteFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non site member is not able to verify CMIS document type for a folder from a private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotVerifyCmisFolderTypeForAFolderFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateSiteFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(privateSiteFolder);
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)privateSiteFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non site member is not able to verify CMIS document type for a document from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotVerifyCmisObjectTypeForADocumentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        FileModel moderatedSiteFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFile(moderatedSiteFile);
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)moderatedSiteFile).assertThat().baseTypeIdIs(BaseTypeId.CMIS_DOCUMENT.value());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non site member is not able to verify CMIS document type for a folder from a moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotVerifyCmisObjectTypeForAFolderFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        FolderModel moderatedSiteFolder = FolderModel.getRandomFolderModel();
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(moderatedSiteFolder);
        this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)moderatedSiteFolder).assertThat().baseTypeIdIs(BaseTypeId.CMIS_FOLDER.value());
    }
}

