/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteTreeTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FolderModel parentTestFolder;
    FolderModel childTestFolder;
    private String content = "content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete parent folder with multiple children in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerDeletesFolderTree() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify exception is thrown when deleting inexistent folder tree in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerDeletesInexistentFolderTree() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree().assertThat().doesNotExistInRepo().deleteFolderTree();
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is NOT able to delete parent folder with multiple children in DocumentLibrary")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserCannotDeleteFolderTree() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        UserModel inexistentUser = UserModel.getRandomUserModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().then()).authenticateUser(inexistentUser).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete parent folder with allVersions parameter set to true")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesFolderTreeWithAllVersionsParamTrue() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree(true, UnfileObject.DELETE, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Only allVersions=true is supported for delete parent folder tree, allVersions=true is not supported")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void deleteFolderTreeWithAllVersionsParamFalseNotSupported() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree(false, UnfileObject.DELETE, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete parent folder with unfile parameter set to DELETESINGLEFILED, using checked out document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesFolderTreeWithDeleteSingleFieldWithCheckoutDoc() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree(true, UnfileObject.DELETESINGLEFILED, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is NOT able to delete parent folder with unfile parameter set to DELETESINGLEFILED, using add object to folder")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesFolderTreeWithDeleteSingleFieldWithAddDocToFolder1() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).createFolder(this.childTestFolder).usingResource((ContentModel)this.parentTestFolder).createFile(this.testFile).and()).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).addDocumentToFolder(this.childTestFolder, true).then()).usingResource((ContentModel)this.childTestFolder).deleteFolderTree(true, UnfileObject.DELETESINGLEFILED, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.parentTestFolder).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete parent folder with unfile parameter set to DELETESINGLEFILED, using add object to folder")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesFolderTreeWithDeleteSingleFieldWithAddDocToFolder2() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).createFolder(this.childTestFolder).usingResource((ContentModel)this.parentTestFolder).createFile(this.testFile).and()).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).addDocumentToFolder(this.childTestFolder, true).then()).usingResource((ContentModel)this.childTestFolder).deleteFolderTree(true, UnfileObject.DELETE, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.parentTestFolder).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Unfile-ing is not supported for delete parent folder tree")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class}, expectedExceptionsMessageRegExp="Unfiling not supported!*")
    public void deleteFolderTreeWithUnfileNotSupported() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree(true, UnfileObject.UNFILE, true).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to delete parent folder with continueOnFailure parameter set to false")
    @Test(groups={"regression", "cmis"})
    public void siteManagerDeletesFolderTreeWithContinueOnFailureParamFalse() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree(true, UnfileObject.DELETE, false).and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to delete parent folder with multiple children created by himself")
    @Test(groups={"regression", "cmis"})
    public void contributorDeletesOwnFolderTree() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to delete parent folder with multiple children created by manager")
    @Test(groups={"bug-atom-REPO-5390", "regression", "cmis"})
    public void contributorCannotDeleteFolderTreeCreatedByManager() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().hasFailedDeletedObject(this.parentTestFolder.getNodeRef()).and()).assertThat().existsInRepo().usingResource((ContentModel)this.childTestFolder).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to delete parent folder with multiple children created by manager")
    @Test(groups={"bug-atom-REPO-5390", "regression", "cmis"})
    public void collaboratorCannotDeleteFolderTreeCreatedByManager() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().hasFailedDeletedObject(this.parentTestFolder.getNodeRef()).and()).assertThat().existsInRepo().usingResource((ContentModel)this.childTestFolder).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to delete parent folder with multiple children created by himself")
    @Test(groups={"regression", "cmis"})
    public void collaboratorDeletesOwnFolderTree() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to delete parent folder with multiple children created by manager")
    @Test(groups={"bug-atom-REPO-5390", "regression", "cmis"})
    public void consumerCannotDeleteFolderTreeCreatedByManager() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().hasFailedDeletedObject(this.parentTestFolder.getNodeRef()).and()).assertThat().existsInRepo().usingResource((ContentModel)this.childTestFolder).assertThat().existsInRepo().usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to delete parent folder with multiple children in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotDeleteFolderTreeInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).when()).usingResource((ContentModel)this.parentTestFolder).deleteFolderTree();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that only the parent folder is displayed in trash can after deleting it")
    @Test(groups={"regression", "cmis"})
    public void checkTrashCanAfterDeletingParentFolder() throws Exception {
        this.parentTestFolder = FolderModel.getRandomFolderModel();
        this.childTestFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentTestFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.parentTestFolder).createFolder(this.childTestFolder).and()).assertThat().existsInRepo().createFile(this.testFile).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)this.parentTestFolder).refreshResource().deleteFolderTree().and()).assertThat().doesNotExistInRepo().then()).usingResource((ContentModel)this.childTestFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
        this.dataUser.assertTrashCanHasContent(new ContentModel[]{this.parentTestFolder});
        this.dataUser.assertTrashCanDoesNotHaveContent(new ContentModel[]{this.childTestFolder, this.testFile});
    }
}

