/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetFolderParentTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FolderModel testFolder;
    FolderModel parentFolder;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify folder parent")
    @Test(groups={"sanity", "cmis"})
    public void verifyFolderParent() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFolder(FolderModel.getRandomFolderModel()).then()).assertThat().folderHasParent((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify folder parent that was previously deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void verifyFolderParentThatWasDeleted() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder).then()).assertThat().folderHasParent((ContentModel)this.parentFolder).and()).usingResource((ContentModel)this.parentFolder).deleteFolderTree().then()).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get folder parent")
    @Test(groups={"regression", "cmis"})
    public void siteContributorVerifyFolderParentCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFolder(FolderModel.getRandomFolderModel()).then()).assertThat().folderHasParent((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get folder parent")
    @Test(groups={"regression", "cmis"})
    public void siteContributorVerifyFolderParentCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get folder parent")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorVerifyFolderParentCreatedBySelf() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).createFolder(FolderModel.getRandomFolderModel()).then()).assertThat().folderHasParent((ContentModel)this.testFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get folder parent")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorVerifyFolderParentCreatedByManager() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get folder parent")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerVerifyFolderParent() throws Exception {
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a private site is not able to get folder parent")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetFolderParentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member for a moderated site is not able to get folder parent")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberGetFolderParentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.parentFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.parentFolder).createFolder(this.testFolder);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().folderHasParent((ContentModel)this.parentFolder);
    }
}

