/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MoveTests
extends CmisTest {
    UserModel unauthorizedUser;
    UserModel siteManager;
    UserModel contributorUser;
    UserModel collaboratorUser;
    UserModel consumerUser;
    SiteModel publicSite;
    FileModel sourceFile;
    FolderModel targetFolder;
    FolderModel sourceFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
        this.siteManager = this.dataUser.createRandomTestUser();
        this.contributorUser = this.dataUser.createRandomTestUser();
        this.collaboratorUser = this.dataUser.createRandomTestUser();
        this.consumerUser = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.consumerUser, this.publicSite, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.collaboratorUser, this.publicSite, UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.contributorUser, this.publicSite, UserRole.SiteContributor);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to move a file to an existent location in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerMovesFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to move file to a nonexistent location in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerMovesFileToNonExistentTarget() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFile(this.sourceFile).and()).assertThat().existsInRepo().createFolder(this.targetFolder).and()).delete().then()).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to move a nonexistent file in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerMovesNonExistentSourceFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).delete().then()).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to move file that has multiple versions with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerShouldMoveFileWithMultipleVersions() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).update("first content").assertThat().documentHasVersion(1.1).update("second content").assertThat().documentHasVersion(1.2).then()).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().and()).usingVersion().assertHasVersions(new Object[]{1.0, 1.1, 1.2}).usingResource((ContentModel)this.sourceFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to move folder structure to an existent location in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerMovesFolderStructure() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        FolderModel sourceParentFolder = FolderModel.getRandomFolderModel();
        FolderModel subFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFolder(sourceParentFolder).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)sourceParentFolder).createFile(this.sourceFile).and()).assertThat().existsInRepo().createFolder(subFolder).and()).assertThat().existsInRepo().when()).usingResource((ContentModel)sourceParentFolder).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().and()).assertThat().hasChildren(new ContentModel[]{this.sourceFile, subFolder});
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent is not able to move file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserCannotMoveFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(UserModel.getRandomUserModel()).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().usingResource((ContentModel)this.sourceFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to move checked out file with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUpdateConflictException.class})
    public void siteManagerShouldNotMoveCheckedOutFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().and()).checkOut().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to move folder with checked out document")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldMoveFolderWithCheckedOutFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFolder(this.sourceFolder).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.sourceFolder).createFile(this.sourceFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().assertThat().documentIsCheckedOut().then()).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder).and()).assertThat().existsInRepo().and()).assertThat().hasFiles(new FileModel[]{this.sourceFile});
        FileModel checkedOutDoc = (FileModel)this.cmisApi.getFiles().get(0);
        this.cmisApi.usingResource((ContentModel)checkedOutDoc).assertThat().documentIsCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user is no able to move a file")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotMovesFile() throws Exception {
        this.targetFolder = FolderModel.getRandomFolderModel();
        this.sourceFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"content");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.publicSite).createFolder(this.targetFolder).and()).assertThat().existsInRepo().createFile(this.sourceFile).and()).assertThat().existsInRepo().then()).authenticateUser(this.unauthorizedUser).then()).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Manager verify PWC document object cannot be moved")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUpdateConflictException.class})
    public void managerCannotMovePWCDocumentObject() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        FileModel pwcFile = this.cmisApi.authenticateUser(this.siteManager).usingResource((ContentModel)this.sourceFile).checkOut().withCMISUtil().getPWCFileModel();
        this.cmisApi.usingResource((ContentModel)pwcFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can move Document created by self")
    @Test(groups={"regression", "cmis"})
    public void contributorCanMoveDocumentCreatedBySelf() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFile}).usingSite(this.publicSite).assertThat().doesNotHaveFile(new FileModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor cannot move Document created by Manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotMoveDocumentCreatedByManager() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can move Folder created by self")
    @Test(groups={"regression", "cmis"})
    public void contributorCanMoveFolderCreatedBySelf() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.contributorUser).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFolder}).usingSite(this.publicSite).assertThat().doesNotHaveFolder(new FolderModel[]{this.sourceFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor cannot move Folder created by Manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void contributorCannotMoveFolderCreatedByManager() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.contributorUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can move Document created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanMoveDocumentCreatedBySelf() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFile}).usingSite(this.publicSite).assertThat().doesNotHaveFile(new FileModel[]{this.sourceFile});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator cannot move Document created by Manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotMoveDocumentCreatedByManager() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can move Folder created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanMoveFolderCreatedBySelf() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.collaboratorUser).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder).usingResource((ContentModel)this.targetFolder).assertThat().hasChildren(new ContentModel[]{this.sourceFolder}).usingSite(this.publicSite).assertThat().doesNotHaveFolder(new FolderModel[]{this.sourceFolder});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator cannot move Folder created by Manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void collaboratorCannotMoveFolderCreatedByManager() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.collaboratorUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot move Document")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotMoveDocument() throws Exception {
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.consumerUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot move Folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotMoveFolder() throws Exception {
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(this.publicSite)).createFolder();
        this.cmisApi.authenticateUser(this.consumerUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot move Document from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotMoveDocumentFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot move Folder from private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotMoveFolderFromPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPrivateRandomSite();
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(privateSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot move Document from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotMoveDocumentFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.sourceFile = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFile).moveTo((ContentModel)this.targetFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify unauthorized user cannot move Folder from moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserCannotMoveFolderFromModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.sourceFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createFolder();
        this.targetFolder = ((DataContent)this.dataContent.usingUser(this.siteManager).usingSite(moderatedSite)).createFolder();
        this.cmisApi.authenticateUser(this.unauthorizedUser).usingResource((ContentModel)this.sourceFolder).moveTo((ContentModel)this.targetFolder);
    }
}

