/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.dsl.DSLAssertion;
import org.alfresco.utility.dsl.DSLProtocol;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;

public class CmisAssertion
extends DSLAssertion<CmisWrapper> {
    public static String STEP_PREFIX = "CMIS:";

    public CmisAssertion(CmisWrapper cmisAPI) {
        super((DSLProtocol)cmisAPI);
    }

    public CmisWrapper cmisAPI() {
        return (CmisWrapper)((Object)this.getProtocol());
    }

    public CmisWrapper existsInRepo() {
        Step.STEP((String)String.format("CMIS: Assert that content '%s' exists in repository", this.cmisAPI().getLastResource()));
        Assert.assertTrue((!this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource()).getId().isEmpty() ? 1 : 0) != 0, (String)String.format("Content {%s} was found in repository", this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper doesNotExistInRepo() {
        Step.STEP((String)String.format("CMIS: Assert that content '%s' does not exist in repository", this.cmisAPI().getLastResource()));
        boolean notFound = false;
        try {
            this.cmisAPI().getSession().clear();
            this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        }
        catch (CmisObjectNotFoundException | CmisRuntimeException e) {
            notFound = true;
        }
        Assert.assertTrue((boolean)notFound, (String)String.format("Content {%s} was NOT found in repository", this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper contentModelHasChanges(ContentModel model, ChangeType ... changeTypes) throws Exception {
        String token = this.cmisAPI().getRepositoryInfo().getLatestChangeLogToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new TestConfigurationException("Please enable CMIS audit");
        }
        ItemIterable events = this.cmisAPI().getSession().getContentChanges(token, true);
        String lastObjectId = model.getNodeRef();
        boolean isChange = false;
        for (ChangeType changeType : changeTypes) {
            Step.STEP((String)String.format("%s Verify action %s for content: %s", CmisWrapper.STEP_PREFIX, changeType, model.getName()));
            isChange = false;
            for (ChangeEvent event : events) {
                if (!event.getObjectId().equals(lastObjectId) || changeType != event.getChangeType()) continue;
                isChange = true;
                break;
            }
            Assert.assertTrue((boolean)isChange, (String)String.format("Action %s for content: '%s' was found", changeType, model.getName()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper contentModelDoesnotHaveChangesWithWrongToken(ContentModel model, ChangeType ... changeTypes) throws Exception {
        String token = this.cmisAPI().getRepositoryInfo().getLatestChangeLogToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new TestConfigurationException("Please enable CMIS audit");
        }
        ItemIterable events = this.cmisAPI().getSession().getContentChanges(token + "1", true);
        String lastObjectId = model.getNodeRef();
        boolean isChange = false;
        for (ChangeType changeType : changeTypes) {
            Step.STEP((String)String.format("%s Verify action %s for content: %s", CmisWrapper.STEP_PREFIX, changeType, model.getName()));
            isChange = false;
            for (ChangeEvent event : events) {
                if (!event.getObjectId().equals(lastObjectId) || changeType != event.getChangeType()) continue;
                isChange = true;
                break;
            }
            Assert.assertFalse((boolean)isChange, (String)String.format("Action %s for content: '%s' was found", changeType, model.getName()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper hasAllowableActions(Action ... actions) {
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        for (Action action : actions) {
            Step.STEP((String)String.format("%s Verify if object %s has allowable action %s", CmisWrapper.STEP_PREFIX, cmisObject.getName(), action.name()));
            Assert.assertTrue((boolean)cmisObject.hasAllowableAction(action), (String)String.format("Object %s does not have action %s", cmisObject.getName(), action.name()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper isAllowableActionInList(Action ... actions) {
        List<Action> currentActions = this.cmisAPI().withCMISUtil().getAllowableActions();
        for (Action action : actions) {
            Step.STEP((String)String.format("%s Verify that action '%s' exists", CmisWrapper.STEP_PREFIX, action.name()));
            Assert.assertTrue((boolean)currentActions.contains(action), (String)String.format("Action %s was found", action.name()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper doesNotHaveAllowableActions(Action ... actions) {
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        for (Action action : actions) {
            Step.STEP((String)String.format("%s Verify if object %s does not have allowable action %s", CmisWrapper.STEP_PREFIX, cmisObject.getName(), action.name()));
            Assert.assertFalse((boolean)cmisObject.hasAllowableAction(action), (String)String.format("Object %s does not have action %s", cmisObject.getName(), action.name()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper contentIs(String content) throws Exception {
        Step.STEP((String)String.format("%s Verify if content '%s' is the expected one", CmisWrapper.STEP_PREFIX, content));
        Assert.assertEquals((String)this.cmisAPI().withCMISUtil().getDocumentContent(), (String)content, (String)String.format("The content of file %s - is the expected one", this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper contentContains(String content) throws Exception {
        Step.STEP((String)String.format("%s Verify if content '%s' is the expected one", CmisWrapper.STEP_PREFIX, content));
        Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().getDocumentContent().contains(content), (String)String.format("The content of file %s - is the expected one", this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper objectIdIs(String id) {
        CmisObject objSource = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if '%s' object has '%s' id", CmisWrapper.STEP_PREFIX, objSource.getName(), id));
        Assert.assertEquals((String)objSource.getId(), (String)id, (String)"Object has id.");
        return this.cmisAPI();
    }

    public CmisWrapper contentPropertyHasValue(String property, String value) {
        CmisObject objSource = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if '%s' property for '%s' content has '%s' value", CmisWrapper.STEP_PREFIX, property, objSource.getName(), value));
        Object propertyValue = objSource.getPropertyValue(property);
        if (propertyValue instanceof ArrayList) {
            ArrayList values = (ArrayList)propertyValue;
            Assert.assertEquals((String)((String)values.get(0)).toString(), (String)value, (String)"Property has value.");
        } else {
            Assert.assertEquals((String)propertyValue.toString(), (String)value, (String)"Property has value.");
        }
        return this.cmisAPI();
    }

    public CmisWrapper documentIsCheckedOut() {
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if document '%s' is checked out", CmisWrapper.STEP_PREFIX, document.getName()));
        Assert.assertTrue((boolean)document.isVersionSeriesCheckedOut(), (String)"Document is checkedout");
        return this.cmisAPI();
    }

    public CmisWrapper isPrivateWorkingCopy() {
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if document '%s' is private working copy", CmisWrapper.STEP_PREFIX, document.getName()));
        Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isPrivateWorkingCopy());
        return this.cmisAPI();
    }

    public CmisWrapper isNotPrivateWorkingCopy() {
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if document '%s' PWC is not private working copy", CmisWrapper.STEP_PREFIX, document.getName()));
        Assert.assertFalse((boolean)this.cmisAPI().withCMISUtil().isPrivateWorkingCopy());
        return this.cmisAPI();
    }

    public CmisWrapper documentIsNotCheckedOut() {
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if document '%s' is not checked out", CmisWrapper.STEP_PREFIX, document.getName()));
        Assert.assertFalse((boolean)document.isVersionSeriesCheckedOut(), (String)"Document is not checked out");
        return this.cmisAPI();
    }

    public CmisWrapper objectHasRelationshipWith(ContentModel targetContent) {
        OperationContextImpl oc = new OperationContextImpl();
        oc.setIncludeRelationships(IncludeRelationships.SOURCE);
        CmisObject source = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource(), (OperationContext)oc);
        CmisObject target = this.cmisAPI().withCMISUtil().getCmisObject(targetContent.getCmisLocation());
        Step.STEP((String)String.format("%s Verify if source '%s' has relationship with '%s'", CmisWrapper.STEP_PREFIX, source.getName(), target.getName()));
        ArrayList<String> relTargetIds = new ArrayList<String>();
        for (Relationship rel : source.getRelationships()) {
            relTargetIds.add(rel.getTarget().getId());
        }
        Assert.assertTrue((boolean)relTargetIds.contains(target.getId()), (String)String.format("Relationship is created between source '%s' and target '%s'.", source.getName(), target.getName()));
        return this.cmisAPI();
    }

    public CmisWrapper documentHasVersion(double version) throws Exception {
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        document.refresh();
        Step.STEP((String)String.format("%s Verify if document '%s' has version '%s'", CmisWrapper.STEP_PREFIX, document.getName(), version));
        Assert.assertEquals((double)Double.parseDouble(document.getVersionLabel()), (double)version, (String)"File has version");
        return this.cmisAPI();
    }

    public CmisWrapper folderHasParent(ContentModel contentModel) {
        Step.STEP((String)String.format("%s Verify folder %s has parent %s", CmisWrapper.STEP_PREFIX, this.cmisAPI().getLastResource(), contentModel.getName()));
        Assert.assertEquals((String)this.cmisAPI().withCMISUtil().getFolderParent().getName(), (String)contentModel.getName(), (String)"Folder name is not the expected one");
        return this.cmisAPI();
    }

    public CmisWrapper baseTypeIdIs(String baseTypeId) throws Exception {
        Step.STEP((String)String.format("%s Verify if base object type '%s' is the expected one", CmisWrapper.STEP_PREFIX, baseTypeId));
        String actualBaseTypeIdValue = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource()).getType().getBaseTypeId().value();
        Assert.assertEquals((String)actualBaseTypeIdValue, (String)baseTypeId, (String)"Object type is the expected one");
        return this.cmisAPI();
    }

    public CmisWrapper objectTypeIdIs(String objectTypeId) throws Exception {
        Step.STEP((String)String.format("%s Verify if object type id '%s' is the expected one", CmisWrapper.STEP_PREFIX, objectTypeId));
        String typeId = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource()).getType().getId();
        if (StringUtils.isEmpty((CharSequence)typeId)) {
            typeId = "";
        }
        Assert.assertEquals((String)this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource()).getType().getId(), (String)objectTypeId, (String)"Object type id is the expected one");
        return this.cmisAPI();
    }

    public CmisWrapper objectHasProperty(String propertyId, Object value) {
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if object %s has property %s ", CmisWrapper.STEP_PREFIX, cmisObject.getName(), propertyId));
        Property property = this.cmisAPI().withCMISUtil().getProperty(propertyId);
        Object propValue = property.getValue();
        if (propValue instanceof GregorianCalendar) {
            Date date = (Date)value;
            long longDate = date.getTime();
            long actualDate = ((GregorianCalendar)propValue).getTimeInMillis();
            Assert.assertEquals((long)actualDate, (long)longDate);
        } else {
            if (propValue == null) {
                propValue = "";
            }
            Assert.assertEquals((String)property.getValue().toString(), (String)value.toString(), (String)String.format("Found property value %s", value));
        }
        return this.cmisAPI();
    }

    public CmisWrapper objectHasProperty(String propertyId, String displayName, String localName, String queryName, String ... values) {
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource());
        Step.STEP((String)String.format("%s Verify if object %s has property %s ", CmisWrapper.STEP_PREFIX, cmisObject.getName(), propertyId));
        Property property = this.cmisAPI().withCMISUtil().getProperty(propertyId);
        if (property != null) {
            Assert.assertEquals((String)property.getDisplayName(), (String)displayName, (String)"Property displayName");
            Assert.assertEquals((String)property.getLocalName(), (String)localName, (String)"Property localName");
            Assert.assertEquals((String)property.getQueryName(), (String)queryName, (String)"Property queryName");
            for (String value : values) {
                Assert.assertTrue((boolean)property.getValues().contains(value), (String)"Property value");
            }
        } else {
            throw new AssertionError((Object)String.format("Object %s does not have property %s", cmisObject.getName(), propertyId));
        }
        return this.cmisAPI();
    }

    public CmisWrapper isLatestMajorVersion() {
        String path = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Verify that document from '%s' is latest major version", CmisWrapper.STEP_PREFIX, path));
        Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().getCmisDocument(path).isLatestMajorVersion(), (String)String.format("Document from %s is last major version", path));
        return this.cmisAPI();
    }

    public CmisWrapper isNotLatestMajorVersion() {
        String path = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Verify that document from '%s' is not latest major version", CmisWrapper.STEP_PREFIX, path));
        Assert.assertFalse((boolean)this.cmisAPI().withCMISUtil().getCmisDocument(path).isLatestMajorVersion(), (String)String.format("Document from %s is last major version", path));
        return this.cmisAPI();
    }

    public CmisWrapper renditionIsAvailable() {
        Step.STEP((String)String.format("%s Verify if renditions are available for %s", CmisWrapper.STEP_PREFIX, this.cmisAPI().getLastResource()));
        List<Rendition> renditions = this.cmisAPI().withCMISUtil().getRenditions();
        Assert.assertTrue((renditions != null && !renditions.isEmpty() ? 1 : 0) != 0);
        return this.cmisAPI();
    }

    public CmisWrapper thumbnailRenditionIsAvailable() {
        boolean found = false;
        Step.STEP((String)String.format("%s Verify if thumbnail rendition is available for %s", CmisWrapper.STEP_PREFIX, this.cmisAPI().getLastResource()));
        List<Rendition> renditions = this.cmisAPI().withCMISUtil().getRenditions();
        for (Rendition rendition : renditions) {
            if (!rendition.getKind().equals("cmis:thumbnail")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found, (String)String.format("Thumbnail rendition found for", this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    private boolean isSecondaryTypeAvailable(String secondaryTypeId) {
        boolean found = false;
        List<SecondaryType> secondaryTypes = this.cmisAPI().withCMISUtil().getSecondaryTypes();
        for (SecondaryType type : secondaryTypes) {
            if (!type.getId().equals(secondaryTypeId)) continue;
            found = true;
            break;
        }
        return found;
    }

    public CmisWrapper secondaryTypeIsAvailable(String secondaryTypeId) {
        Step.STEP((String)String.format("%s Verify if '%s' secondary type is available for '%s'", CmisWrapper.STEP_PREFIX, secondaryTypeId, new File(this.cmisAPI().getLastResource()).getName()));
        Assert.assertTrue((boolean)this.isSecondaryTypeAvailable(secondaryTypeId), (String)String.format("%s is available for %s", secondaryTypeId, this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper secondaryTypeIsNotAvailable(String secondaryTypeId) {
        Step.STEP((String)String.format("%s Verify if '%s' aspect is NOT available for %s", CmisWrapper.STEP_PREFIX, secondaryTypeId, this.cmisAPI().getLastResource()));
        Assert.assertFalse((boolean)this.isSecondaryTypeAvailable(secondaryTypeId), (String)String.format("%s is NOT available for %s", secondaryTypeId, this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper contentLengthIs(long contentLength) throws Exception {
        Step.STEP((String)String.format("%s Verify if content length '%s' is the expected one", CmisWrapper.STEP_PREFIX, contentLength));
        Document lastVersion = this.cmisAPI().withCMISUtil().getCmisDocument(this.cmisAPI().getLastResource());
        lastVersion.refresh();
        Assert.assertEquals((long)lastVersion.getContentStreamLength(), (long)contentLength, (String)"File content is the expected one");
        return this.cmisAPI();
    }

    public void hasDescendants(int depth, ContentModel ... contentModels) {
        Step.STEP((String)String.format("%s Assert that folder %s has descendants in depth %d:", STEP_PREFIX, ((CmisWrapper)((Object)this.getProtocol())).getLastResource(), depth));
        CmisObject currentCmisObject = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getCmisObject(((CmisWrapper)((Object)this.getProtocol())).getLastResource());
        List<CmisObject> cmisObjects = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<CmisObject> folderDescendants = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getFolderDescendants(depth);
        for (CmisObject cmisObject : cmisObjects) {
            boolean found = false;
            Step.STEP((String)String.format("%s Verify that folder '%s' has descendant %s", CmisWrapper.STEP_PREFIX, currentCmisObject.getName(), cmisObject.getName()));
            for (CmisObject folderDescendant : folderDescendants) {
                if (!folderDescendant.getId().equals(cmisObject.getId())) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found, (String)String.format("Folder %s does not have descendant %s", currentCmisObject.getName(), cmisObject));
        }
    }

    public void doesNotHaveDescendants(int depth) {
        Step.STEP((String)String.format("%s Assert that folder %s does not have descendants in depth %d:", STEP_PREFIX, ((CmisWrapper)((Object)this.getProtocol())).getLastResource(), depth));
        CmisObject currentCmisObject = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getCmisObject(((CmisWrapper)((Object)this.getProtocol())).getLastResource());
        List<CmisObject> folderDescendants = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getFolderDescendants(depth);
        Assert.assertTrue((boolean)folderDescendants.isEmpty(), (String)String.format("Folder %s should not have descendants", currentCmisObject.getName()));
    }

    public CmisWrapper hasAcls() {
        Step.STEP((String)String.format("%s Verify that %s has acls", CmisWrapper.STEP_PREFIX, this.cmisAPI().getLastResource()));
        String path = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Get Acls for %s", CmisWrapper.STEP_PREFIX, path));
        Assert.assertNotNull((Object)this.cmisAPI().withCMISUtil().getAcls(), (String)String.format("Acls found for %s", path));
        return this.cmisAPI();
    }

    public CmisWrapper hasFolderTree(int depth, ContentModel ... contentModels) {
        CmisObject currentCmisObject = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getCmisObject(((CmisWrapper)((Object)this.getProtocol())).getLastResource());
        List<CmisObject> cmisObjects = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<CmisObject> folderDescendants = ((CmisWrapper)((Object)this.getProtocol())).withCMISUtil().getFolderTree(depth);
        for (CmisObject cmisObject : cmisObjects) {
            boolean found = false;
            Step.STEP((String)String.format("%s Verify that folder '%s' has folder tree %s", CmisWrapper.STEP_PREFIX, currentCmisObject.getName(), cmisObject.getName()));
            for (CmisObject folderDescendant : folderDescendants) {
                if (!folderDescendant.getId().equals(cmisObject.getId())) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found, (String)String.format("Folder %s does not have folder tree %s", currentCmisObject.getName(), cmisObject));
        }
        return this.cmisAPI();
    }

    public CmisWrapper permissionIsSetForUser(UserModel userModel, UserRole role) {
        Step.STEP((String)String.format("%s Verify that user %s has role %s set to content %s", CmisWrapper.STEP_PREFIX, userModel.getUsername(), role.name(), this.cmisAPI().getLastResource()));
        Assert.assertTrue((boolean)this.checkPermission(userModel.getUsername(), role.getRoleId()), (String)String.format("User %s has permission %s", userModel.getUsername(), role.name()));
        return this.cmisAPI();
    }

    public CmisWrapper permissionIsSetForGrup(GroupModel groupModel, UserRole role) {
        Step.STEP((String)String.format("%s Verify that user %s has role %s set to content %s", CmisWrapper.STEP_PREFIX, groupModel.getDisplayName(), role.name(), this.cmisAPI().getLastResource()));
        Assert.assertTrue((boolean)this.checkPermission(groupModel.getDisplayName(), role.getRoleId()), (String)String.format("User %s has permission %s", groupModel.getDisplayName(), role.name()));
        return this.cmisAPI();
    }

    private boolean checkPermission(String user, String permission) {
        Acl acl = this.cmisAPI().withCMISUtil().getAcls();
        if (acl == null) {
            throw new CmisRuntimeException(String.format("No acls returned for '%s'", this.cmisAPI().getLastResource()));
        }
        List aces = acl.getAces();
        boolean found = false;
        for (Ace ace : aces) {
            if (!ace.getPrincipalId().equals(user) || !((String)ace.getPermissions().get(0)).equals(permission)) continue;
            found = true;
            break;
        }
        return found;
    }

    public CmisWrapper permissionIsSetForUser(UserModel userModel, String permission) {
        Step.STEP((String)String.format("%s Verify that user %s has role %s set to content %s", CmisWrapper.STEP_PREFIX, userModel.getUsername(), permission, this.cmisAPI().getLastResource()));
        Assert.assertTrue((boolean)this.checkPermission(userModel.getUsername(), permission), (String)String.format("User %s has permission %s", userModel.getUsername(), permission));
        return this.cmisAPI();
    }

    public CmisWrapper permissionIsNotSetForUser(UserModel userModel, UserRole role) {
        Step.STEP((String)String.format("%s Verify that user %s doesn't have role %s set to content %s", CmisWrapper.STEP_PREFIX, userModel.getUsername(), role.name(), this.cmisAPI().getLastResource()));
        Assert.assertFalse((boolean)this.checkPermission(userModel.getUsername(), role.getRoleId()), (String)String.format("User %s has permission %s", userModel.getUsername(), role.name()));
        return this.cmisAPI();
    }

    public CmisWrapper permissionIsNotSetForUser(UserModel userModel, String permission) {
        Step.STEP((String)String.format("%s Verify that user %s doesn't have permission %s set to content %s", CmisWrapper.STEP_PREFIX, userModel.getUsername(), permission, this.cmisAPI().getLastResource()));
        Assert.assertFalse((boolean)this.checkPermission(userModel.getUsername(), permission), (String)String.format("User %s has permission %s", userModel.getUsername(), permission));
        return this.cmisAPI();
    }

    public CmisWrapper typeDefinitionIs(ContentModel contentModel) {
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(contentModel.getCmisLocation());
        Step.STEP((String)String.format("%s Verify that object '%s' type definition matches '%s' type definition", CmisWrapper.STEP_PREFIX, cmisObject.getName(), this.cmisAPI().withCMISUtil().getTypeDefinition().getId()));
        Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().getTypeDefinition().equals((Object)cmisObject.getType()), (String)String.format("Object '%s' type definition does not match '%s' type definition", cmisObject.getName(), this.cmisAPI().withCMISUtil().getTypeDefinition().getId()));
        return this.cmisAPI();
    }

    public CmisWrapper folderHasCheckedOutDocument(ContentModel ... contentModels) {
        List<CmisObject> cmisObjectList = this.cmisAPI().withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<Document> cmisCheckedOutDocuments = this.cmisAPI().withCMISUtil().getCheckedOutDocumentsFromFolder();
        for (CmisObject cmisObject : cmisObjectList) {
            Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isCmisObjectContainedInCmisCheckedOutDocumentsList(cmisObject, cmisCheckedOutDocuments), (String)String.format("Folder %s does not contain checked out document %s", this.cmisAPI().getLastResource(), cmisObject));
        }
        return this.cmisAPI();
    }

    public CmisWrapper folderHasCheckedOutDocument(OperationContext context, ContentModel ... contentModels) {
        List<CmisObject> cmisObjectList = this.cmisAPI().withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<Document> cmisCheckedOutDocuments = this.cmisAPI().withCMISUtil().getCheckedOutDocumentsFromFolder(context);
        for (int i = 0; i < cmisObjectList.size(); ++i) {
            Assert.assertEquals((String)cmisObjectList.get(i).getId().split(";")[0], (String)cmisCheckedOutDocuments.get(i).getId().split(";")[0], (String)String.format("Folder %s does not contain checked out document %s", this.cmisAPI().getLastResource(), cmisObjectList.get(i).getName()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper sessionHasCheckedOutDocument(ContentModel ... contentModels) {
        List<CmisObject> cmisObjectList = this.cmisAPI().withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<Document> cmisCheckedOutDocuments = this.cmisAPI().withCMISUtil().getCheckedOutDocumentsFromSession();
        for (CmisObject cmisObject : cmisObjectList) {
            Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isCmisObjectContainedInCmisCheckedOutDocumentsList(cmisObject, cmisCheckedOutDocuments), (String)String.format("Session does not contain checked out document %s", cmisObject));
        }
        return this.cmisAPI();
    }

    public CmisWrapper sessionHasCheckedOutDocument(OperationContext context, ContentModel ... contentModels) {
        List<CmisObject> cmisObjectList = this.cmisAPI().withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<Document> cmisCheckedOutDocuments = this.cmisAPI().withCMISUtil().getCheckedOutDocumentsFromSession(context);
        for (int i = 0; i < cmisObjectList.size(); ++i) {
            Assert.assertEquals((String)cmisObjectList.get(i).getId().split(";")[0], (String)cmisCheckedOutDocuments.get(i).getId().split(";")[0], (String)String.format("Session does not contain checked out document %s", cmisObjectList.get(i).getName()));
        }
        return this.cmisAPI();
    }

    public CmisWrapper sessioDoesNotHaveCheckedOutDocument(ContentModel ... contentModels) {
        List<CmisObject> cmisObjectList = this.cmisAPI().withCMISUtil().getCmisObjectsFromContentModels(contentModels);
        List<Document> cmisCheckedOutDocuments = this.cmisAPI().withCMISUtil().getCheckedOutDocumentsFromSession();
        for (CmisObject cmisObject : cmisObjectList) {
            Assert.assertFalse((boolean)this.cmisAPI().withCMISUtil().isCmisObjectContainedInCmisCheckedOutDocumentsList(cmisObject, cmisCheckedOutDocuments), (String)String.format("Session does contain checked out document %s", cmisObject));
        }
        return this.cmisAPI();
    }

    public CmisWrapper hasAspectExtension(String aspectId) {
        Step.STEP((String)String.format("Verify that aspect %s is applied to %s", aspectId, this.cmisAPI().getLastResource()));
        boolean found = false;
        List extensions = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource()).getExtensions(ExtensionLevel.PROPERTIES);
        for (CmisExtensionElement extElement : extensions) {
            if (!extElement.getName().equals("aspects")) continue;
            List aspects = extElement.getChildren();
            for (CmisExtensionElement aspect : aspects) {
                if (aspect.getValue() == null || !aspect.getValue().equals(aspectId)) continue;
                found = true;
            }
        }
        Assert.assertTrue((boolean)found, (String)String.format("Aspect extension %s for %s was found", aspectId, this.cmisAPI().getLastResource()));
        return this.cmisAPI();
    }

    public CmisWrapper hasParents(String ... parentsList) {
        ArrayList<String> folderNames = new ArrayList<String>();
        List parents = new ArrayList();
        String source = this.cmisAPI().getLastResource();
        CmisObject objSource = this.cmisAPI().withCMISUtil().getCmisObject(source);
        Step.STEP((String)String.format("%s Verify the parents for '%s'.", CmisWrapper.STEP_PREFIX, objSource.getName()));
        if (objSource instanceof Document) {
            Document d = (Document)objSource;
            parents = d.getParents();
        } else if (objSource instanceof Folder) {
            Folder f = (Folder)objSource;
            parents = f.getParents();
        }
        for (Folder folder : parents) {
            folderNames.add(folder.getName());
        }
        Assert.assertEqualsNoOrder((Object[])folderNames.toArray(), (Object[])parentsList, (String)"Parents list is the expected one.");
        return this.cmisAPI();
    }

    public CmisWrapper descriptionIs(String description) {
        String source = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Verify object '%s' description is '%s'", CmisWrapper.STEP_PREFIX, source, description));
        CmisObject cmisObject = this.cmisAPI().withCMISUtil().getCmisObject(source);
        Assert.assertEquals((String)description, (String)cmisObject.getDescription());
        return this.cmisAPI();
    }

    public CmisWrapper hasFolders(FolderModel ... folderModel) throws Exception {
        String currentSpace = this.cmisAPI().getCurrentSpace();
        List<FolderModel> folders = this.cmisAPI().getFolders();
        for (FolderModel folder : folderModel) {
            Step.STEP((String)String.format("%s Verify that folder %s is in %s", CmisWrapper.STEP_PREFIX, folder.getName(), currentSpace));
            Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isFolderInList(folder, folders), (String)String.format("Folder %s is in %s", folder.getName(), currentSpace));
        }
        return this.cmisAPI();
    }

    public CmisWrapper hasFiles(FileModel ... fileModel) throws Exception {
        String currentSpace = this.cmisAPI().getLastResource();
        List<FileModel> files = this.cmisAPI().getFiles();
        for (FileModel file : fileModel) {
            Step.STEP((String)String.format("%s Verify that file '%s' is in '%s'", CmisWrapper.STEP_PREFIX, file.getName(), currentSpace));
            Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isFileInList(file, files), (String)String.format("File %s is in %s", file.getName(), currentSpace));
        }
        return this.cmisAPI();
    }

    public CmisWrapper doesNotHaveFile(FileModel ... fileModels) throws Exception {
        String currentSpace = this.cmisAPI().getLastResource();
        List<FileModel> files = this.cmisAPI().getFiles();
        for (FileModel fileModel : fileModels) {
            Step.STEP((String)String.format("%s Verify that file '%s' is not in '%s'", CmisWrapper.STEP_PREFIX, fileModel.getName(), currentSpace));
            Assert.assertFalse((boolean)this.cmisAPI().withCMISUtil().isFileInList(fileModel, files), (String)String.format("File %s is in %s", fileModel.getName(), currentSpace));
        }
        return this.cmisAPI();
    }

    public CmisWrapper doesNotHaveFolder(FolderModel ... folderModels) throws Exception {
        String currentSpace = this.cmisAPI().getLastResource();
        List<FolderModel> folders = this.cmisAPI().getFolders();
        for (FolderModel folderModel : folderModels) {
            Step.STEP((String)String.format("%s Verify that folder '%s' is not in '%s'", CmisWrapper.STEP_PREFIX, folderModel.getName(), currentSpace));
            Assert.assertFalse((boolean)this.cmisAPI().withCMISUtil().isFolderInList(folderModel, folders), (String)String.format("File %s is in %s", folderModel.getName(), currentSpace));
        }
        return this.cmisAPI();
    }

    public CmisWrapper hasChildren(ContentModel ... contentModel) throws Exception {
        String currentSpace = this.cmisAPI().getCurrentSpace();
        Map<ContentModel, ObjectType> mapContents = this.cmisAPI().withCMISUtil().getChildren();
        ArrayList<ContentModel> contents = new ArrayList<ContentModel>();
        for (Map.Entry<ContentModel, ObjectType> entry : mapContents.entrySet()) {
            contents.add(entry.getKey());
        }
        for (ContentModel content : contentModel) {
            Step.STEP((String)String.format("%s Verify that file %s is in %s", CmisWrapper.STEP_PREFIX, content.getName(), currentSpace));
            Assert.assertTrue((boolean)this.cmisAPI().withCMISUtil().isContentInList(content, contents), (String)String.format("Content %s is in %s", content.getName(), currentSpace));
        }
        return this.cmisAPI();
    }

    public CmisWrapper hasUniqueChildren(int numberOfChildren) throws Exception {
        Step.STEP((String)String.format("%s Verify that current folder has %d unique children", CmisWrapper.STEP_PREFIX, numberOfChildren));
        Map<ContentModel, ObjectType> mapContents = this.cmisAPI().withCMISUtil().getChildren();
        HashSet<String> documentIds = new HashSet<String>();
        for (ContentModel key : mapContents.keySet()) {
            documentIds.add(key.getName());
        }
        Assert.assertTrue((numberOfChildren == documentIds.size() ? 1 : 0) != 0, (String)String.format("Current folder contains %d unique children, but expected is %d", documentIds.size(), numberOfChildren));
        return this.cmisAPI();
    }

    public CmisWrapper hasCheckInCommentLastVersion(String comment) {
        String source = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Verify check in comment for last version of %s", CmisWrapper.STEP_PREFIX, source));
        Document document = this.cmisAPI().withCMISUtil().getCmisDocument(source);
        Assert.assertEquals((String)comment, (String)document.getCheckinComment(), (String)String.format("Document %s has check in comment %s", document.getName(), comment));
        return this.cmisAPI();
    }

    public CmisWrapper hasCheckInCommentForVersion(double documentVersion, String comment) {
        String source = this.cmisAPI().getLastResource();
        Step.STEP((String)String.format("%s Verify check in comment for version %s of %s", CmisWrapper.STEP_PREFIX, documentVersion, source));
        Object documentId = this.cmisAPI().withCMISUtil().getObjectId(source).split(";")[0];
        documentId = (String)documentId + ";" + documentVersion;
        Document document = (Document)this.cmisAPI().withCMISUtil().getCmisObjectById((String)documentId);
        Assert.assertEquals((String)comment, (String)document.getCheckinComment(), (String)String.format("Document %s has check in comment %s", document.getName(), comment));
        return this.cmisAPI();
    }

    public CmisWrapper hasFailedDeletedObject(String nodeRef) {
        Step.STEP((String)String.format("%s Verify failed deleted object from %s", CmisWrapper.STEP_PREFIX, this.cmisAPI().getLastResource()));
        Assert.assertTrue((boolean)this.cmisAPI().deleteTreeFailedObjects.contains(nodeRef), (String)String.format("Object %s found after delete", nodeRef));
        return this.cmisAPI();
    }

    public CmisWrapper userIsAssigned(UserModel user) {
        OperationContextImpl oc = new OperationContextImpl();
        oc.setIncludeRelationships(IncludeRelationships.SOURCE);
        CmisObject source = this.cmisAPI().withCMISUtil().getCmisObject(this.cmisAPI().getLastResource(), (OperationContext)oc);
        String userNodeRef = this.cmisAPI().withCMISUtil().getUserNodeRef(user);
        Step.STEP((String)String.format("%s Verify if user '%s' has relationship with '%s'", CmisWrapper.STEP_PREFIX, user.getUsername(), source.getName()));
        ArrayList<String> relTargetIds = new ArrayList<String>();
        for (Relationship rel : source.getRelationships()) {
            relTargetIds.add(rel.getTarget().getId());
        }
        Assert.assertTrue((boolean)relTargetIds.contains(userNodeRef), (String)String.format("Relationship is created between source '%s' and target '%s'.", source.getName(), user.getUsername()));
        return this.cmisAPI();
    }
}

