/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.util.List;
import java.util.Set;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.dsl.QueryExecutor;
import org.alfresco.cmis.search.AbstractCmisE2ETest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchInFolderTests
extends AbstractCmisE2ETest {
    private FolderModel parentFolder;
    private FolderModel subFolder1;
    private FolderModel subFolder2;
    private FolderModel subFolder3;
    private FileModel subFile1;
    private FileModel subFile2;
    private FileModel subFile3;
    private FileModel subFile4;
    private FileModel subFile5;

    @BeforeClass(alwaysRun=true)
    public void createTestData() throws Exception {
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.subFolder1 = FolderModel.getRandomFolderModel();
        this.subFolder2 = FolderModel.getRandomFolderModel();
        this.subFolder3 = new FolderModel("subFolder");
        this.subFile5 = new FileModel("fifthFile.txt", FileType.TEXT_PLAIN, "fifthFile content");
        this.subFile1 = new FileModel("firstFile", FileType.MSEXCEL);
        this.subFile2 = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT2007);
        this.subFile3 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.subFile4 = new FileModel("fourthFile", "fourthFileTitle", "fourthFileDescription", FileType.MSWORD2007);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.parentFolder).then()).usingResource((ContentModel)this.parentFolder).createFile(this.subFile5).assertThat().contentIs("fifthFile content").createFolder(this.subFolder1).createFolder(this.subFolder2).createFolder(this.subFolder3).createFile(this.subFile1).createFile(this.subFile2).createFile(this.subFile3).createFile(this.subFile4);
        Utility.waitToLoopTime((int)this.getElasticWaitTimeInSeconds(), (String[])new String[0]);
    }

    @AfterClass(alwaysRun=true)
    public void cleanupEnvironment() {
        this.dataContent.deleteSite(this.testSite);
    }

    @Test
    public void executeCMISQuery_selectFieldsFromFolder() {
        String query = "SELECT cmis:name, cmis:parentId, cmis:path, cmis:allowedChildObjectTypeIds FROM cmis:folder where IN_FOLDER('%s') AND cmis:name = 'subFolder'";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFolder3});
    }

    @Test
    public void executeCMISQuery_selectFieldsFromDocument() {
        String query = "SELECT cmis:name, cmis:objectId, cmis:lastModifiedBy, cmis:creationDate, cmis:contentStreamFileName FROM cmis:document where IN_FOLDER('%s') AND cmis:name = 'fourthFile'";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile4});
    }

    @Test
    public void executeCMISQuery_selectParentId() {
        String query = "SELECT cmis:parentId FROM cmis:folder where IN_FOLDER('%s')";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        String parentId = this.parentFolder.getNodeRef();
        List<String> expectedParentIds = List.of(parentId, parentId, parentId);
        this.waitForIndexing(currentQuery, (QueryExecutor.QueryResultAssertion execution) -> execution.isReturningOrderedValues("cmis:parentId", expectedParentIds));
    }

    @Test
    public void executeCMISQuery_inFolder() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s')";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile1, this.subFile2, this.subFile3, this.subFile4, this.subFile5});
    }

    @Test
    public void executeCMISQuery_orderByNameAsc() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name NOT LIKE 'file%%' ORDER BY cmis:name ASC";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFile5, this.subFile1, this.subFile4});
    }

    @Test
    public void executeCMISQuery_orderByNameDesc() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name NOT LIKE 'file%%' ORDER BY cmis:name DESC";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFile4, this.subFile1, this.subFile5});
    }

    @Test
    public void executeCMISQuery_orderByLastModifiedAsc() {
        String query = "SELECT * FROM cmis:folder where IN_FOLDER('%s') ORDER BY cmis:lastModificationDate ASC";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFolder1, this.subFolder2, this.subFolder3});
    }

    @Test
    public void executeCMISQuery_orderByLastModifiedDesc() {
        String query = "SELECT * FROM cmis:folder where IN_FOLDER('%s') ORDER BY cmis:lastModificationDate DESC";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFolder3, this.subFolder2, this.subFolder1});
    }

    @Test
    public void executeCMISQuery_orderByCreatedBy() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') ORDER BY cmis:createdBy DESC";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile5, this.subFile1, this.subFile2, this.subFile3, this.subFile4});
    }

    @Test
    public void executeCMISQuery_documentNameNotNull() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name IS NOT NULL";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile1, this.subFile2, this.subFile3, this.subFile4, this.subFile5});
    }

    @Test
    public void executeCMISQuery_folderNameNotNull() {
        String query = "SELECT * FROM cmis:folder where IN_FOLDER('%s') AND cmis:name IS NOT NULL";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFolder1, this.subFolder2, this.subFolder3});
    }

    @Test
    public void executeCMISQuery_nameLike() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name LIKE 'fourthFile'";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFile4});
    }

    @Test
    public void executeCMISQuery_doubleNegative() {
        String query = "SELECT * FROM cmis:folder where IN_FOLDER('%s') AND NOT(cmis:name NOT IN ('subFolder'))";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexingOrdered(currentQuery, new ContentModel[]{this.subFolder3});
    }

    @Test
    public void executeCMISQuery_nameInList() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name IN ('fourthFile', 'fifthFile.txt')";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile4, this.subFile5});
    }

    @Test
    public void executeCMISQuery_nameNotInList() {
        String query = "SELECT * FROM cmis:document where IN_FOLDER('%s') AND cmis:name NOT IN ('fourthFile', 'fifthFile.txt')";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile1, this.subFile2, this.subFile3});
    }

    @Test
    public void executeCMISQuery_nameDifferentFrom() {
        String query = "SELECT * FROM cmis:folder where IN_FOLDER('%s') AND cmis:name <> 'subFolder'";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFolder1, this.subFolder2});
    }

    @Test
    public void executeCMISQuery_selectSecondaryObjectTypeIds() {
        String query = "SELECT cmis:secondaryObjectTypeIds FROM cmis:folder where IN_FOLDER('%s') AND cmis:name = 'subFolder'";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        Set<List<String>> expectedSecondaryObjectTypeIds = Set.of(List.of("P:cm:titled", "P:sys:localized"));
        this.waitForIndexing(currentQuery, (QueryExecutor.QueryResultAssertion execution) -> execution.isReturningValues("cmis:secondaryObjectTypeIds", expectedSecondaryObjectTypeIds, true));
        Assert.assertTrue((boolean)this.waitForIndexing(currentQuery, 1L), (String)String.format("Result count not as expected for query: %s", currentQuery));
    }

    @Test
    public void executeCMISQuery_joinTitledAspectByTitle() {
        String query = "SELECT * FROM cmis:document AS d JOIN cm:titled as a0 ON d.cmis:objectId = a0.cmis:objectId WHERE CONTAINS(a0, 'cm:title:\\\"fourthFileTitle\\\"')";
        String currentQuery = String.format(query, this.parentFolder.getNodeRef());
        this.cmisApi.authenticateUser(this.testUser);
        this.waitForIndexing(currentQuery, new ContentModel[]{this.subFile4});
    }
}

