/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.HashMap;
import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.cmis.exception.InvalidCmisObjectException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateDocumentTests
extends CmisTest {
    SiteModel testSite;
    UserModel testUser;
    UserModel inexistentUser;
    FileModel testFile;
    FileModel adminFile;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.inexistentUser = new UserModel("inexistent", "inexistent");
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to create files in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerShouldCreateDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user isn't able to create files in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void inexistentUserShouldNotCreateDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisApi.authenticateUser(this.inexistentUser).usingSite(this.testSite).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user isn't able to create files in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void unauthorizedUserShouldNotCreateDocument() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisApi.authenticateUser(unauthorizedUser).usingSite(this.testSite).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to create files in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"})
    public void adminShouldCreateDocument() throws Exception {
        this.adminFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(this.testSite).createFile(this.adminFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document twice in the same location with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisContentAlreadyExistsException.class})
    public void siteManagerCannotCreateDocumentTwice() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document ending with '.'")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotCreateDocumentEndingWithPoint() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.documentContent);
        this.testFile.setName(this.testFile.getName() + ".");
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create document in invalid location with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void adminCannotCreateDocumentAtInvalidPath() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FolderModel invalidLocation = new FolderModel("/Shared/invalidFolder");
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)invalidLocation).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user is not able to create document with invalid characters in name with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void adminCannotCreateDocumentWithInvalidCharacters() throws Exception {
        FileModel invalidCharDoc = new FileModel("/.:?|\\`\\.txt", FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)FolderModel.getSharedFolderModel()).createFile(invalidCharDoc);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create document with invalid base type id with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotCreateDocWithInvalidObjectTypeId() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, "cmis:fakeType", VersioningState.MAJOR);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create document with cmis:folder base type id with CMIS")
    @Test(groups={"bug-atom-REPO-5389", "regression", "cmis"}, expectedExceptions={CmisConstraintException.class}, expectedExceptionsMessageRegExp=".*Type is not a document type.*")
    public void siteManagerCannotCreateDocWithFolderTypeId() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, BaseTypeId.CMIS_FOLDER.value(), VersioningState.MAJOR);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is able to create document with valid symbols in name")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanCreateDocumentWithValidSymbols() throws Exception {
        FileModel validSymbolsDoc = new FileModel("!@#$%^&", FileType.TEXT_PLAIN, "content");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(validSymbolsDoc).and()).assertThat().existsInRepo();
        Assert.assertNotNull((Object)this.cmisApi.withCMISUtil().getCmisObject(validSymbolsDoc.getCmisLocation()));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is not able to create document with empty name")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void siteManagerCannotCreateDocumentWithEmptyName() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(new FileModel("", FileType.TEXT_PLAIN));
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file with Major versioning state")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldCreateDocumentWithMajorVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.MAJOR).and()).assertThat().existsInRepo().and()).assertThat().documentHasVersion(1.0).assertThat().isLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file with Minor versioning state")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldCreateDocumentWithMinorVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.MINOR).and()).assertThat().existsInRepo().and()).assertThat().documentHasVersion(0.1).assertThat().isNotLatestMajorVersion();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file with CHECKEDOUT versioning state")
    @Test(groups={"regression", "cmis"})
    public void siteManagerShouldCreateDocumentWithCheckedOutVersioningState() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().and()).assertThat().documentIsCheckedOut().assertThat().isPrivateWorkingCopy();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to create file")
    @Test(groups={"regression", "cmis"})
    public void contributorShouldCreateDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to create file")
    @Test(groups={"regression", "cmis"})
    public void collaboratorShouldCreateDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to create file")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerShouldNotCreateDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingSite(this.testSite).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to create file")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserShouldNotCreateDocumentInSite() throws Exception {
        UserModel outsider = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(outsider).usingSite(this.testSite).createFile(this.testFile);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify disabled user is not able to create file in Shared folder")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void disabledUserShouldNotCreateDocument() throws Exception {
        UserModel disabled = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(disabled);
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabled);
        this.cmisApi.usingShared().createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to create file in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserShouldNotCreateDocumentInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(privateSite).createFile(this.testFile);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to create document with no properties")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Properties must not be empty!*")
    public void siteManagerCannotCreateDocumentWithNoProperties() throws Exception {
        HashMap properties = new HashMap();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile, properties, VersioningState.MAJOR);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to create file with a name containing multi byte characters.")
    @Test(groups={"regression", "cmis"})
    public void managerIsAbleToCreateFileWithMultiByteName() throws Exception {
        this.testFile = new FileModel(RandomData.getRandomAlphanumeric() + "\ufeff\u6768\u6728\u91d1");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager user is not able to create document at document location")
    @Test(groups={"regression", "cmis"}, expectedExceptions={InvalidCmisObjectException.class})
    public void siteManagerCannotCreateDocumentInDocumentLocation() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).usingResource((ContentModel)this.testFile).createFile(this.testFile);
    }
}

