/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.util.List;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.testng.Assert;

public class BaseObjectType {
    private CmisWrapper cmisAPI;
    private String baseTypeID;
    private boolean includePropertyDefinition = false;
    private Logger LOG = LogFactory.getLogger();

    public BaseObjectType(CmisWrapper cmisAPI, String baseTypeID) {
        this.cmisAPI = cmisAPI;
        this.baseTypeID = baseTypeID;
    }

    public BaseObjectType withPropertyDefinitions() {
        this.includePropertyDefinition = true;
        return this;
    }

    public BaseObjectType withoutPropertyDefinitions() {
        this.includePropertyDefinition = false;
        return this;
    }

    public PropertyDefinitionObject hasChildren(String objectTypeID) {
        return this.checkChildren(objectTypeID, true);
    }

    public CmisWrapper doesNotHaveChildren(String objectTypeID) {
        this.checkChildren(objectTypeID, false);
        return this.cmisAPI;
    }

    private PropertyDefinitionObject checkChildren(String objectTypeID, boolean exist) {
        ItemIterable<ObjectType> values = this.cmisAPI.withCMISUtil().getTypeChildren(this.baseTypeID, this.includePropertyDefinition);
        boolean foundChild = false;
        PropertyDefinitionObject propDefinition = null;
        for (ObjectType type : values) {
            this.LOG.info("Found child Object Type: {}", (Object)ToStringBuilder.reflectionToString((Object)type, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
            if (!type.getId().equals(objectTypeID)) continue;
            foundChild = true;
            propDefinition = new PropertyDefinitionObject(this, type);
            break;
        }
        Assert.assertEquals((boolean)foundChild, (boolean)exist, (String)String.format("Object Type with ID[%s] is found as children for Parent Type: [%s]", objectTypeID, this.baseTypeID));
        return propDefinition;
    }

    private CmisWrapper checkDescendents(int depth, boolean exist, String ... objectTypeIDs) {
        List<Tree<ObjectType>> values = this.cmisAPI.withCMISUtil().getTypeDescendants(this.baseTypeID, depth, this.includePropertyDefinition);
        for (String objectTypeID : objectTypeIDs) {
            boolean foundChild = false;
            for (Tree<ObjectType> tree : values) {
                if (!((ObjectType)tree.getItem()).getId().equals(objectTypeID)) continue;
                foundChild = true;
                break;
            }
            Assert.assertEquals((boolean)foundChild, (boolean)exist, (String)String.format("Assert %b: Descendant [%s] is found as descendant for Type: [%s]", exist, objectTypeID, this.baseTypeID));
            if (foundChild) {
                Step.STEP((String)String.format("%s Cmis object '%s' is found as descendant.", CmisWrapper.STEP_PREFIX, objectTypeID));
                continue;
            }
            Step.STEP((String)String.format("%s Cmis object '%s' is NOT found as descendant.", CmisWrapper.STEP_PREFIX, objectTypeID));
        }
        return this.cmisAPI;
    }

    public CmisWrapper hasDescendantType(int depth, String ... objectTypeIDs) {
        return this.checkDescendents(depth, true, objectTypeIDs);
    }

    public CmisWrapper doesNotHaveDescendantType(int depth, String ... objectTypeIDs) {
        this.checkDescendents(depth, false, objectTypeIDs);
        return this.cmisAPI;
    }

    public class PropertyDefinitionObject {
        ObjectType type;

        public PropertyDefinitionObject(BaseObjectType this$0, ObjectType type) {
            this.type = type;
        }

        public PropertyDefinitionObject propertyDefinitionIsEmpty() {
            Step.STEP((String)String.format("%s Verify that property definitions map is empty.", CmisWrapper.STEP_PREFIX));
            Assert.assertTrue((boolean)this.type.getPropertyDefinitions().isEmpty(), (String)"Property definitions is empty.");
            return this;
        }

        public PropertyDefinitionObject propertyDefinitionIsNotEmpty() {
            Step.STEP((String)String.format("%s Verify that property definitions map is not empty.", CmisWrapper.STEP_PREFIX));
            Assert.assertFalse((boolean)this.type.getPropertyDefinitions().isEmpty(), (String)"Property definitions is not empty.");
            return this;
        }
    }
}

