/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.util.Map;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.Utility;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;

public class CheckIn {
    private CmisWrapper cmisWrapper;
    private boolean version;
    private Map<String, ?> properties;
    private String content;
    private String comment;

    public CheckIn(CmisWrapper cmisWrapper) {
        this.cmisWrapper = cmisWrapper;
    }

    public CheckIn withMajorVersion() {
        this.version = true;
        return this;
    }

    public CheckIn withMinorVersion() {
        this.version = false;
        return this;
    }

    public CheckIn withContent(String content) {
        this.content = content;
        return this;
    }

    public CheckIn withoutComment() {
        this.comment = null;
        return this;
    }

    public CheckIn withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public CmisWrapper checkIn() throws Exception {
        return this.checkIn(this.properties);
    }

    public CmisWrapper checkIn(Map<String, ?> properties) throws Exception {
        ContentStream contentStream = this.cmisWrapper.withCMISUtil().getContentStream(this.content);
        try {
            Document pwc = this.cmisWrapper.withCMISUtil().getPWCDocument();
            pwc.refresh();
            Utility.waitToLoopTime((int)2, (String[])new String[0]);
            pwc.checkIn(this.version, properties, contentStream, this.comment);
        }
        catch (CmisStorageException st) {
            this.cmisWrapper.withCMISUtil().getPWCDocument().checkIn(this.version, properties, contentStream, this.comment);
        }
        return this.cmisWrapper;
    }
}

