/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetFolderTreeTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FolderModel testFolder;
    FolderModel folderModel1;
    FolderModel folderModel11;
    FolderModel folderModel12;
    FolderModel folderModel2;
    DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteContributor, UserRole.SiteConsumer});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomContent() {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.folderModel1 = FolderModel.getRandomFolderModel();
        this.folderModel11 = FolderModel.getRandomFolderModel();
        this.folderModel12 = FolderModel.getRandomFolderModel();
        this.folderModel2 = FolderModel.getRandomFolderModel();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get folder tree for valid parent folder with at least 2 children folders and depth set to 1")
    @Test(groups={"sanity", "cmis"})
    public void getFolderTreeForValidParentFolderWithAtLeast2ChildrenFoldersAndDepthGreaterThan1() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).and()).createFolder(this.folderModel1).and()).createFolder(this.folderModel2).then()).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get folder tree for valid parent folder with at least 2 children folders and depth set to -1")
    @Test(groups={"sanity", "cmis"})
    public void getFolderTreeForValidParentFolderWithAtLeast2ChildrenFoldersAndDepthSetToMinus1() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).and()).createFolder(this.folderModel1).and()).usingResource((ContentModel)this.folderModel1).createFolder(this.folderModel2).then()).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can NOT get folder tree for valid parent folder with at least 2 children folders and depth set to 0")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void getFolderTreeForValidParentFolderWithAtLeast2ChildrenFoldersAndDepthSetTo0() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).and()).createFolder(this.folderModel11).and()).createFolder(this.folderModel12).and()).usingResource((ContentModel)this.folderModel11).createFolder(this.folderModel2).then()).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(0, new ContentModel[]{this.folderModel11});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can NOT get folder tree for valid parent folder with at least 2 children folders and depth set to -2")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisInvalidArgumentException.class})
    public void getFolderTreeForValidParentFolderWithAtLeast2ChildrenFoldersAndDepthSetToMinus2() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).and()).createFolder(this.folderModel11).and()).createFolder(this.folderModel12).and()).usingResource((ContentModel)this.folderModel11).createFolder(this.folderModel2).then()).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-2, new ContentModel[]{this.folderModel11});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can NOT get folder tree for parent folder with children that was previously deleted")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void getFolderTreeForDeletedParentFolderWithChildren() throws Exception {
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo().and()).usingResource((ContentModel)this.testFolder).and()).createFolder(this.folderModel11).and()).createFolder(this.folderModel12).and()).usingResource((ContentModel)this.folderModel11).createFolder(this.folderModel2).and()).usingResource((ContentModel)this.testFolder).deleteFolderTree().then()).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(1, new ContentModel[]{this.folderModel11});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetFolderTreeForValidParentFolder() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"})
    public void siteCollaboratorCanGetFolderTreeForValidParentFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetFolderTreeForValidParentFolder() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"})
    public void siteContributorCanGetFolderTreeForValidParentFolderCreatedByManager() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"})
    public void siteConsumerCanGetFolderTreeForValidParentFolder() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2);
        this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member of a private site cannot get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetFolderTreeForAFolderFromAPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non site member of a moderated site cannot get folder tree for valid parent folder with at least 2 children folders")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonSiteMemberCannotGetFolderTreeForAFolderFromAModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingSite(moderatedSite).createFolder(this.testFolder).usingResource((ContentModel)this.testFolder).createFolder(this.folderModel1).and()).createFolder(this.folderModel2);
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.testFolder).assertThat().hasFolderTree(-1, new ContentModel[]{this.folderModel1, this.folderModel2});
    }
}

