/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dsl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.provider.XMLTestData;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.slf4j.Logger;
import org.testng.Assert;

public class QueryExecutor {
    static Logger LOG = LogFactory.getLogger();
    CmisWrapper cmisWrapper;
    private long resultCount = -1L;
    private String currentQuery = "";
    private List<QueryResult> results;

    public QueryExecutor(CmisWrapper cmisWrapper, String query) {
        this.cmisWrapper = cmisWrapper;
        this.currentQuery = query;
    }

    public QueryResultAssertion assertResultsCount() {
        this.resultCount = this.executeQuery(this.currentQuery).getPageNumItems();
        return new QueryResultAssertion();
    }

    public QueryResultAssertion assertColumnIsOrdered() {
        return this.assertValues();
    }

    public QueryResultAssertion assertColumnValuesRange() {
        return this.assertValues();
    }

    public QueryResultAssertion assertValues() {
        Step.STEP((String)("Sending query " + this.currentQuery));
        this.results = StreamSupport.stream(this.executeQuery(this.currentQuery).spliterator(), false).collect(Collectors.toList());
        this.resultCount = this.results.size();
        Step.STEP((String)("Received results " + String.valueOf(this.results.stream().map(this::resultToString).collect(Collectors.toList()))));
        return new QueryResultAssertion();
    }

    private String resultToString(QueryResult result) {
        if (result == null || result.getProperties() == null) {
            return "null";
        }
        Optional<PropertyData> idProperty = result.getProperties().stream().filter(propertyData -> propertyData.getId().equals("cmis:objectId")).findFirst();
        return idProperty.map(PropertyData::getValues).map(values -> values.stream().map(Object::toString).collect(Collectors.joining(","))).orElse(result.getProperties().toString());
    }

    private ItemIterable<QueryResult> executeQuery(String query) {
        Session session = this.cmisWrapper.getSession();
        Utility.checkObjectIsInitialized((Object)session, (String)"You need to authenticate first using <cmisWrapper.authenticateUser(UserModel userModel)>");
        return session.query(query, false);
    }

    public QueryExecutor applyNodeRefsFrom(XMLTestData testData) {
        List<String> dataItems = this.extractKeywords("NODE_REF");
        if (dataItems.isEmpty()) {
            return this;
        }
        ArrayList<String> nodeRefs = new ArrayList<String>();
        for (String dataItemName : dataItems) {
            this.currentQuery = this.currentQuery.replace(String.format("NODE_REF[%s]", dataItemName), "%s");
            TestModel model = testData.getTestDataItemWithId(dataItemName).getModel();
            if (model == null) {
                throw new TestConfigurationException("No TestData with ID: " + dataItemName + " found in your XML file.");
            }
            if (model instanceof SiteModel) {
                nodeRefs.add(((DataContent)this.cmisWrapper.getDataContentService().usingAdmin().usingSite((SiteModel)model)).getNodeRef());
                continue;
            }
            if (model instanceof FolderModel) {
                nodeRefs.add(((FolderModel)model).getNodeRef());
                continue;
            }
            if (!(model instanceof FileModel)) continue;
            nodeRefs.add(((FileModel)model).getNodeRef());
        }
        try {
            this.currentQuery = String.format(this.currentQuery, nodeRefs.toArray());
            LOG.info("Injecting nodeRef IDs \n\tQuery: [{}]", (Object)this.currentQuery);
        }
        catch (Exception e) {
            throw new TestConfigurationException("You passed multiple keywords to your search query, please re-analyze your query search format: " + e.getMessage());
        }
        return this;
    }

    private List<String> extractKeywords(String key) throws TestConfigurationException {
        String[] lines = this.currentQuery.split(key);
        ArrayList<String> keywords = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String tmp;
            if (!lines[i].startsWith("[")) continue;
            Object keyValue = "";
            for (int j = 1; j < lines[i].length() - 1 && !(tmp = Character.toString(lines[i].charAt(j))).equals("]"); ++j) {
                keyValue = (String)keyValue + tmp;
            }
            keywords.add((String)keyValue);
        }
        return keywords;
    }

    public class QueryResultAssertion {
        public QueryResultAssertion hasLength(long expectedValue) {
            Step.STEP((String)String.format("Verify that query: '%s' has %d results count returned", QueryExecutor.this.currentQuery, expectedValue));
            Assert.assertEquals((long)QueryExecutor.this.resultCount, (long)expectedValue, (String)this.showErrorMessage());
            return this;
        }

        public QueryResultAssertion isGreaterThan(long expectedValue) {
            Step.STEP((String)String.format("Verify that query: '%s' has more than %d results count returned", QueryExecutor.this.currentQuery, expectedValue));
            if (expectedValue <= QueryExecutor.this.resultCount) {
                Assert.fail((String)String.format("%s expected to have more than %d results, but found %d", this.showErrorMessage(), expectedValue, QueryExecutor.this.resultCount));
            }
            return this;
        }

        public QueryResultAssertion isLowerThan(long expectedValue) {
            Step.STEP((String)String.format("Verify that query: '%s' has more than %d results count returned", QueryExecutor.this.currentQuery, expectedValue));
            if (QueryExecutor.this.resultCount >= expectedValue) {
                Assert.fail((String)String.format("%s expected to have less than %d results, but found %d", this.showErrorMessage(), expectedValue, QueryExecutor.this.resultCount));
            }
            return this;
        }

        public QueryResultAssertion isOrderedAsc(String queryName) {
            Step.STEP((String)String.format("Verify that query: '%s' is returning ascending ordered values for column %s", QueryExecutor.this.currentQuery, queryName));
            ArrayList columnValues = new ArrayList();
            QueryExecutor.this.results.forEach(r -> columnValues.add(r.getPropertyValueByQueryName(queryName)));
            List orderedColumnValues = columnValues.stream().sorted().collect(Collectors.toList());
            Assert.assertEquals(columnValues, orderedColumnValues, (String)String.format("%s column values expected to be in ascendent order, but found %s", queryName, ((Object)columnValues).toString()));
            return this;
        }

        public QueryResultAssertion isOrderedDesc(String queryName) {
            Step.STEP((String)String.format("Verify that query: '%s' is returning descending ordered values for column %s", QueryExecutor.this.currentQuery, queryName));
            ArrayList columnValues = new ArrayList();
            QueryExecutor.this.results.forEach(r -> columnValues.add(r.getPropertyValueByQueryName(queryName)));
            List reverseOrderedColumnValues = columnValues.stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
            Assert.assertEquals(columnValues, reverseOrderedColumnValues, (String)String.format("%s column values expected to be in descendent order, but found %s", queryName, ((Object)columnValues).toString()));
            return this;
        }

        public QueryResultAssertion isReturningValuesInRange(String queryName, BigDecimal minValue, BigDecimal maxValue) {
            Step.STEP((String)String.format("Verify that query: '%s' is returning values for column %s in range from %.4f to %.4f", QueryExecutor.this.currentQuery, queryName, minValue, maxValue));
            QueryExecutor.this.results.forEach(r -> {
                BigDecimal value = (BigDecimal)r.getPropertyValueByQueryName(queryName);
                if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
                    Assert.fail((String)String.format("%s column values expected to be in range from %.4f to %.4f, but found %.4f", queryName, minValue, maxValue, value));
                }
            });
            return this;
        }

        public <T> QueryResultAssertion isReturningValues(String queryName, Set<T> values) {
            return this.isReturningValues(queryName, values, false);
        }

        public <T> QueryResultAssertion isReturningValues(String queryName, Set<T> values, boolean multivalue) {
            Step.STEP((String)String.format("Verify that query: '%s' returns the values from %s for column %s", QueryExecutor.this.currentQuery, values, queryName));
            Function<QueryResult, Object> extractValue = multivalue ? r -> r.getPropertyMultivalueById(queryName) : r -> r.getPropertyValueById(queryName);
            Set resultSet = QueryExecutor.this.results.stream().map(extractValue).collect(Collectors.toSet());
            Assert.assertEquals(resultSet, values, (String)("Values did not match - expected " + String.valueOf(values) + " got " + String.valueOf(resultSet)));
            return this;
        }

        public <T> QueryResultAssertion isReturningOrderedValues(String queryName, List<T> values) {
            return this.isReturningOrderedValues(queryName, values, false);
        }

        public <T> QueryResultAssertion isReturningOrderedValues(String queryName, List<T> values, boolean multivalue) {
            Step.STEP((String)String.format("Verify that query: '%s' returns the values from %s for column %s", QueryExecutor.this.currentQuery, values, queryName));
            Function<QueryResult, Object> extractValue = multivalue ? r -> r.getPropertyMultivalueById(queryName) : r -> r.getPropertyValueById(queryName);
            List resultList = QueryExecutor.this.results.stream().map(extractValue).collect(Collectors.toList());
            Assert.assertEquals(resultList, values, (String)("Values did not match expected " + String.valueOf(values) + " but found " + String.valueOf(resultList)));
            return this;
        }

        private String showErrorMessage() {
            return String.format("Returned results count of Query [%s] is not the expected one:", QueryExecutor.this.currentQuery);
        }
    }
}

