/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"regression", "cmis", "renditions"})
public class RenditionTests
extends CmisTest {
    private SiteModel testSite;
    private UserModel testUser;
    private UserModel inexistentUser;
    private UserModel nonInvitedUser;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.inexistentUser = new UserModel("inexistent", "inexistent");
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get renditions for valid Document object")
    public void adminShouldGetRenditionsForDocument() throws Exception {
        FileModel txtModel = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingShared().createFile(txtModel);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.usingResource((ContentModel)txtModel).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"}, expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get renditions for invalid Document object")
    public void adminCannotGetRenditionsForInvalidDocument() throws Exception {
        FileModel invalidFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        invalidFile.setCmisLocation("/" + invalidFile.getName() + "/");
        ((CmisWrapper)this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingShared().then()).usingResource((ContentModel)invalidFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable();
    }

    @Test(groups={"sanity", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager can get renditions for valid Document")
    public void managerGetRenditionsForDocument() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator can get renditions for valid Document")
    public void collaboratorGetRenditionsForDocument() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor can get renditions for valid Document")
    public void contributorGetRenditionsForDocument() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer can get renditions for valid Document")
    public void consumerGetRenditionsForDocument() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can get renditions for checked out document")
    public void managerGetRenditionsForCheckedOutDocument() throws Exception {
        FileModel checkedDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(checkedDoc, VersioningState.CHECKEDOUT).assertThat().documentIsCheckedOut();
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.usingResource((ContentModel)checkedDoc).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user can get renditions in public site")
    public void nonInvitedUserGetRenditionsInPublicSite() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        Utility.sleep((int)300, (int)10000, () -> this.cmisApi.authenticateUser(this.nonInvitedUser).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable());
    }

    @Test(groups={"regression", "cmis", "renditions"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user cannot get renditions in private site")
    public void nonInvitedUserCannotGetRenditionsInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(privateDoc).assertThat().existsInRepo().authenticateUser(this.nonInvitedUser).usingResource((ContentModel)privateDoc).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable();
    }

    @Test(groups={"regression", "cmis", "renditions"}, expectedExceptions={CmisPermissionDeniedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user cannot get renditions in moderated site")
    public void nonInvitedUserCannotGetRenditionsInModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        FileModel moderatedDoc = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFile(moderatedDoc).assertThat().existsInRepo().authenticateUser(this.nonInvitedUser).usingResource((ContentModel)moderatedDoc).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable();
    }

    @Test(groups={"regression", "cmis", "renditions"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user cannot get renditions")
    public void inexistentUserCannotGetRenditions() throws Exception {
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.documentContent);
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(testFile);
        this.cmisApi.authenticateUser(this.inexistentUser).usingResource((ContentModel)testFile).assertThat().renditionIsAvailable().assertThat().thumbnailRenditionIsAvailable();
    }
}

