/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.HashMap;
import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdatePropertiesTests
extends CmisTest {
    UserModel testUser;
    SiteModel testSite;
    FileModel testFile;
    FolderModel testFolder;
    String propertyNameValue;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.dataContent.deployContentModel("shared-resources/model/tas-model.xml");
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to update properties to a valid document in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerUpdatesFileProperties() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to update properties to a valid folder in DocumentLibrary with CMIS")
    @Test(groups={"sanity", "cmis"})
    public void siteManagerUpdatesFolderProperties() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify if exception is thrown when user tries to update properties to a non existent document in DocumentLibrary with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerUpdatesNoneExistentFileProperties() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).delete().and()).assertThat().doesNotExistInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update properties with invalid property with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class})
    public void siteManagerCannotUpdateFileWithInvalidProperty() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:fakeProp", (Object)this.propertyNameValue);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that deleted user is not able to update properties with CMIS")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void deletedUserCannotUpdateFileProperties() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        UserModel toBeDeleted = this.dataUser.createRandomTestUser();
        FolderModel shared = FolderModel.getSharedFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(toBeDeleted).usingResource((ContentModel)shared).createFile(this.testFile).and()).assertThat().existsInRepo();
        this.dataUser.deleteUser(toBeDeleted);
        Thread.sleep(120000L);
        this.cmisApi.updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update name property while document is checked out with CMIS")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCannotUpdatePWCDocumentName() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().usingPWCDocument().updateProperty("cmis:name", (Object)(this.testFile.getName() + "-edit")).cancelCheckOut().then()).usingResource((ContentModel)this.testFile).assertThat().contentPropertyHasValue("cmis:name", this.testFile.getName());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to update the title and description while document is checked out with CMIS")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void siteManagerCanUpdateCheckOutDocTitleAndDescription() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().then()).usingPWCDocument().updateProperty("cmis:description", (Object)this.propertyNameValue).updateProperty("cm:title", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:description", this.propertyNameValue).assertThat().contentPropertyHasValue("cm:title", this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to update the title and description for document with version is checked out with CMIS")
    @Test(groups={"regression", "cmis", "not_supported_on_cmis_ws"})
    public void siteManagerCanUpdateDocumentWithVersion() throws Exception {
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).update("first content").then()).update("second content").updateProperty("cmis:description", (Object)this.propertyNameValue).updateProperty("cm:title", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:description", this.propertyNameValue).assertThat().contentPropertyHasValue("cm:title", this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update document name with invalid symbols")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotUpdateDocNameInvalidSymbols() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = "/.:?|\\`\\";
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update folder name with invalid symbols")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConstraintException.class})
    public void siteManagerCannotUpdateFolderNameInvalidSymbols() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        this.propertyNameValue = "/.:?|\\`\\";
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update document name with empty value")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisRuntimeException.class}, expectedExceptionsMessageRegExp="Local name cannot be null or empty.")
    public void siteManagerCannotUpdateDocNameEmptyValue() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)"");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update folder name with empty value")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisRuntimeException.class}, expectedExceptionsMessageRegExp="Local name cannot be null or empty.")
    public void siteManagerCannotUpdateFolderNameEmptyValue() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)"");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to update Integer and Long types with max values")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanUpdateIntAndLongTypesWithMaxValue() throws Exception {
        FileModel customFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"custom content");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "D:tas:document");
        properties.put("cmis:name", customFile.getName());
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(customFile, properties, VersioningState.MAJOR).assertThat().existsInRepo().then()).updateProperty("tas:IntPropertyC", (Object)Integer.MAX_VALUE).and()).assertThat().contentPropertyHasValue("tas:IntPropertyC", String.valueOf(Integer.MAX_VALUE)).then()).updateProperty("tas:LongPropertyC", (Object)Long.MAX_VALUE).and()).assertThat().contentPropertyHasValue("tas:LongPropertyC", String.valueOf(Long.MAX_VALUE));
        this.cmisApi.usingResource((ContentModel)customFile).delete().assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to update Integer and Long types with min values")
    @Test(groups={"regression", "cmis"})
    public void siteManagerCanUpdateIntAndLongTypesWithMinValue() throws Exception {
        FileModel customFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"custom content");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "D:tas:document");
        properties.put("cmis:name", customFile.getName());
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(customFile, properties, VersioningState.MAJOR).assertThat().existsInRepo().then()).updateProperty("tas:IntPropertyC", (Object)Integer.MIN_VALUE).and()).assertThat().contentPropertyHasValue("tas:IntPropertyC", String.valueOf(Integer.MIN_VALUE)).then()).updateProperty("tas:LongPropertyC", (Object)Long.MIN_VALUE).and()).assertThat().contentPropertyHasValue("tas:LongPropertyC", String.valueOf(Long.MIN_VALUE));
        this.cmisApi.usingResource((ContentModel)customFile).delete().assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to update properties to a valid document created by himself")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanUpdateHisOwnFileProperties() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to update properties to a valid document created by site manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanUpdateFilePropertiesCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to update properties to a valid document created by himself")
    @Test(groups={"regression", "cmis"})
    public void contributorCanUpdateHisOwnFileProperties() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to update properties to a valid document created by site manager")
    @Test(groups={"regression", "cmis"})
    public void contributorCanUpdateFilePropertiesCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).updateProperty("cmis:name", (Object)this.propertyNameValue).and()).assertThat().contentPropertyHasValue("cmis:name", this.propertyNameValue).then()).updateProperty("cmis:description", (Object)"some description").and()).assertThat().contentPropertyHasValue("cmis:description", "some description");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to update properties to a valid document created by site manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void consumerCannotUpdateFilePropertiesCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).and()).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify disabled user is not able to update properties")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    public void disabledUserCannotUpdateFileProperties() throws Exception {
        UserModel disabledUser = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        this.cmisApi.authenticateUser(disabledUser).usingShared().createFile(this.testFile).assertThat().existsInRepo();
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabledUser);
        this.cmisApi.usingResource((ContentModel)this.testFile).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify non invited user is not able to update properties to a document created by site manager")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotUpdateFilePropertiesCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        UserModel nonInvitedUser = this.dataUser.createRandomTestUser();
        this.propertyNameValue = RandomData.getRandomAlphanumeric();
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo().then()).authenticateUser(nonInvitedUser).and()).updateProperty("cmis:name", (Object)this.propertyNameValue);
    }
}

