/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.distribution;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CheckDistributionZipContents {
    public static final String ACS_PREFIX = "alfresco-content-services-community-distribution";
    public static final String ACS_DIR_NAME = "distribution";
    public static final String AGS_PREFIX = "alfresco-governance-services-community";
    public static final String AGS_DIR_NAME = "distribution-ags";
    public static final String FORMAT = ".zip";

    @Test
    public void testAcsDistributionZipContents() throws Exception {
        File[] filesList;
        for (File file : filesList = this.getDistributionZip(ACS_DIR_NAME, ACS_PREFIX)) {
            List<String> zipEntries = this.getZipEntries(file.getAbsolutePath());
            Assertions.assertThat(zipEntries).contains((Object[])new String[]{"keystore/metadata-keystore/keystore-passwords.properties", "keystore/metadata-keystore/keystore", "bin/alfresco-mmt.jar", "bin/apply_amps.bat", "bin/apply_amps.sh", "web-server/webapps/ROOT.war", "web-server/webapps/alfresco.war", "web-server/webapps/share.war", "web-server/webapps/_vti_bin.war", "web-server/conf/Catalina/localhost/alfresco.xml", "web-server/shared/classes/alfresco/web-extension/share-config-custom.xml"});
        }
    }

    @Test
    public void testAgsDistributionZipContents() throws Exception {
        File[] filesList;
        String repoVersion = this.getPomValues().getProperties().getProperty("dependency.alfresco-community-repo.version");
        String shareVersion = this.getPomValues().getProperties().getProperty("dependency.alfresco-community-share.version");
        for (File file : filesList = this.getDistributionZip(AGS_DIR_NAME, AGS_PREFIX)) {
            List<String> zipEntries = this.getZipEntries(file.getAbsolutePath());
            Assertions.assertThat(zipEntries).contains((Object[])new String[]{"alfresco-governance-services-community-repo-" + repoVersion + ".amp", "alfresco-governance-services-community-rest-api-explorer-" + repoVersion + ".war", "alfresco-governance-services-community-share-" + shareVersion + ".amp"});
        }
    }

    private File[] getDistributionZip(String dirName, String prefix) throws Exception {
        String resourcePath = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent().toString() + "/" + dirName + "/target/";
        File distributionZip = new File(resourcePath);
        FilenameFilter zipFileFilter = (dir, name) -> name.startsWith(prefix) && name.endsWith(FORMAT);
        return distributionZip.listFiles(zipFileFilter);
    }

    private List<String> getZipEntries(String filePath) throws Exception {
        ArrayList<String> zipEntries = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(new File(filePath));
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            zipEntries.add(entry.toString());
        }
        return zipEntries;
    }

    private Model getPomValues() throws Exception {
        String parentPom = Paths.get("", new String[0]).toAbsolutePath().getParent().getParent().toString() + "/pom.xml";
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((Reader)new FileReader(parentPom));
        return model;
    }
}

