/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import java.util.Collections;
import java.util.List;
import javax.json.Json;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryLinkBodyModel;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LinkToCategoriesTests
extends CategoriesRestTest {
    private static final String ASPECTS_FIELD = "aspectNames";
    private static final String PROPERTIES_FIELD = "properties";
    private SiteModel site;
    private FolderModel folder;
    private FileModel file;
    private RestCategoryModel category;

    @Override
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create user and a site");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Step.STEP((String)"Create a folder, file in it and a category under root");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        this.file = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.folder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.category = this.prepareCategoryUnderRoot();
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory() {
        Step.STEP((String)"Check if file is not linked to any category");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).notContains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains("cm:categories");
        Step.STEP((String)"Link content to created category and expect 201");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategory.assertThat().isEqualTo((Object)this.category, new String[0]);
        Step.STEP((String)"Verify if category is present in file metadata");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).contains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(this.category.getId());
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToMultipleCategories() {
        Step.STEP((String)"Check if file is not linked to any category");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).notContains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains("cm:categories");
        Step.STEP((String)"Create second category under root");
        RestCategoryModel secondCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Link content to created categories and expect 201");
        List<RestCategoryLinkBodyModel> categoryLinkModels = List.of(this.createCategoryLinkModelWithId(this.category.getId()), this.createCategoryLinkModelWithId(secondCategory.getId()));
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinkModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)this.category, new String[0]);
        ((RestCategoryModel)linkedCategories.getEntries().get(1)).onModel().assertThat().isEqualTo((Object)secondCategory, new String[0]);
        Step.STEP((String)"Verify if both categories are present in file metadata");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).contains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(secondCategory.getId());
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_withRepeatedCategory() {
        Step.STEP((String)"Check if file is not linked to any category");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).notContains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains("cm:categories");
        Step.STEP((String)"Link content to three (one repeated) categories and expect 201");
        RestCategoryModel secondCategory = this.prepareCategoryUnderRoot();
        List<RestCategoryLinkBodyModel> categoryLinkModels = List.of(this.createCategoryLinkModelWithId(this.category.getId()), this.createCategoryLinkModelWithId(secondCategory.getId()), this.createCategoryLinkModelWithId(this.category.getId()));
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinkModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategories.assertThat().entriesListCountIs(2);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)this.category, new String[0]);
        ((RestCategoryModel)linkedCategories.getEntries().get(1)).onModel().assertThat().isEqualTo((Object)secondCategory, new String[0]);
        Step.STEP((String)"Verify if repeated category was ignored and only two categories are present in file metadata");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(PROPERTIES_FIELD).containsOnce(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).containsOnce(secondCategory.getId());
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingAlreadyLinkedCategory() {
        Step.STEP((String)"Create second category under root");
        RestCategoryModel secondCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Link file to one category");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(PROPERTIES_FIELD).containsOnce(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains(secondCategory.getId());
        Step.STEP((String)"Link content to two categories using one already linked before to and expect 201");
        List<RestCategoryLinkBodyModel> categoryLinkModels = List.of(this.createCategoryLinkModelWithId(this.category.getId()), this.createCategoryLinkModelWithId(secondCategory.getId()));
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinkModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategories.assertThat().entriesListCountIs(2);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)this.category, new String[0]);
        ((RestCategoryModel)linkedCategories.getEntries().get(1)).onModel().assertThat().isEqualTo((Object)secondCategory, new String[0]);
        Step.STEP((String)"Verify if repeated category was ignored and only two categories are present in file metadata");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(PROPERTIES_FIELD).containsOnce(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).containsOnce(secondCategory.getId());
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingContentWithAlreadyLinkedCategories() {
        Step.STEP((String)"Link content to created category");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Create second and third category under root, link content to them and expect 201");
        RestCategoryModel secondCategory = this.prepareCategoryUnderRoot();
        RestCategoryModel thirdCategory = this.prepareCategoryUnderRoot();
        List<RestCategoryLinkBodyModel> categoryLinkModels = List.of(this.createCategoryLinkModelWithId(secondCategory.getId()), this.createCategoryLinkModelWithId(thirdCategory.getId()));
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinkModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategories.assertThat().entriesListCountIs(2);
        ((RestCategoryModel)linkedCategories.getEntries().get(0)).onModel().assertThat().isEqualTo((Object)secondCategory, new String[0]);
        ((RestCategoryModel)linkedCategories.getEntries().get(1)).onModel().assertThat().isEqualTo((Object)thirdCategory, new String[0]);
        Step.STEP((String)"Verify if all three categories are present in file metadata");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(PROPERTIES_FIELD).contains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(secondCategory.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(thirdCategory.getId());
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_asUserWithoutReadPermissionAndExpect403() {
        Step.STEP((String)"Try to link content to a category using user without read permission and expect 403");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        UserModel userWithoutRights = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithoutRights).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_asUserWithoutChangePermissionAndExpect403() {
        Step.STEP((String)"Create another user as a consumer for file");
        UserModel consumer = this.dataUser.createRandomTestUser();
        this.allowPermissionsForUser(consumer.getUsername(), "Consumer", this.file);
        Step.STEP((String)"Try to link content to a category using user without change permission and expect 403");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(consumer).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_asOwner() {
        Step.STEP((String)"Use admin to create a private site");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        Step.STEP((String)"Add the user to the site, let him create a folder and then evict him from the site again");
        this.dataUser.addUserToSite(this.user, privateSite, UserRole.SiteManager);
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(privateSite)).createFolder();
        FileModel privateFile = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)privateFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.dataUser.removeUserFromSite(this.user, privateSite);
        Step.STEP((String)"Try to link content to a category as owner and expect 201");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)privateFile).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingNonExistingCategoryAndExpect404() {
        Step.STEP((String)"Try to link content to non-existing category and expect 404");
        String nonExistingCategoryId = "non-existing-dummy-id";
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId("non-existing-dummy-id");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_passingEmptyListAndExpect400() {
        Step.STEP((String)"Try to call link content API with empty list and expect 400");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(Collections.emptyList());
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_passingEmptyIdAndExpect400() {
        Step.STEP((String)"Try to call link content API with empty category ID and expect 400");
        String nonExistingCategoryId = "";
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId("");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testLinkFolderToCategory() {
        Step.STEP((String)"Link folder node to category");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.folder).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingTagInsteadOfContentAndExpect422() {
        Step.STEP((String)"Add tag to file");
        RestTagModel tag = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).addTag("someTag");
        RepoTestModel tagNode = this.createNodeModelWithId(tag.getId());
        Step.STEP((String)"Try to link a tag to category and expect 422");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.category.getId());
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode(tagNode).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingFolderInsteadOfCategoryAndExpect400() {
        Step.STEP((String)"Try to link content to non-category and expect 400");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId(this.folder.getNodeRef());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testLinkContentToCategory_usingRootCategoryAndExpect400() {
        Step.STEP((String)"Try to link content to root category and expect 400");
        RestCategoryLinkBodyModel categoryLinkModel = this.createCategoryLinkModelWithId("-root-");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLinkModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testUnlinkContentFromCategory() {
        Step.STEP((String)"Link content to created category and expect 201");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLink);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategory.assertThat().isEqualTo((Object)this.category, new String[0]);
        Step.STEP((String)"Verify that category is present in file metadata");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).contains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(this.category.getId());
        Step.STEP((String)"Unlink content from created category and expect 204");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).unlinkFromCategory(this.category.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"Verify that category isn't present in file metadata");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).notContains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains(this.category.getId());
    }

    @Test(groups={"rest-api"})
    public void testUnlinkContentFromCategory_multipleLinkedCategories() {
        Step.STEP((String)"Create second category under root");
        RestCategoryModel secondCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Link content to created categories and expect 201");
        List<RestCategoryLinkBodyModel> categoryLinks = List.of(this.createCategoryLinkModelWithId(this.category.getId()), this.createCategoryLinkModelWithId(secondCategory.getId()));
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategories(categoryLinks);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Unlink content from first category and expect 204");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).unlinkFromCategory(this.category.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"Verify that second category is still present in file metadata");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).getNode();
        fileNode.assertThat().field(ASPECTS_FIELD).contains("cm:generalclassifiable");
        fileNode.assertThat().field(PROPERTIES_FIELD).contains("cm:categories");
        fileNode.assertThat().field(PROPERTIES_FIELD).notContains(this.category.getId());
        fileNode.assertThat().field(PROPERTIES_FIELD).contains(secondCategory.getId());
    }

    @Test(groups={"rest-api"})
    public void testUnlinkContentFromCategory_asUserWithoutChangePermissionAndGet403() {
        Step.STEP((String)"Link content to created category and expect 201");
        RestCategoryLinkBodyModel categoryLink = this.createCategoryLinkModelWithId(this.category.getId());
        RestCategoryModel linkedCategory = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).linkToCategory(categoryLink);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        linkedCategory.assertThat().isEqualTo((Object)this.category, new String[0]);
        Step.STEP((String)"Create another user as a consumer for file");
        UserModel consumer = this.dataUser.createRandomTestUser();
        this.allowPermissionsForUser(consumer.getUsername(), "Consumer", this.file);
        Step.STEP((String)"Try to unlink content to a category using user without change permission and expect 403");
        this.restClient.authenticateUser(consumer).withCoreAPI().usingNode((RepoTestModel)this.file).unlinkFromCategory(this.category.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api"})
    public void testUnlinkContentFromCategory_unlinkFromNonLinkedToNodeCategory() {
        Step.STEP((String)"Try to unlink content from a category that the node isn't assigned to");
        RestCategoryModel nonLinkedToNodeCategory = this.createCategoryModelWithId("non-linked-category-dummy-id");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).unlinkFromCategory(nonLinkedToNodeCategory.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testUnlinkContentFromCategory_usingNonExistingCategoryAndExpect404() {
        Step.STEP((String)"Try to unlink content from non-existent category and expect 404");
        String nonExistentCategoryId = "non-existent-dummy-id";
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).unlinkFromCategory("non-existent-dummy-id");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    private void allowPermissionsForUser(String username, String role, FileModel file) {
        String putPermissionsBody = Json.createObjectBuilder().add("permissions", Json.createObjectBuilder().add("isInheritanceEnabled", true).add("locallySet", Json.createObjectBuilder().add("authorityId", username).add("name", role).add("accessStatus", "ALLOWED"))).build().toString();
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)file).updateNode(putPermissionsBody);
    }
}

