/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.downloads;

import javax.json.JsonObject;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.model.RestDownloadsModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DownloadsTests
extends RestTest {
    private UserModel adminModel;
    private FileModel document;
    private FileModel document1;
    private FolderModel folder;
    private SiteModel siteModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminModel = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminModel)).createPrivateRandomSite();
        this.folder = ((DataContent)this.dataContent.usingUser(this.adminModel).usingSite(this.siteModel)).createFolder();
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel newFile = FileModel.getFileModelBasedOnTestDataFile((String)"larger.pdf");
        newFile.setName("larger.pdf");
        this.document1 = ((DataContent)this.dataContent.usingUser(this.adminModel).usingResource((ContentModel)this.folder)).createContent(newFile);
    }

    @Test(groups={"rest-api", "downloads", "sanity"})
    @TestRail(section={"rest-api", "downloads"}, executionType={ExecutionType.SANITY}, description="Sanity tests for GET /downloads/{downloadId} and POST /downloads")
    public void createDownloadNodeAndGetInfo() throws Exception {
        JsonObject postBody = JsonBodyGenerator.defineJSON().add("nodeIds", JsonBodyGenerator.defineJSONArray().add(this.document.getNodeRefWithoutVersion())).build();
        RestDownloadsModel downloadModel = this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingDownloads().createDownload(postBody.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        ((RestDownloadsModel)downloadModel.assertThat().fieldsCount().is((Object)6)).and().field("id").isNotEmpty();
        Utility.sleep((int)500, (int)15000, () -> {
            RestDownloadsModel downloadModel1 = this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingDownloads(downloadModel).getDownload();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestDownloadsModel)((RestDownloadsModel)((RestDownloadsModel)((RestDownloadsModel)((RestDownloadsModel)((RestDownloadsModel)downloadModel1.assertThat().fieldsCount().is((Object)6)).and().field("id").is((Object)downloadModel.getId())).and().field("filesAdded").isGreaterThan(Integer.valueOf(0))).and().field("bytesAdded").isGreaterThan(Integer.valueOf(0))).and().field("totalBytes").isGreaterThan(Integer.valueOf(0))).and().field("totalFiles").isGreaterThan(Integer.valueOf(0))).and().field("status").is((Object)"DONE");
        });
        this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingNode().getNodeContent(downloadModel.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Type", "application/octet-stream;charset=UTF-8");
        this.restClient.assertHeaderValueContains("Content-disposition", ".zip");
        Assert.assertTrue((this.restClient.onResponse().getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0);
    }

    @Test(groups={"rest-api", "downloads", "sanity"})
    @TestRail(section={"rest-api", "downloads"}, executionType={ExecutionType.SANITY}, description="Sanity tests for DELETE /downloads/{downloadId}")
    public void cancelDownloadNode() throws Exception {
        String postBody = JsonBodyGenerator.defineJSON().add("nodeIds", JsonBodyGenerator.defineJSONArray().add(this.document1.getNodeRefWithoutVersion())).build().toString();
        RestDownloadsModel downloadModel = this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingDownloads().createDownload(postBody);
        this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingDownloads(downloadModel).cancelDownload();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Utility.sleep((int)500, (int)10000, () -> {
            RestDownloadsModel downloadModel1 = this.restClient.authenticateUser(this.adminModel).withCoreAPI().usingDownloads(downloadModel).getDownload();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            downloadModel1.assertThat().field("status").is((Object)"CANCELLED");
        });
    }
}

