/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import io.restassured.http.Headers;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.json.Json;
import javax.json.JsonObject;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestVersionModel;
import org.alfresco.rest.model.RestVersionModelsCollection;
import org.alfresco.rest.model.body.RestNodeLockBodyModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NodesContentAndVersioningTests
extends RestTest {
    private UserModel user1;
    private UserModel user2;
    private SiteModel site1;
    private SiteModel site2;
    private FileModel file1;
    private FileModel file2;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        this.user1 = this.dataUser.createRandomTestUser();
        this.user2 = this.dataUser.createRandomTestUser();
        this.site1 = ((DataSite)this.dataSite.usingUser(this.user1)).createPublicRandomSite();
        this.site2 = ((DataSite)this.dataSite.usingUser(this.user2)).createPublicRandomSite();
        this.file1 = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.file2 = ((DataContent)this.dataContent.usingUser(this.user2).usingSite(this.site2)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify file name in Content-Disposition header")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkFileNameWithRegularCharsInHeader() {
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"attachment=false"})).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Disposition", String.format("filename=\"%s\"", this.file1.getName()));
    }

    @Bug(id="MNT-17545", description="HTTP Header Injection in ContentStreamer", status=Bug.Status.FIXED)
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify file name with special chars is escaped in Content-Disposition header")
    @Test(groups={"rest-api", "nodes", "regression"})
    public void checkFileNameWithSpecialCharsInHeader() {
        char c1 = '\u007f';
        char c2 = '\u001f';
        char c3 = '\u0100';
        FileModel file = ((DataContent)this.dataContent.usingUser(this.user2).usingSite(this.site2)).createContent(new FileModel("\ntest" + c1 + c2 + c3, FileType.TEXT_PLAIN));
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)file).usingParams(new String[]{"attachment=false"})).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Disposition", "filename=\" test   \"");
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify that alfresco returns the correct encoding for files created via REST.")
    public void verifyFileEncodingUsingRestAPI() {
        Step.STEP((String)"1. Create a folder, two text file templates and define the expected encoding.");
        FileModel utf8File = new FileModel("utf8File", FileType.TEXT_PLAIN);
        FileModel iso8859File = new FileModel("iso8859File", FileType.TEXT_PLAIN);
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Using multipart data upload (POST nodes/{nodeId}/children) the UTF-8 encoded file.");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"UTF-8File.txt"));
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        utf8File.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Using multipart data upload (POST nodes/{nodeId}/children) the ISO-8859-1 file.");
        this.restClient.configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"iso8859File.txt"));
        fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        iso8859File.setNodeRef(fileNode.getId());
        Step.STEP((String)"4. Retrieve the nodes and verify that the content type is the expected one (GET nodes/{nodeId}).");
        String utf8Type = "text/plain;charset=UTF-8";
        String iso8859Type = "text/plain;charset=ISO-8859-1";
        this.restClient.withCoreAPI().usingNode((RepoTestModel)utf8File).getNodeContent().assertThat().contentType(utf8Type);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)iso8859File).getNodeContent().assertThat().contentType(iso8859Type);
    }

    @Test(enabled=false, groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify that the node content is streamed directly to the client and not buffered in memory.")
    public void verifyUploadDownloadLargeFileUsingRestAPI() {
        Integer largeFileSizeBytes = Integer.MAX_VALUE;
        String largeFileName = "largeFile.tmp";
        String tempFolderPath = NodesContentAndVersioningTests.getSystemTempDir().getAbsolutePath();
        Step.STEP((String)"1. Create a folder and a large file");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        this.createRandomFileInDirectory(tempFolderPath, largeFileName, largeFileSizeBytes);
        Step.STEP((String)"2. Using multipart data upload for the large file (POST nodes/{nodeId}/children).");
        File largeFile = new File(tempFolderPath, largeFileName);
        FileModel largeFileModel = new FileModel(largeFileName, FileType.UNDEFINED);
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", largeFile);
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        largeFileModel.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Retrieve the content of the node without running out of memory (GET nodes/{nodeId}/content).");
        RestResponse nodeContent = this.restClient.withCoreAPI().usingNode((RepoTestModel)largeFileModel).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((Object)Integer.valueOf(nodeContent.getResponse().getHeader("Content-Length")), (Object)largeFileSizeBytes);
        largeFile.delete();
    }

    public static File getSystemTempDir() {
        String systemTempDirPath = System.getProperty("java.io.tmpdir");
        if (systemTempDirPath == null) {
            throw new RuntimeException("System property not available: java.io.tmpdir");
        }
        File systemTempDir = new File(systemTempDirPath);
        return systemTempDir;
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify updating a node content.")
    public void testUpdateNodeContent() {
        Step.STEP((String)"1. Retrieve the node in order to get data to compare after update GET /nodes/{nodeId}?include=path.");
        RestNodeModel initialNode = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=path"})).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"2. Update the node content (different from the initial one) PUT /nodes/{nodeId}/content?majorVersion=true&name=newfile.txt.");
        File updatedConentFile = Utility.getResourceTestDataFile((String)"sampleContent.txt");
        RestNodeModel updatedBodyNode = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"majorVersion=true&name=newfile.txt"})).updateNodeContent(updatedConentFile);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"3. Compare contentSize, modifiedAt, name and version, they should be different.");
        Assert.assertNotSame((Object)initialNode.getContent().getSizeInBytes(), (Object)updatedBodyNode.getContent().getSizeInBytes());
        Assert.assertNotSame((Object)initialNode.getModifiedAt(), (Object)updatedBodyNode.getModifiedAt());
        Assert.assertNotSame((Object)initialNode.getName(), (Object)updatedBodyNode.getName());
        String initialNodeVersion = new JSONObject(initialNode.toJson()).getJSONObject("properties").getString("cm:versionLabel");
        String updatedBodyNodeVersion = new JSONObject(updatedBodyNode.toJson()).getJSONObject("properties").getString("cm:versionLabel");
        Assert.assertTrue((updatedBodyNodeVersion.charAt(0) > initialNodeVersion.charAt(0) ? 1 : 0) != 0);
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Test copy a node.")
    public void testCopyNode() {
        Step.STEP((String)"1. Create a lock and lock the node POST /nodes/{nodeId}/lock?include=path,isLocked.");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("FULL");
        RestNodeModel initialNode = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=path,isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"2. With another user(that has access to the file), copy the node to another path POST /nodes/{nodeId}/copy?include=path,isLocked.");
        String postBody = JsonBodyGenerator.keyValueJson((String)"targetParentId", (String)this.site2.getGuid());
        RestNodeModel copiedNode = ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=path,isLocked"})).copyNode(postBody);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"3. ParentId, createdAt, path and lock are different, but the nodes have the same contentSize.");
        Assert.assertNotSame((Object)copiedNode.getParentId(), (Object)initialNode.getParentId());
        Assert.assertNotSame((Object)copiedNode.getCreatedAt(), (Object)initialNode.getCreatedAt());
        Assert.assertNotSame((Object)copiedNode.getPath(), (Object)initialNode.getPath());
        Assert.assertTrue((boolean)initialNode.getIsLocked());
        Assert.assertSame((Object)copiedNode.getContent().getSizeInBytes(), (Object)initialNode.getContent().getSizeInBytes());
        Assert.assertFalse((boolean)copiedNode.getIsLocked());
        Step.STEP((String)"4. Unlock the node (this node may be used in the next tests).");
        initialNode = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertFalse((boolean)initialNode.getIsLocked());
    }

    @Bug(id="REPO-4050")
    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Test retrieving node versions, a specific version and version content.")
    public void testGetVersionContent() throws Exception {
        this.file2 = ((DataContent)this.dataContent.usingUser(this.user2).usingSite(this.site2)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        File sampleFile = Utility.getResourceTestDataFile((String)"sampleContent.txt");
        Step.STEP((String)"1. Update the node content in order to increase version(one minor and one major) PUT /nodes/{nodeId}/content.");
        this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file2).updateNodeContent(sampleFile);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestCoreAPI)this.restClient.authenticateUser(this.user2).withCoreAPI().usingParams(new String[]{"majorVersion=true"})).usingNode((RepoTestModel)this.file2).updateNodeContent(sampleFile);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"2. List node version history GET /nodes/{nodeId}/versions. And verify that first (in the list) version is 2.0 and last is 1.0.");
        RestVersionModelsCollection versionListing = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).listVersionHistory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertEquals((String)((RestVersionModel)versionListing.getEntries().get(versionListing.getPagination().getCount() - 1)).onModel().getId(), (String)"1.0");
        Assert.assertEquals((String)((RestVersionModel)versionListing.getEntries().get(0)).onModel().getId(), (String)"2.0");
        Assert.assertNull((Object)((RestVersionModel)versionListing.getEntries().get(0)).onModel().getProperties());
        Step.STEP((String)"3. List node version using skipCount(1),maxItems(1) and include(properties) GET /nodes/{nodeId}/versions?include=properties&skipCount=1&maxItems=1");
        versionListing = ((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"include=properties&skipCount=1&maxItems=1"})).usingNode((RepoTestModel)this.file2).listVersionHistory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestVersionModel version = ((RestVersionModel)versionListing.getEntries().get(0)).onModel();
        Assert.assertNotNull((Object)version.getProperties());
        Assert.assertEquals((String)version.getId(), (String)"1.1");
        Assert.assertEquals((int)versionListing.getPagination().getMaxItems(), (int)1);
        Assert.assertEquals((int)versionListing.getPagination().getSkipCount(), (int)1);
        Assert.assertEquals((int)versionListing.getPagination().getCount(), (int)1);
        Step.STEP((String)"4. Get version information for version 1.1 GET /nodes/{nodeId}/versions/{versionId} .");
        RestVersionModel version11 = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).getVersionInformation("1.1");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertNotNull((Object)version11.getAspectNames());
        Assert.assertNotNull((Object)version11.getProperties());
        Assert.assertEquals((String)version.getId(), (String)version11.getId());
        Assert.assertEquals((int)version.getContent().getSizeInBytes(), (int)version11.getContent().getSizeInBytes());
        Assert.assertEquals((String)version.getName(), (String)version11.getName());
        Step.STEP((String)"5. Retrieve version 2.0 content GET /nodes/{nodeId}/versions/{versionId}/content");
        Utility.sleep((int)500, (int)60000, () -> {
            RestResponse versionContent = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).getVersionContent("2.0");
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            Assert.assertEquals((String)"Sample text.", (String)versionContent.getResponse().body().asString());
            this.restClient.assertHeaderValueContains("Content-Disposition", "attachment");
            this.restClient.assertHeaderValueContains("Content-Disposition", String.format("filename=\"%s\"", this.file2.getName()));
        });
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Test revert and delete a node version.")
    public void testRevertDeleteVersion() {
        Step.STEP((String)"1. Revert to version 1.0 POST /nodes/{nodeId}/versions/{versionId}/revert");
        RestVersionModel version = this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file2).revertVersion("1.0", new String("{}"));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        String nodeVersionType = new JSONObject(version.toJson()).getJSONObject("properties").getString("cm:versionType");
        Assert.assertEquals((String)nodeVersionType, (String)"MINOR");
        String nodeVersion = version.getId();
        Step.STEP((String)"2. Revert to last minor version /nodes/{nodeId}/versions/{versionId}/revert");
        version = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).revertVersion(nodeVersion, new String("{\"majorVersion\": true}"));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        nodeVersionType = new JSONObject(version.toJson()).getJSONObject("properties").getString("cm:versionType");
        Assert.assertEquals((String)nodeVersionType, (String)"MAJOR");
        Assert.assertTrue((nodeVersion.charAt(0) + '\u0001' == version.getId().charAt(0) ? 1 : 0) != 0);
        Step.STEP((String)"3. Delete last MINOR version DELETE /nodes/{nodeId}/versions/{versionId}");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).deleteNodeVersion(nodeVersion);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file2).getVersionInformation(nodeVersion);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify file name in Content Range header")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkFileNameContentRangeHeader() {
        this.restClient.configureRequestSpec().addHeader("content-range", "bytes=1-10");
        this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.PARTIAL_CONTENT);
        this.restClient.assertHeaderValueContains("content-range", "bytes 1-10");
        this.restClient.assertHeaderValueContains("content-length", String.valueOf(10));
    }

    @Test(groups={"rest-api", "nodes"})
    public void checkUploadResponse() {
        Step.STEP((String)"Create a folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"Upload a text document to the folder.");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"UTF-8File.txt"));
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestNodeModel)((RestNodeModel)fileNode.assertThat().field("id").isNotNull()).and().field("name").is((Object)"UTF-8File.txt")).and().field("content.mimeType").is((Object)FileType.TEXT_PLAIN.mimeType);
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkTextFileDownload() {
        Step.STEP((String)"Create a folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"Upload a text document to the folder.");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"sampleContent.txt"));
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        FileModel fileModel = new FileModel();
        fileModel.setNodeRef(fileNode.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Download the file and check the content and headers.");
        RestResponse nodeContent = this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        nodeContent.assertThat().body(Matchers.equalTo((Object)"Sample text."), new Matcher[0]);
        this.restClient.assertHeaderValueContains("Content-Disposition", "attachment; filename=\"sampleContent.txt\"; filename*=UTF-8''sampleContent.txt");
        Headers responseHeaders = this.restClient.getResponseHeaders();
        String cacheControl = responseHeaders.getValue("Cache-Control");
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"), (String)("Cache-Control is missing \"must-revalidate\": " + cacheControl));
        Assert.assertTrue((boolean)cacheControl.contains("max-age=0"), (String)("Cache-Control is missing \"max-age=0\": " + cacheControl));
        Assert.assertNotNull((Object)responseHeaders.getValue("Expires"), (String)"\"Expires\" header is missing");
    }

    @Test(groups={"rest-api", "nodes"})
    public void checkBinaryFileDownload() throws Exception {
        Step.STEP((String)"Create a folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"Upload a text document to the folder.");
        File binaryFile = Utility.getResourceTestDataFile((String)"avatar.jpg");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", binaryFile);
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        FileModel fileModel = new FileModel();
        fileModel.setNodeRef(fileNode.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Download the file and check the binary content and headers.");
        RestResponse nodeContent = this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        byte[] originalBytes = Files.readAllBytes(Paths.get(binaryFile.getAbsolutePath(), new String[0]));
        Assert.assertEquals((byte[])nodeContent.getResponse().getBody().asByteArray(), (byte[])originalBytes, (String)"Unexpected content retrieved");
        this.restClient.assertHeaderValueContains("Content-Disposition", "attachment; filename=\"avatar.jpg\"; filename*=UTF-8''avatar.jpg");
        Headers responseHeaders = this.restClient.getResponseHeaders();
        String cacheControl = responseHeaders.getValue("Cache-Control");
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"), (String)("Cache-Control is missing \"must-revalidate\": " + cacheControl));
        Assert.assertTrue((boolean)cacheControl.contains("max-age=0"), (String)("Cache-Control is missing \"max-age=0\": " + cacheControl));
        Assert.assertNotNull((Object)responseHeaders.getValue("Expires"), (String)"\"Expires\" header is missing");
    }

    @Test(groups={"rest-api", "nodes"})
    public void checkNotModifiedStatusCode() {
        Step.STEP((String)"Create a folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"Upload a text document to the folder.");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"sampleContent.txt"));
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        FileModel fileModel = new FileModel();
        fileModel.setNodeRef(fileNode.getId());
        Step.STEP((String)"Download the file with If-Modified-Since in the past and check for a 200 status code.");
        this.restClient.configureRequestSpec().addHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"Try redownloading the file the current If-Modified-Since and check for a 304 status code.");
        String lastModified = this.restClient.getResponseHeaders().getValue("Last-Modified");
        this.restClient.configureRequestSpec().addHeader("If-Modified-Since", lastModified);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_MODIFIED);
    }

    @Test(groups={"rest-api", "nodes"})
    public void checkModificationUpdatesLastModifiedHeader() throws InterruptedException {
        Step.STEP((String)"Create a folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.site1)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"Upload a text document to the folder.");
        this.restClient.authenticateUser(this.user1).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"sampleContent.txt"));
        RestNodeModel fileNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        FileModel fileModel = new FileModel();
        fileModel.setNodeRef(fileNode.getId());
        Step.STEP((String)"Download the file and get the Last-Modified header.");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        String oldLastModified = this.restClient.getResponseHeaders().getValue("Last-Modified");
        Step.STEP((String)"Wait for a second so that the modification will be at a different datetime.");
        Thread.sleep(1000L);
        Step.STEP((String)"Modify the description and check the Last-Modified header changes.");
        JsonObject json = Json.createObjectBuilder().add("properties", Json.createObjectBuilder().add("cm:description", "New description")).build();
        this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).updateNode(json.toString());
        this.restClient.configureRequestSpec().addHeader("If-Modified-Since", oldLastModified);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)fileModel).getNodeContent();
        String newLastModified = this.restClient.getResponseHeaders().getValue("Last-Modified");
        Assert.assertNotEquals((Object)newLastModified, (Object)oldLastModified, (String)"Expected Last-Modified header to change when property was updated.");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    private void createRandomFileInDirectory(String path, String fileName, int size) {
        String fullPath = new File(path, fileName).getPath();
        try {
            RandomAccessFile file = new RandomAccessFile(fullPath, "rw");
            file.setLength(size);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

