/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import java.nio.file.Paths;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPreferenceModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferenceFullTests
extends RestTest {
    private UserModel userModel;
    private SiteModel siteModel;
    private RestPreferenceModel restPreferenceModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(this.siteModel)).addSiteToFavorites();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Check that properties parameter is applied")
    public void propertiesParameterIsAppliedWhenRetrievingPreference() throws Exception {
        this.restPreferenceModel = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"properties=id"}).withCoreAPI().usingUser(this.userModel).getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").isNull();
        this.restPreferenceModel = this.restClient.authenticateUser(this.userModel).withParams(new String[]{"properties=id,value"}).withCoreAPI().usingUser(this.userModel).getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Validate ID element in get site preference response")
    public void validateIdElementInGetSitePreferenceResponse() throws Exception {
        this.restPreferenceModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Validate ID element in get folder preference response")
    public void validateIdElementInGetFolderPreferenceResponse() throws Exception {
        FolderModel folderFavorite = new FolderModel("favoriteFolder");
        folderFavorite = ((DataContent)this.dataContent.usingSite(this.siteModel)).createFolder(folderFavorite);
        this.dataContent.getContentActions().setFolderAsFavorite(this.userModel.getUsername(), this.userModel.getPassword(), this.siteModel.getId(), folderFavorite.getName());
        this.restPreferenceModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.FOLDERS_FAVORITES_PREFIX.toString());
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)PreferenceName.FOLDERS_FAVORITES_PREFIX)).and().field("value").is((Object)Utility.removeLastSlash((String)Utility.buildPath((String)"workspace://SpacesStore", (String[])new String[]{folderFavorite.getNodeRef()})));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Validate ID element in get file preference response")
    public void validateIdElementInGetFilePreferenceResponse() throws Exception {
        FileModel fileFavorite = new FileModel("favoriteFile", FileType.TEXT_PLAIN);
        fileFavorite = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(fileFavorite);
        this.dataContent.getContentActions().setFileAsFavorite(this.userModel.getUsername(), this.userModel.getPassword(), this.siteModel.getId(), fileFavorite.getName());
        this.restPreferenceModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)PreferenceName.DOCUMENTS_FAVORITES_PREFIX)).and().field("value").is((Object)Utility.removeLastSlash((String)Utility.buildPath((String)"workspace://SpacesStore", (String[])new String[]{fileFavorite.getNodeRefWithoutVersion()})));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Get preference of an user that has no preferences")
    public void getPreferenceForUserWithoutPreferences() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString()));
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.FOLDERS_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.FOLDERS_FAVORITES_PREFIX.toString()));
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.SITES_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.SITES_FAVORITES_PREFIX.toString()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Change one preference for an user then perform get call")
    @Bug(id="REPO-1922")
    public void changePreferenceThenPerformGetPreferenceCall() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(newUser)).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(newUser)).usingSite(site)).addSiteToFavorites();
        FileModel fileFavorite = new FileModel("favoriteFile", FileType.TEXT_PLAIN);
        fileFavorite = ((DataContent)this.dataContent.usingSite(site)).createContent(fileFavorite);
        this.dataContent.getContentActions().setFileAsFavorite(newUser.getUsername(), newUser.getPassword(), site.getId(), String.format("%s.%s", fileFavorite.getName(), fileFavorite.getFileType().extension));
        FolderModel folderFavorite = new FolderModel("favoriteFolder");
        folderFavorite = ((DataContent)this.dataContent.usingSite(site)).createFolder(folderFavorite);
        this.dataContent.getContentActions().setFolderAsFavorite(newUser.getUsername(), newUser.getPassword(), site.getId(), folderFavorite.getName());
        ((DataSite)((DataSite)this.dataSite.usingUser(newUser)).usingSite(site)).removeSiteFromFavorites();
        this.dataContent.getContentActions().removeFavorite(newUser.getUsername(), newUser.getPassword(), site.getId(), folderFavorite.getName());
        this.dataContent.getContentActions().removeFavorite(newUser.getUsername(), newUser.getPassword(), site.getId(), Paths.get(fileFavorite.getCmisLocation(), new String[0]).getFileName().toString());
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.FOLDERS_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.FOLDERS_FAVORITES_PREFIX.toString()));
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.SITES_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.SITES_FAVORITES_PREFIX.toString()));
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString()));
        this.restPreferenceModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.FOLDERS_FAVORITES_PREFIX.toString());
        this.restClient.assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", newUser.getUsername(), PreferenceName.FOLDERS_FAVORITES_PREFIX.toString()));
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to get preference of another user")
    public void adminIsAbleToGetOtherUserPreference() throws Exception {
        this.restPreferenceModel = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(this.userModel).getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is not able to get preference of admin user")
    public void regularUserIsNotAbleToGetAdminPreference() throws Exception {
        SiteModel newSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).usingSite(newSite)).addSiteToFavorites();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.dataUser.getAdminUser()).getPersonPreferenceInformation(String.valueOf(PreferenceName.SITES_FAVORITES_PREFIX) + newSite.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

