/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.json.Json;
import javax.json.JsonObject;
import org.alfresco.rest.model.RestActionBodyExecTemplateModel;
import org.alfresco.rest.model.RestActionConstraintDataModel;
import org.alfresco.rest.model.RestActionConstraintModel;
import org.alfresco.rest.model.RestCompositeConditionDefinitionModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.requests.FolderRules;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.junit.Assert;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class CreateRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;
    private FolderModel ruleFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void createRule() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithModifiedValues();
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithModifiedValues();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{"id", "isShared"})).assertThat().field("id").isNotNull()).assertThat().field("isShared").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleInNonExistentFolder() {
        Step.STEP((String)"Try to create a rule in non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("ruleName");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary("Folder with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleInNonExistentRuleSet() {
        Step.STEP((String)"Try to create a rule in non-existent rule set.");
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("ruleName");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingRuleSet("fake-id").createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary("Rule set with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithEmptyName() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Rule name is a mandatory parameter");
    }

    @Test(groups={"rest-api", "rules"})
    public void duplicateRuleNameIsAcceptable() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("duplicateRuleName");
        Step.STEP((String)"Create two identical rules");
        RestRuleModel ruleA = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel ruleB = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        ruleA.assertThat().field("name").is((Object)ruleB.getName());
        ruleA.assertThat().field("id").isNot((Object)ruleB.getId());
    }

    @Test(groups={"rest-api", "rules"})
    public void requireReadPermissionToCreateRule() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        Step.STEP((String)"Try to use a different user to create a rule in the private folder");
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("ruleName");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Insufficient permissions to manage rules");
    }

    @Test(groups={"rest-api", "rules"})
    public void siteCollaboratorCannotCreateRule() {
        this.testRolePermissionsWith(UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Insufficient permissions to manage rules");
    }

    @Test(groups={"rest-api", "rules"})
    public void siteContributorCannotCreateRule() {
        this.testRolePermissionsWith(UserRole.SiteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Insufficient permissions to manage rules");
    }

    @Test(groups={"rest-api", "rules"})
    public void siteConsumerCannotCreateRule() {
        this.testRolePermissionsWith(UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Insufficient permissions to manage rules");
    }

    @Test(groups={"rest-api", "rules"})
    public void siteManagerCanCreateRule() {
        ((RestRuleModel)this.testRolePermissionsWith(UserRole.SiteManager).assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)"testRule");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void tryToCreateRuleUnderDocument() {
        Step.STEP((String)"Create a document.");
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setName("ruleName");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)fileModel).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("folder is expected");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRules() {
        Step.STEP((String)"Create a list of rules in one POST request");
        List<String> ruleNames = List.of("ruleA", "ruleB", "ruleC");
        List ruleModels = ruleNames.stream().map(this.rulesUtils::createRuleModel).collect(Collectors.toList());
        RestRuleModelsCollection rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createListOfRules(ruleModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Assert.assertEquals((String)"Unexpected number of rules received in response.", (long)ruleNames.size(), (long)rules.getEntries().size());
        IntStream.range(0, ruleModels.size()).forEach(i -> ((RestRuleModel)((RestRuleModel)rules.getEntries().get(i)).onModel().assertThat().field("id").isNotNull()).assertThat().field("name").is(ruleNames.get(i)));
    }

    @Test(groups={"rest-api", "rules"})
    public void createOver100Rules() {
        Step.STEP((String)"Create a list of 120 rules in one POST request");
        int ruleCount = 120;
        String ruleNamePrefix = "multiRule";
        List ruleModels = IntStream.rangeClosed(1, 120).mapToObj(i -> this.rulesUtils.createRuleModel("multiRule" + i)).collect(Collectors.toList());
        FolderModel aFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModelsCollection rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)aFolder).usingDefaultRuleSet().createListOfRules(ruleModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Assert.assertEquals((String)"Unexpected number of rules received in response.", (long)120L, (long)rules.getEntries().size());
        IntStream.range(0, ruleModels.size()).forEach(i -> ((RestRuleModel)((RestRuleModel)rules.getEntries().get(i)).onModel().assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)("multiRule" + (i + 1))));
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)rules.getPagination().assertThat().field("count").is((Object)120)).assertThat().field("totalItems").is((Object)120)).assertThat().field("maxItems").is((Object)120)).assertThat().field("skipCount").is((Object)0)).assertThat().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRulesWithOneError() {
        Step.STEP((String)"Try to create a three rules but the middle one has an error.");
        RestRuleModel ruleA = this.rulesUtils.createRuleModel("ruleA");
        RestRuleModel ruleB = this.rulesUtils.createRuleModel("");
        RestRuleModel ruleC = this.rulesUtils.createRuleModel("ruleC");
        List<RestRuleModel> ruleModels = List.of(ruleA, ruleB, ruleC);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createListOfRules(ruleModels);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Rule name is a mandatory parameter");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutDescription() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)"ruleName")).assertThat().field("description").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutTriggers() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)"ruleName")).assertThat().field("triggers").is(List.of("inbound"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutErrorScript() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)"ruleName")).assertThat().field("errorScript").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithSharedFlag() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setIsShared(Boolean.valueOf(true));
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)((RestRuleModel)rule.assertThat().field("id").isNotNull()).assertThat().field("name").is((Object)"ruleName")).assertThat().field("isShared").isNull();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void createRuleAndIncludeFieldsInResponse() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        RestRuleModel rule = ((FolderRules)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().include(new String[]{"isShared"})).createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        rule.assertThat().field("isShared").isNotNull();
    }

    private RestRuleModel testRolePermissionsWith(UserRole userRole) {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder");
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.user)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(privateSite)).createFolder();
        Step.STEP((String)String.format("Add a user with '%s' role in the private site's folder", userRole.toString()));
        UserModel userWithRole = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(userWithRole, privateSite, userRole);
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("testRule", List.of(this.rulesUtils.createAddAudioAspectAction()));
        return this.restClient.authenticateUser(userWithRole).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkOwnerCanCreateRule() {
        Step.STEP((String)"Use admin to create a private site.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPrivateRandomSite();
        Step.STEP((String)"Add the user to the site, let them create a folder and then evict them from the site again.");
        this.dataUser.addUserToSite(this.user, privateSite, UserRole.SiteManager);
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(privateSite)).createFolder();
        this.dataUser.removeUserFromSite(this.user, privateSite);
        Step.STEP((String)"Check the folder owner can create a rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkAdminCanCreateRule() {
        Step.STEP((String)"Use a user to create a private site with a folder.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.user)).createPrivateRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(privateSite)).createFolder();
        Step.STEP((String)"Check admin can create a rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkCoordinatorCanCreateRule() {
        Step.STEP((String)"Create a folder in the user's file space.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingUserHome()).createFolder();
        Step.STEP((String)"Create another user as a coordinator for this folder.");
        UserModel coordinator = this.dataUser.createRandomTestUser("Rules");
        String putBody = this.getAddPermissionsBody(coordinator.getUsername(), "Coordinator");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).updateNode(putBody);
        Step.STEP((String)"Check the coordinator can create a rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(coordinator).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkEditorCannotCreateRule() {
        Step.STEP((String)"Create a folder in the user's file space.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingUserHome()).createFolder();
        Step.STEP((String)"Create another user as a editor for this folder.");
        UserModel editor = this.dataUser.createRandomTestUser();
        String putBody = this.getAddPermissionsBody(editor.getUsername(), "Editor");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).updateNode(putBody);
        Step.STEP((String)"Check the editor can create a rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(editor).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkCollaboratorCannotCreateRule() {
        Step.STEP((String)"Create a folder in the user's file space.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingUserHome()).createFolder();
        Step.STEP((String)"Create another user as a collaborator for this folder.");
        UserModel collaborator = this.dataUser.createRandomTestUser();
        String putBody = this.getAddPermissionsBody(collaborator.getUsername(), "Collaborator");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).updateNode(putBody);
        Step.STEP((String)"Check the collaborator can create a rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.restClient.authenticateUser(collaborator).withPrivateAPI().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithActions() {
        UserModel admin = this.dataUser.getAdminUser();
        RestRuleModel rule = this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleWithVariousActions());
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        expectedRuleModel.setActions(this.rulesUtils.createRuleWithVariousActions().getActions());
        expectedRuleModel.setTriggers(List.of("inbound"));
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRuleModel)rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{"id", "isShared"})).assertThat().field("isShared").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithEmptyActionParameterValueShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel checkinAction = this.rulesUtils.createCustomActionModel("check-in", Map.of("description", ""));
        ruleModel.setActions(List.of(checkinAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Action parameter should not have empty or null value");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutParameterWhenTheyAreOptional() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel checkinAction = this.rulesUtils.createCustomActionModel("check-in", null);
        ruleModel.setActions(List.of(checkinAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithActions_userCannotUsePrivateAction() {
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleWithPrivateAction());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Only admin or system user is allowed to define uses of or directly execute this action");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithActions_adminCanUsePrivateAction() {
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleWithPrivateAction());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithActions_adminCanUseMailActionWithTemplate() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel mailAction = new RestActionBodyExecTemplateModel();
        mailAction.setActionDefinitionId("mail");
        HashMap<String, String> params = new HashMap<String, String>();
        UserModel sender = UserModel.getRandomUserModel();
        UserModel recipient = UserModel.getRandomUserModel();
        params.put("from", sender.getEmailAddress());
        params.put("to", recipient.getEmailAddress());
        params.put("subject", "Test");
        RestActionConstraintModel constraint = this.rulesUtils.getConstraintsForActionParam(this.user, "mail", "template");
        String templateScriptRef = ((RestActionConstraintDataModel)constraint.getConstraintValues().stream().findFirst().get()).getValue();
        params.put("template", templateScriptRef);
        mailAction.setParams(params);
        ruleModel.setActions(List.of(mailAction));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutActionsShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setActions(null);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("A rule must have at least one action");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithInvalidActionsShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        String actionDefinitionId = "invalid-definition-value";
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("invalid-definition-value", Map.of("dummy-key", "dummy-value"));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Invalid rule action definition requested %s", "invalid-definition-value"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithNotApplicableActionShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("delete-rendition", Map.of("dummy-key", "dummy-value"));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Invalid rule action definition requested %s", "delete-rendition"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithMissingActionParametersShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("copy", Collections.emptyMap());
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Action parameters should not be null or empty for this action. See Action Definition for action of: %s", "copy"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithActionParameterNotFulfillingConstraint() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        String actionDefinitionId = "script";
        String scriptRef = "script-ref";
        String scriptNodeId = "dummy-script-node-id";
        RestActionBodyExecTemplateModel scriptAction = this.rulesUtils.createCustomActionModel("script", Map.of("script-ref", "dummy-script-node-id"));
        ruleModel.setActions(List.of(scriptAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        String acScriptsConstraint = "ac-scripts";
        this.restClient.assertLastError().containsSummary(String.format("Action parameter: %s has invalid value (%s). Look up possible values for constraint name %s", "script-ref", "dummy-script-node-id", "ac-scripts"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithInvalidActionParameterShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        String invalidParameterKey = "invalidParameterKey";
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("add-features", Map.of("invalidParameterKey", "dummyValue"));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary(String.format("Action of definition id: %s must not contain parameter of name: %s", "add-features", "invalidParameterKey"));
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithoutMandatoryActionParametersShouldFail() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("copy", Map.of("deep-copy", false));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Missing action's mandatory parameter: destination-folder");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleThatUsesNonExistentNode() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("copy", Map.of("destination-folder", "non-existent-node"));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary("The entity with id: non-existent-node was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleThatUsesNodeWithoutReadPermission() {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("copy", Map.of("destination-folder", privateFolder.getNodeRef()));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary("The entity with id: " + privateFolder.getNodeRef() + " was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleThatWritesToNodeWithoutPermission() {
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.user, privateSite, UserRole.SiteConsumer);
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("copy", Map.of("destination-folder", privateFolder.getNodeRef()));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("No proper permissions for node: " + privateFolder.getNodeRef());
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleThatMovesToNodeWhichIsNotAFolderShouldFail() {
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel invalidAction = this.rulesUtils.createCustomActionModel("move", Map.of("destination-folder", fileModel.getNodeRef()));
        ruleModel.setActions(List.of(invalidAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Node is not a folder " + fileModel.getNodeRef());
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithMailActionReferringToNonExistingTemplate() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel mailAction = new RestActionBodyExecTemplateModel();
        mailAction.setActionDefinitionId("mail");
        HashMap<String, String> params = new HashMap<String, String>();
        UserModel sender = UserModel.getRandomUserModel();
        UserModel recipient = UserModel.getRandomUserModel();
        params.put("from", sender.getEmailAddress());
        params.put("to", recipient.getEmailAddress());
        params.put("subject", "Test");
        String mailTemplate = "non-existing-node-id";
        params.put("template", "non-existing-node-id");
        mailAction.setParams(params);
        ruleModel.setActions(List.of(mailAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Action parameter: template has invalid value (non-existing-node-id). Look up possible values for constraint name ac-email-templates");
    }

    @Test(groups={"rest-api", "rules"})
    public void checkCanUseScriptInRule() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel scriptAction = this.rulesUtils.createCustomActionModel("script", Map.of("script-ref", this.rulesUtils.getReviewAndApproveWorkflowNode()));
        ruleModel.setActions(List.of(scriptAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "rules"})
    public void checkCantUseNodeOutsideScriptsDirectory() {
        Step.STEP((String)"Copy script to location outside data dictionary.");
        FolderModel folderOutsideDataDictionary = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        String sourceNodeId = this.rulesUtils.getReviewAndApproveWorkflowNode();
        ContentModel sourceNode = new ContentModel("/Data Dictionary/Scripts/start-pooled-review-workflow.js");
        sourceNode.setNodeRef("/workspace://SpacesStore/" + sourceNodeId);
        CmisObject scriptOutsideDataDictionary = this.dataContent.getContentActions().copyTo(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), sourceNode.getCmisLocation(), folderOutsideDataDictionary.getCmisLocation());
        String scriptId = scriptOutsideDataDictionary.getId().substring(0, scriptOutsideDataDictionary.getId().indexOf(";"));
        Step.STEP((String)"Try to use this script in rule.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel scriptAction = this.rulesUtils.createCustomActionModel("script", Map.of("script-ref", scriptId));
        ruleModel.setActions(List.of(scriptAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("script-ref has invalid value");
    }

    @Test(groups={"rest-api", "rules"})
    public void checkLinkToCategoryNeedsRealCategory() {
        Step.STEP((String)"Attempt to link to a category with a folder node, rather than a category node.");
        String nonCategoryNodeRef = this.ruleFolder.getNodeRef();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        RestActionBodyExecTemplateModel categoryAction = this.rulesUtils.createCustomActionModel("link-category", Map.of("category-value", nonCategoryNodeRef));
        ruleModel.setActions(List.of(categoryAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithConditions() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setConditions(this.rulesUtils.createVariousConditions());
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        expectedRuleModel.setConditions(this.rulesUtils.createVariousConditions());
        expectedRuleModel.setTriggers(List.of("inbound"));
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{"id", "isShared"});
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithConditions_emptyConditionList() {
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setConditions(this.rulesUtils.createCompositeCondition(null));
        RestRuleModel rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleModel expectedRuleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        expectedRuleModel.setTriggers(List.of("inbound"));
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        rule.assertThat().isEqualTo((Object)expectedRuleModel, new String[]{"id", "isShared"});
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithConditions_invalidCategory() {
        Step.STEP((String)"Try to create a rule with non existing category in conditions.");
        String fakeCategoryId = "bdba5f9f-fake-id22-803b-349bcfd06fd1";
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("category", "equals", fakeCategoryId)))));
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Category in condition is invalid");
    }

    @Test(groups={"rest-api", "rules"})
    public void createRuleWithConditions_invalidComparator() {
        Step.STEP((String)"Try to create a rule with invalid comparator in conditions.");
        String comparator = "greaterthan";
        RestCompositeConditionDefinitionModel conditions = this.rulesUtils.createCompositeCondition(List.of(this.rulesUtils.createCompositeCondition(false, List.of(this.rulesUtils.createSimpleCondition("size", "greaterthan", "500")))));
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setConditions(conditions);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("Comparator value for condition is invalid: greaterthan");
    }

    private String getAddPermissionsBody(String username, String role) {
        JsonObject userPermission = Json.createObjectBuilder().add("permissions", Json.createObjectBuilder().add("isInheritanceEnabled", true).add("locallySet", Json.createObjectBuilder().add("authorityId", username).add("name", role).add("accessStatus", "ALLOWED"))).build();
        return userPermission.toString();
    }
}

