/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class AddTagTests
extends TagsDataPrep {
    private String tagValue;
    private RestTagModel returnedModel;
    private RestCommentModel returnedModelComment;
    private RestTagModelsCollection returnedModelTags;

    @BeforeMethod(alwaysRun=true)
    public void generateRandomTag() {
        this.tagValue = RandomData.getRandomName((String)"tag").toLowerCase();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user adds tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsAbleToAddTag() {
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Manager user adds tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void managerIsAbleToTagAFile() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user adds tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsAbleToTagAFile() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user doesn't have permission to add tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsNotAbleToAddTagToAnotherContent() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user adds tags to his content with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsAbleToAddTagToHisContent() {
        userModel = usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(userModel);
        FileModel contributorDoc = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(userModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)contributorDoc).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("id").isNotEmpty()).and().field("tag").is((Object)this.tagValue);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user doesn't have permission to add tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToTagAFile() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userIsNotAbleToAddTagIfAuthenticationFails() {
        UserModel siteManager = usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        String managerPassword = siteManager.getPassword();
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag("tagUnauthorized");
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        siteManager.setPassword(managerPassword);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding empty tag returns status code 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void emptyTagTest() {
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NULL_ARGUMENT, "tag"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding tag with user that has no permissions returns status code 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagWithUserThatDoesNotHavePermissions() {
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser());
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that adding tag to a node that does not exist returns status code 404")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagToInexistentNode() {
        String oldNodeRef = document.getNodeRef();
        String nodeRef = RandomStringUtils.randomAlphanumeric((int)10);
        document.setNodeRef(nodeRef);
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nodeRef));
        document.setNodeRef(oldNodeRef);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to tag a folder")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void managerIsAbleToTagAFolder() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that tagged file can be tagged again")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagToATaggedFile() {
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag("random_tag_value");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)"random_tag_value")).and().field("id").isNotEmpty();
        ((RestModels)this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags().assertThat().entriesListContains("tag", this.tagValue.toLowerCase())).and().entriesListContains("tag", "random_tag_value");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that user cannot add invalid tag")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addInvalidTag() {
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag("-1~!|@#$%^&*()_=");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, "|"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor is able to tag a folder created by self")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsAbleToTagAFolderCreatedBySelf() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator is able to tag a folder")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsAbleToTagAFolder() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer is not able to tag a folder. Check default error model schema.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToTagAFolder() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that tagged folder can be tagged again")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagToATaggedFolder() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)this.tagValue)).and().field("id").isNotEmpty();
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag("random_tag_value");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)"random_tag_value")).and().field("id").isNotEmpty();
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).getNodeTags().assertThat().entriesListContains("tag", this.tagValue.toLowerCase())).and().entriesListContains("tag", "random_tag_value")).and().entriesListCountIs(2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Using collaborator provide more than one tag element")
    @Test(groups={"rest-api", "tags", "regression"})
    public void provideMoreThanOneTagElement() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        String tagValue1 = RandomData.getRandomName((String)"tag1").toLowerCase();
        String tagValue2 = RandomData.getRandomName((String)"tag2").toLowerCase();
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.returnedModelTags = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTags(new String[]{this.tagValue, tagValue1, tagValue2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)((RestModels)((RestModels)this.returnedModelTags.assertThat().entriesListContains("tag", this.tagValue)).and().entriesListContains("tag", tagValue1)).and().entriesListContains("tag", tagValue2)).and().entriesListCountIs(3);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager cannot add tag with special characters.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagWithSpecialCharacters() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        String specialCharsTag = "!@#$%^&*()'\".,<>-_+=|\\";
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(specialCharsTag);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, "|"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that you cannot tag a comment and it returns status code 405")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagToAComment() {
        FileModel file = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String comment = "comment for a tag";
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModelComment = this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addComment(comment);
        file.setNodeRef(this.returnedModelComment.getId());
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.CANNOT_TAG);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that you cannot tag a tag and it returns status code 405")
    @Test(groups={"rest-api", "tags", "regression"})
    public void addTagToATag() {
        FileModel file = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(adminUserModel);
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(this.tagValue);
        file.setNodeRef(this.returnedModel.getId());
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(this.tagValue);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.CANNOT_TAG);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify the tag name is converted to lower case before being applied")
    @Test(groups={"rest-api", "tags", "regression"})
    public void tagNameIsConvertedToLowerCase() {
        this.restClient.authenticateUser(adminUserModel);
        String tagName = RandomData.getRandomName((String)"TaG-oNe");
        this.returnedModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(tagName);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)this.returnedModel.assertThat().field("tag").is((Object)tagName.toLowerCase())).and().field("id").isNotEmpty();
    }
}

