/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.rest.model.RestVariableModelsCollection;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskVariablesTests
extends RestTest {
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;
    private RestVariableModelsCollection variableModels;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user that started the process gets task variables")
    public void getTaskVariablesByUserWhoStartedProcess() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.variableModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user that is involved in the process gets task variables")
    public void getTaskVariablesByUserInvolvedInProcess() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.restClient.authenticateUser(this.assignee);
        this.variableModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user that is not involved in the process gets task variables")
    public void getTaskVariablesUsingAnyUser() throws Exception {
        UserModel randomUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.restClient.authenticateUser(randomUser);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that admin is able to  task variables")
    public void getTaskVariablesUsingAdmin() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.restClient.authenticateUser(adminUser);
        this.variableModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task variables request returns status code 404 when invalid taskId is used")
    public void getTaskVariablesUsingInvalidTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskModel.setId("invalidId");
        this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task variables request returns status code 404 when empty taskId is used")
    public void getTaskVariablesUsingEmptyTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskModel.setId("");
        this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task variables request returns status code 200 after the task is finished.")
    public void getTaskVariablesAfterFinishingTask() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.assignee)).taskDone(this.taskModel);
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task variables request returns status code 200 after the process is deleted (Task state is now completed.)")
    public void getTaskVariablesAfterDeletingProcess() throws Exception {
        RestProcessModel addedProcess = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        RestTaskModel addedTask = this.restClient.withWorkflowAPI().getTasks().getTaskModelByProcess((ProcessModel)addedProcess);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)addedProcess).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.variableModels = this.restClient.withWorkflowAPI().usingTask((TaskModel)addedTask).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets task variables that matches a where clause.")
    public void getTaskVariablesWithWhereClauseAsParameter() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).where("scope='local'").withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.variableModels.assertThat().entriesListIsNotEmpty()).and().entriesListDoesNotContain("scope", "global")).and().paginationField("totalItems").is("8");
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.variableModels.assertThat().entriesListContains("scope", "global")).and().paginationField("totalItems").is("30");
    }

    @Bug(id="MNT-17438")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets task with 'maxItems' parameter")
    public void getTaskVariablesWithMaxItems() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"maxItems=2"})).usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.variableModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("2");
    }

    @Bug(id="MNT-17438")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets task with 'skipCount' parameter")
    public void getTaskVariablesWithSkipCount() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"skipCount=10"})).usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.variableModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("20");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get task variables with invalid where clause.")
    public void getTaskVariablesWithInvalidWhereClauseAsParameter() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).where("scope='fake-where'").withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_WHERE_QUERY, "Invalid value for 'scope' used in query: fake-where.")).containsErrorKey(RestErrorModel.INVALID_QUERY_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets tasks variables with 'properties' parameter")
    public void getTaskVariablesWithValidProperties() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"properties=scope,name"}).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variableModels.assertThat().entriesListIsNotEmpty();
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.variableModels.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)2)).and().field("type").isNull()).and().field("value").isNull()).and().field("scope").isNotEmpty()).and().field("name").isNotEmpty();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get tasks variables with invalid 'properties' parameter")
    public void getTaskVariablesWithInvalidProperties() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.variableModels = this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"properties=fake"}).withWorkflowAPI().usingTask(this.taskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.variableModels.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)0)).and().field("type").isNull()).and().field("value").isNull()).and().field("scope").isNull()).and().field("name").isNull();
    }
}

