/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RestModelProperty {
    private String name;
    private String type;
    private String description;
    private Boolean isRequired = false;
    private String simpleRef;
    private RestModelProperty itemsType;

    public static RestModelProperty build(Map.Entry<String, Property> property) {
        RestModelProperty model = new RestModelProperty();
        model.setName(property.getKey());
        model.setType(property.getValue().getType());
        model.setDescription(property.getValue().getDescription());
        model.setIsRequired(property.getValue().getRequired());
        if (property.getValue() instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)property.getValue();
            model.setSimpleRef(refProperty.getSimpleRef());
        }
        if (property.getValue() instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property.getValue();
            AbstractMap.SimpleEntry<String, Property> itemsEntry = new AbstractMap.SimpleEntry<String, Property>(arrayProperty.getName(), arrayProperty.getItems());
            model.setItemsType(RestModelProperty.build(itemsEntry));
        }
        return model;
    }

    public String getName() {
        return this.name;
    }

    public String getNameCapitalized() {
        return StringUtils.capitalize((String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        switch (this.type) {
            case "string": {
                return "String";
            }
            case "integer": {
                return "int";
            }
            case "object": {
                return "Object";
            }
            case "ref": {
                return "Rest" + this.getSimpleRef() + "Model";
            }
            case "array": {
                return "List<" + this.getItemsType().getType() + ">";
            }
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    protected void setSimpleRef(String simpleRef) {
        this.simpleRef = simpleRef;
    }

    public String getSimpleRef() {
        return this.simpleRef;
    }

    protected void setItemsType(RestModelProperty itemsType) {
        this.itemsType = itemsType;
    }

    public RestModelProperty getItemsType() {
        return this.itemsType;
    }
}

