/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.syncServiceAPI;

import java.util.HashMap;
import javax.json.JsonArrayBuilder;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestSubscriberModel;
import org.alfresco.rest.model.RestSyncNodeSubscriptionModel;
import org.alfresco.rest.model.RestSyncNodeSubscriptionModelCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.privateAPI.RestPrivateAPI;
import org.alfresco.utility.Utility;
import org.springframework.http.HttpMethod;

public class Subscriptions
extends ModelRequest<RestPrivateAPI> {
    private RestSubscriberModel subscriber;
    private String subscriptionsURL = "subscribers/{deviceSubscriptionId}/subscriptions";
    String nodeSubscriptionURL = this.subscriptionsURL + "/{nodeSubscriptionId}";
    String params = "?{parameters}";

    public Subscriptions(RestSubscriberModel subscriber, RestWrapper restWrapper) {
        super(restWrapper);
        this.subscriber = subscriber;
        Utility.checkObjectIsInitialized((Object)this.subscriber, (String)"Subscriber Device");
    }

    public RestSyncNodeSubscriptionModelCollection subscribeToNodes(String ... targetNodeIds) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (String targetNodeId : targetNodeIds) {
            array.add(JsonBodyGenerator.defineJSON().add("targetNodeId", targetNodeId).add("subscriptionType", TYPE.BOTH.toString()));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, this.subscriptionsURL + this.params, this.subscriber.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSyncNodeSubscriptionModelCollection.class, request);
    }

    public RestSyncNodeSubscriptionModel subscribeToNode(String targetNodeId, TYPE subscriberType) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("targetNodeId", targetNodeId);
        body.put("subscriptionType", subscriberType.toString());
        String postBody = JsonBodyGenerator.keyValueJson(body);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, this.subscriptionsURL + this.params, this.subscriber.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSyncNodeSubscriptionModel.class, request);
    }

    public RestSyncNodeSubscriptionModelCollection getSubscriptions() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, this.subscriptionsURL + this.params, this.subscriber.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSyncNodeSubscriptionModelCollection.class, request);
    }

    public RestSyncNodeSubscriptionModel getSubscription(String nodeSubscriptionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, this.nodeSubscriptionURL + this.params, this.subscriber.getId(), nodeSubscriptionId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSyncNodeSubscriptionModel.class, request);
    }

    public static enum TYPE {
        BOTH,
        CONTENT,
        METADATA;

    }
}

