/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.assertion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Ordering;
import io.restassured.path.json.JsonPath;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.core.IRestModelsCollection;
import org.alfresco.rest.core.assertion.PaginationAssertionVerbs;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.Model;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.beanutils.BeanUtils;
import org.testng.Assert;

public class ModelsCollectionAssertion<C> {
    private IRestModelsCollection modelCollection;

    public ModelsCollectionAssertion(IRestModelsCollection modelCollection) {
        this.modelCollection = modelCollection;
    }

    public C entriesListIsNotEmpty() {
        Step.STEP((String)"REST API: Assert that entries list from response is not empty");
        Assert.assertFalse((boolean)this.modelCollection.isEmpty(), (String)"Entries list from response is empty.Check the logs for more details!");
        return (C)this.modelCollection;
    }

    public C entriesListIsEmpty() {
        Step.STEP((String)"REST API: Assert that entries list from response is empty");
        Assert.assertTrue((boolean)this.modelCollection.isEmpty(), (String)"Entries list from response is not empty.Check the logs for more details!");
        return (C)this.modelCollection;
    }

    public C entriesListCountIs(int expectedCount) {
        Step.STEP((String)String.format("REST API: Assert that entries list count is %d", expectedCount));
        int actualSize = this.modelCollection.getEntries().size();
        Assert.assertEquals((int)actualSize, (int)expectedCount);
        return (C)this.modelCollection;
    }

    public C entriesListContains(String key, String value) {
        List modelEntries = this.modelCollection.getEntries();
        String fieldValue = "";
        for (Model m : modelEntries) {
            Object model = this.loadModel(m);
            try {
                ObjectMapper mapper = new ObjectMapper();
                String jsonInString = mapper.writeValueAsString(model);
                fieldValue = (String)JsonPath.with((String)jsonInString).get(key);
                if (fieldValue == null || !fieldValue.equals(value)) continue;
                break;
            }
            catch (Exception e) {
                throw new TestConfigurationException(String.format("You try to assert field [%s] that doesn't exist in class: [%s]. Exception: %s, Please check your code!", key, this.getClass().getCanonicalName(), e.getMessage()));
            }
        }
        Assert.assertEquals((String)fieldValue, (String)value, (String)String.format("Entry with key: [%s] with value [%s] not found in list", key, value));
        return (C)this.modelCollection;
    }

    public C entriesListDoesNotContain(String key, String value) {
        boolean exist = false;
        List modelEntries = this.modelCollection.getEntries();
        for (Model m : modelEntries) {
            Object model = this.loadModel(m);
            String fieldValue = "";
            try {
                ObjectMapper mapper = new ObjectMapper();
                String jsonInString = mapper.writeValueAsString(model);
                fieldValue = (String)JsonPath.with((String)jsonInString).get(key);
                if (fieldValue == null || !fieldValue.equals(value)) continue;
                exist = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        Assert.assertFalse((boolean)exist, (String)String.format("Entry with key: %s and value %s was found in list", key, value));
        return (C)this.modelCollection;
    }

    public C entrySetContains(String key, String ... expectedValues) {
        return this.entrySetContains(key, Arrays.stream(expectedValues).collect(Collectors.toSet()));
    }

    public C entrySetContains(String key, Collection<String> expectedValues) {
        Collection actualValues = this.modelCollection.getEntries().stream().map(model -> this.extractValueAsString((Model)model, key)).collect(Collectors.toSet());
        Assert.assertTrue((boolean)actualValues.containsAll(expectedValues), (String)String.format("Entry with key: \"%s\" is expected to contain values: %s, but actual values are: %s", key, expectedValues, actualValues));
        return (C)this.modelCollection;
    }

    public C entrySetMatches(String key, Collection<String> expectedValues) {
        Collection actualValues = this.modelCollection.getEntries().stream().map(model -> this.extractValueAsString((Model)model, key)).collect(Collectors.toSet());
        Assert.assertEqualsNoOrder((Collection)actualValues, expectedValues, (String)String.format("Entry with key: \"%s\" is expected to match values: %s, but actual values are: %s", key, expectedValues, actualValues));
        return (C)this.modelCollection;
    }

    private String extractValueAsString(Model model, String key) {
        String fieldValue;
        Object modelObject = this.loadModel(model);
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonInString = mapper.writeValueAsString(modelObject);
            fieldValue = (String)JsonPath.with((String)jsonInString).get(key);
        }
        catch (Exception e) {
            throw new TestConfigurationException(String.format("You try to assert field [%s] that doesn't exist in class: [%s]. Exception: %s, Please check your code!", key, this.getClass().getCanonicalName(), e.getMessage()));
        }
        return fieldValue;
    }

    public C entriesListDoesNotContain(String key) {
        boolean exist = this.modelInList(key);
        Assert.assertFalse((boolean)exist, (String)String.format("Entry list contains key: %s", key));
        return (C)this.modelCollection;
    }

    public C entriesListContains(String key) {
        boolean exist = this.modelInList(key);
        Assert.assertTrue((boolean)exist, (String)String.format("Entry list doesn't contain key: %s", key));
        return (C)this.modelCollection;
    }

    private boolean modelInList(String key) {
        List modelEntries = this.modelCollection.getEntries();
        for (Model m : modelEntries) {
            String jsonInString;
            Object model = this.loadModel(m);
            ObjectMapper mapper = new ObjectMapper();
            try {
                jsonInString = mapper.writeValueAsString(model);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Failed to convert model to string.", e);
            }
            Object fieldValue = JsonPath.with((String)jsonInString).get(key);
            if (fieldValue == null) continue;
            return true;
        }
        return false;
    }

    public C paginationExist() {
        Step.STEP((String)"REST API: Assert that response has pagination");
        Assert.assertNotNull((Object)this.modelCollection.getPagination(), (String)"Pagination is was not found in the response");
        return (C)this.modelCollection;
    }

    public PaginationAssertionVerbs paginationField(String field) {
        return new PaginationAssertionVerbs(this.modelCollection, field, this.modelCollection.getPagination());
    }

    public C entriesListIsSortedAscBy(String field) {
        List modelEntries = this.modelCollection.getEntries();
        ArrayList<String> fieldValues = new ArrayList<String>();
        for (Model m : modelEntries) {
            Object model = this.loadModel(m);
            String fieldValue = "";
            try {
                fieldValue = BeanUtils.getProperty((Object)model, (String)field);
                fieldValues.add(fieldValue);
            }
            catch (Exception exception) {}
        }
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(fieldValues), (String)String.format("Entries are not ordered ASC by %s", field));
        return (C)this.modelCollection;
    }

    public C entriesListIsSortedDescBy(String field) {
        List modelEntries = this.modelCollection.getEntries();
        ArrayList<String> fieldValues = new ArrayList<String>();
        for (Model m : modelEntries) {
            Object model = this.loadModel(m);
            String fieldValue = "";
            try {
                fieldValue = BeanUtils.getProperty((Object)model, (String)field);
                fieldValues.add(fieldValue);
            }
            catch (Exception exception) {}
        }
        Assert.assertTrue((boolean)Ordering.natural().reverse().isOrdered(fieldValues), (String)String.format("Entries are not ordered DESC by %s", field));
        return (C)this.modelCollection;
    }

    private Object loadModel(Model m) {
        try {
            Method method = m.getClass().getMethod("onModel", new Class[0]);
            return method.invoke((Object)m, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to load model using reflection.", e);
        }
    }
}

