/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.io.Console;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.core.swagger.Generator;
import org.alfresco.rest.core.swagger.RestModelProperty;

public class SwaggerModel {
    private Swagger swagger;
    private Map.Entry<String, Model> model;
    private Path modelsPath = Paths.get(Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile().getPath(), "src/main/java/org/alfresco/rest/model");
    private List<RestModelProperty> properties = new ArrayList<RestModelProperty>();
    private Configuration cfg;

    private Configuration getConfig() throws IOException {
        if (this.cfg == null) {
            this.cfg = new Configuration(Configuration.VERSION_2_3_23);
            this.cfg.setDirectoryForTemplateLoading(new File("src/main/resources"));
        }
        return this.cfg;
    }

    public SwaggerModel(Map.Entry<String, Model> model, Swagger swagger) {
        this.model = model;
        this.swagger = swagger;
        if (model.getValue().getProperties() != null) {
            for (Map.Entry<String, Property> entry : model.getValue().getProperties().entrySet()) {
                if (((String)entry.getKey()).equals("entry")) continue;
                this.properties.add(RestModelProperty.build(entry));
            }
        }
    }

    public boolean exist() {
        return this.getPath().exists();
    }

    public File getPath() {
        return Paths.get(this.modelsPath.toFile().getPath(), this.getNameInTAS() + ".java").toFile();
    }

    public String getName() {
        return this.model.getKey();
    }

    public String getNameInTAS() {
        return String.format("Rest%sModel", this.getName());
    }

    public List<RestModelProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<RestModelProperty> properties) {
        this.properties = properties;
    }

    public void generate() throws IOException, TemplateException {
        Template template = this.getConfig().getTemplate("rest-model.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("date", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
        data.put("author", System.getProperty("user.name"));
        data.put("yamlTitle", this.swagger.getInfo().getTitle());
        data.put("yamlBasePath", this.swagger.getBasePath());
        data.put("name", this.getNameInTAS());
        if (!this.getProperties().isEmpty()) {
            data.put("properties", this.getProperties());
        }
        StringWriter append = new StringWriter();
        template.process(data, (Writer)append);
        ((Writer)append).close();
        System.out.println("----- " + this.getPath().getName() + " -----\n");
        System.out.println(Generator.line);
        System.out.println(((Object)append).toString());
        System.out.printf("\nGenerating Model: %-10s to ->'%-60s'", this.getName(), this.getPath());
        if (this.exist()) {
            Console c = System.console();
            if (c != null) {
                System.out.printf("There is already one model created locally: \n%s\nDo you want to override it ?(ENTER=yes, any other key=no):", this.getPath());
                if (c.readLine().length() == 0) {
                    this.writeContent(((Object)append).toString());
                }
            }
        } else {
            this.writeContent(((Object)append).toString());
        }
    }

    private void writeContent(String content) throws IOException {
        FileWriter fw = new FileWriter(this.getPath());
        fw.write(content);
        fw.close();
    }
}

