/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestArchiveContentRequestModel;
import org.alfresco.rest.model.RestContentStorageInfoModel;
import org.alfresco.rest.model.RestRestoreArchivedContentRequestModel;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.TestModel;
import org.springframework.http.HttpMethod;

public class ContentStorageInformation
extends ModelRequest<ContentStorageInformation> {
    private static final String BASE_PATH = "nodes/{nodeId}/storage-info/{contentPropName}";
    private static final String VERSIONS_BASE_PATH = "nodes/{nodeId}/versions/{versionId}/storage-info/{contentPropName}";
    private static final String ARCHIVE_PATH_SUFFIX = "/archive";
    private static final String ARCHIVE_RESTORE_PATH_SUFFIX = "/archive-restore";
    private String nodeId;
    private String contentPropName;
    private String versionId;

    public ContentStorageInformation(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public ContentStorageInformation withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public ContentStorageInformation withContentPropName(String contentPropName) {
        this.contentPropName = contentPropName;
        return this;
    }

    public ContentStorageInformation withVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public RestContentStorageInfoModel getStorageInfo() {
        return this.getStorageInfo(this.nodeId, this.contentPropName);
    }

    public RestContentStorageInfoModel getVersionStorageInfo() {
        return this.getVersionStorageInfo(this.nodeId, this.versionId, this.contentPropName);
    }

    public RestContentStorageInfoModel getStorageInfo(String nodeId, String contentPropName) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, BASE_PATH, nodeId, contentPropName);
        return this.restWrapper.processModel(RestContentStorageInfoModel.class, request);
    }

    public RestContentStorageInfoModel getVersionStorageInfo(String nodeId, String versionId, String contentPropName) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, VERSIONS_BASE_PATH, nodeId, versionId, contentPropName);
        return this.restWrapper.processModel(RestContentStorageInfoModel.class, request);
    }

    public RestResponse requestArchiveContent(RestArchiveContentRequestModel archiveContentRequest) {
        return this.requestArchiveContent(this.nodeId, this.contentPropName, archiveContentRequest);
    }

    public RestResponse requestArchiveVersionContent(RestArchiveContentRequestModel archiveContentRequest) {
        return this.requestArchiveVersionContent(this.nodeId, this.contentPropName, this.versionId, archiveContentRequest);
    }

    public RestResponse requestArchiveContent(String nodeId, String contentPropName, RestArchiveContentRequestModel archiveContentRequest) {
        RestRequest request = this.createRestRequestWithBody(HttpMethod.POST, archiveContentRequest, "nodes/{nodeId}/storage-info/{contentPropName}/archive", nodeId, contentPropName);
        return this.restWrapper.process(request);
    }

    public RestResponse requestArchiveVersionContent(String nodeId, String contentPropName, String versionId, RestArchiveContentRequestModel archiveContentRequest) {
        RestRequest request = this.createRestRequestWithBody(HttpMethod.POST, archiveContentRequest, "nodes/{nodeId}/versions/{versionId}/storage-info/{contentPropName}/archive", nodeId, versionId, contentPropName);
        return this.restWrapper.process(request);
    }

    public RestResponse requestRestoreContentFromArchive(RestRestoreArchivedContentRequestModel restoreArchivedContentRequest) {
        return this.requestRestoreContentFromArchive(this.nodeId, this.contentPropName, restoreArchivedContentRequest);
    }

    public RestResponse requestRestoreVersionContentFromArchive(RestRestoreArchivedContentRequestModel restoreArchivedContentRequest) {
        return this.requestRestoreVersionContentFromArchive(this.nodeId, this.contentPropName, this.versionId, restoreArchivedContentRequest);
    }

    public RestResponse requestRestoreContentFromArchive(String nodeId, String contentPropName, RestRestoreArchivedContentRequestModel restoreArchivedContentRequest) {
        RestRequest request = this.createRestRequestWithBody(HttpMethod.POST, restoreArchivedContentRequest, "nodes/{nodeId}/storage-info/{contentPropName}/archive-restore", nodeId, contentPropName);
        return this.restWrapper.process(request);
    }

    public RestResponse requestRestoreVersionContentFromArchive(String nodeId, String contentPropName, String versionId, RestRestoreArchivedContentRequestModel restoreArchivedContentRequest) {
        RestRequest request = this.createRestRequestWithBody(HttpMethod.POST, restoreArchivedContentRequest, "nodes/{nodeId}/versions/{versionId}/storage-info/{contentPropName}/archive-restore", nodeId, versionId, contentPropName);
        return this.restWrapper.process(request);
    }

    private RestRequest createRestRequestWithBody(HttpMethod httpMethod, TestModel request, String path, String ... pathParams) {
        if (request != null) {
            return RestRequest.requestWithBody(httpMethod, request.toJson(), path, pathParams);
        }
        return RestRequest.simpleRequest(httpMethod, path, pathParams);
    }
}

