/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestFormModelsCollection;
import org.alfresco.rest.model.RestHtmlResponse;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.Utility;
import org.springframework.http.HttpMethod;

public class ProcessDefinitions
extends ModelRequest<ProcessDefinitions> {
    RestProcessDefinitionModel processDefinition;

    public ProcessDefinitions(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public ProcessDefinitions(RestProcessDefinitionModel processDefinition, RestWrapper restWrapper) {
        super(restWrapper);
        this.processDefinition = processDefinition;
    }

    public RestProcessDefinitionModelsCollection getAllProcessDefinitions() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "process-definitions?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestProcessDefinitionModelsCollection.class, request);
    }

    public RestProcessDefinitionModel getProcessDefinition() {
        Utility.checkObjectIsInitialized((Object)this.processDefinition, (String)"processDefinition");
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "process-definitions/{processDefinitionId}?{parameters}", this.processDefinition.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestProcessDefinitionModel.class, request);
    }

    public RestHtmlResponse getProcessDefinitionImage() {
        Utility.checkObjectIsInitialized((Object)this.processDefinition, (String)"processDefinition");
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "process-definitions/{processDefinitionId}/image", this.processDefinition.getId());
        return this.restWrapper.processHtmlResponse(request);
    }

    public RestFormModelsCollection getProcessDefinitionStartFormModel() {
        Utility.checkObjectIsInitialized((Object)this.processDefinition, (String)"processDefinition.onModel()");
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "process-definitions/{processDefinitionId}/start-form-model?{parameters}", this.processDefinition.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestFormModelsCollection.class, request);
    }
}

