/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class DeleteCategoriesTests
extends CategoriesRestTest {
    @Test(groups={"rest-api"})
    public void testDeleteCategory() {
        Step.STEP((String)"Create a category and send a request to delete it.");
        RestCategoryModel aCategory = this.prepareCategoryUnderRoot();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(aCategory).deleteCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"Ensure that the category has been deleted by sending a GET request and receiving 404.");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(aCategory).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testDeleteCategoryAsRegularUser_andFail() {
        RestCategoryModel aCategory = this.prepareCategoryUnderRoot();
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(aCategory).deleteCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Current user does not have permission to manage a category");
    }

    @Test(groups={"rest-api"})
    public void testDeleteNonExistentCategory() {
        Step.STEP((String)"Get category with non-existent id");
        String id = "non-existing-dummy-id";
        RestCategoryModel rootCategory = this.createCategoryModelWithId("non-existing-dummy-id");
        Step.STEP((String)"Attempt to delete category with non-existent id and receive 404");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).deleteCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testDeleteCategory_givenNonCategoryNodeId() {
        Step.STEP((String)"Create a site and a folder inside it");
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        String id = folder.getNodeRef();
        Step.STEP((String)"Create a category, set its id to the folder id and attempt to delete it");
        RestCategoryModel aCategory = this.createCategoryModelWithId(id);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(aCategory).deleteCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Node id does not refer to a valid category");
    }
}

