/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import jakarta.json.JsonArrayBuilder;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpMethod;

public class Processes
extends ModelRequest<Processes> {
    private ProcessModel processModel;

    public Processes(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public Processes(ProcessModel processModel, RestWrapper restWrapper) {
        this(restWrapper);
        this.processModel = processModel;
    }

    public RestProcessModelsCollection getProcesses() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "processes?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestProcessModelsCollection.class, request);
    }

    public RestProcessVariableCollection getProcessVariables() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "processes/{processId}/variables?{parameters}", this.processModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestProcessVariableCollection.class, request);
    }

    public RestProcessModel getProcess() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "processes/{processId}?{parameters}", this.processModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestProcessModel.class, request);
    }

    public void deleteProcess() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "processes/{processId}", this.processModel.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestProcessModel addProcess(String processDefinitionKey, UserModel assignee, boolean sendEmailNotifications, CMISUtil.Priority priority) {
        String postBody = JsonBodyGenerator.process(processDefinitionKey, assignee, sendEmailNotifications, priority);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes", new String[0]);
        return this.restWrapper.processModel(RestProcessModel.class, request);
    }

    public RestProcessModel addProcessWithBody(String postBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes", new String[0]);
        return this.restWrapper.processModel(RestProcessModel.class, request);
    }

    public RestProcessVariableModel addProcessVariable(RestProcessVariableModel variableModel) {
        String postBody = JsonBodyGenerator.processVariable(variableModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes/{processId}/variables", this.processModel.getId());
        return this.restWrapper.processModel(RestProcessVariableModel.class, request);
    }

    public RestProcessVariableCollection addProcessVariables(RestProcessVariableModel ... processVariablesModel) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (RestProcessVariableModel processVariableModel : processVariablesModel) {
            array.add(JsonBodyGenerator.defineJSON().add("name", processVariableModel.getName()).add("value", processVariableModel.getValue()).add("type", processVariableModel.getType())).toString();
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes/{processId}/variables", this.processModel.getId());
        return this.restWrapper.processModels(RestProcessVariableCollection.class, request);
    }

    public RestItemModelsCollection getProcessItems() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "processes/{processId}/items?{parameters}", this.processModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestItemModelsCollection.class, request);
    }

    public void deleteProcessVariable(RestProcessVariableModel variableModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "processes/{processId}/variables/{variableName}", this.processModel.getId(), variableModel.getName());
        this.restWrapper.processEmptyModel(request);
    }

    public RestProcessVariableModel updateProcessVariable(RestProcessVariableModel variableModel) {
        String postBody = JsonBodyGenerator.processVariable(variableModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, postBody, "processes/{processId}/variables/{variableName}", this.processModel.getId(), variableModel.getName());
        return this.restWrapper.processModel(RestProcessVariableModel.class, request);
    }

    public RestTaskModelsCollection getProcessTasks() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "processes/{processId}/tasks?{parameters}", this.processModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestTaskModelsCollection.class, request);
    }

    public RestItemModel addProcessItem(FileModel fileModel) {
        String postBody = JsonBodyGenerator.keyValueJson("id", fileModel.getNodeRefWithoutVersion());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes/{processId}/items", this.processModel.getId());
        return this.restWrapper.processModel(RestItemModel.class, request);
    }

    public RestItemModelsCollection addProcessItems(FileModel ... fileModels) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (FileModel fileModel : fileModels) {
            array.add(JsonBodyGenerator.defineJSON().add("id", fileModel.getNodeRefWithoutVersion()));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "processes/{processId}/items", this.processModel.getId());
        return this.restWrapper.processModels(RestItemModelsCollection.class, request);
    }

    public void deleteProcessItem(RestItemModel itemModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "processes/{processId}/items/{itemId}", this.processModel.getId(), itemModel.getId());
        this.restWrapper.processEmptyModel(request);
    }
}

