/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software.
 * If the software was purchased under a paid Alfresco license, the terms of
 * the paid license agreement will prevail.  Otherwise, the software is
 * provided under the following open source license terms:
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.alfresco.rest.model;

import java.util.List;
import java.util.Objects;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Generated by 'mpichura' on '2022-10-05 09:58' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/alfresco/versions/1}
 */
public class RestActionConstraintModel extends TestModel implements IRestModel<RestActionConstraintModel>
{
    @JsonProperty(value = "entry")
    RestActionConstraintModel model;

    @Override
    public RestActionConstraintModel onModel()
    {
        return model;
    }

    /**
    Name of the constraint.

    */	        

    private String constraintName;
    /**
    A list of constraint possbile values along with additional data (label, isNode flag).
Sample object could be:
```JSON
"constraintValues": [
           {
              "value": "EQUALS",
              "label": "Equals"
           },
           {
              "value": "CONTAINS",
              "label": "Contains"
           },
           {
              "value": "BEGINS",
              "label": "Begins With"
           },
           {
              "value": "ENDS",
              "label": "Ends With"
           },
           {
              "value": "GREATER_THAN",
              "label": "Greater Than"
           },
           {
              "value": "GREATER_THAN_EQUAL",
              "label": "Greater Than Or Equal To"
           },
           {
              "value": "LESS_THAN",
              "label": "Less Than"
           },
           {
              "value": "LESS_THAN_EQUAL",
              "label": "Less Than Or Equal To"
           }
        ]
    */	        

    private List<RestActionConstraintDataModel> constraintValues;	    

    public String getConstraintName()
    {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName)
    {
        this.constraintName = constraintName;
    }				

    public List<RestActionConstraintDataModel> getConstraintValues()
    {
        return this.constraintValues;
    }

    public void setConstraintValues(List<RestActionConstraintDataModel> constraintValues)
    {
        this.constraintValues = constraintValues;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RestActionConstraintModel that = (RestActionConstraintModel) o;
        return constraintName.equals(that.constraintName) && Objects.equals(constraintValues, that.constraintValues);
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(constraintName, constraintValues);
    }
}
 
