/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessItemsCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel adminUser;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private RestProcessModel processModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin calling getProcessItems can see anything with REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsAsAdminReturnsAnything() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.document);
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListIsNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify getProcessItems for invalid processId with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsForInvalidProcessId() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("invalidProcessId");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify getProcessItems for empty processId with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessItemsForEmptyProcessId() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems().assertThat().entriesListIsEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }
}

